/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.selectionByTheme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.selectionByTheme.SelectionByThemeListener;
import org.gvsig.app.gui.selectionByTheme.SelectionByThemeModel;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.task.JTaskStatus;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.utils.swing.JComboBox;

public class SelectionByTheme
extends JPanel
implements IWindow {
    private static final long serialVersionUID = -5094042907941800674L;
    public static final int EQUALS = 0;
    public static final int DISJOINT = 1;
    public static final int INTERSECTS = 2;
    public static final int TOUCHES = 3;
    public static final int CROSSES = 4;
    public static final int WITHIN = 5;
    public static final int CONTAINS = 6;
    public static final int OVERLAPS = 7;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    public final String[] textosAcciones = new String[]{this.i18nManager.getTranslation("Sean_iguales_a"), this.i18nManager.getTranslation("Sean_disjuntos_a"), this.i18nManager.getTranslation("Intersecten_con"), this.i18nManager.getTranslation("Toquen"), this.i18nManager.getTranslation("Crucen_con"), this.i18nManager.getTranslation("Contengan"), this.i18nManager.getTranslation("Esten_contenidos_en"), this.i18nManager.getTranslation("Se_superponen_a")};
    private SelectionByThemeModel dataSource = null;
    private List<SelectionByThemeListener> listeners = new ArrayList<SelectionByThemeListener>();
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JComboBox cmbAction = null;
    private JLabel jLabel1 = null;
    private JComboBox cmbCapas = null;
    private JButton btnNew = null;
    private JButton btnAdd = null;
    private JButton btnFrom = null;
    private JButton btnCancel = null;
    private JTaskStatus jtaskStatus;

    public SelectionByTheme() {
        this.initialize();
    }

    private void initialize() {
        this.jtaskStatus = ToolsSwingLocator.getTaskStatusSwingManager().createJTaskStatus();
        this.jtaskStatus.setShowRemoveTaskButton(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 21;
        c.insets = new Insets(3, 10, 3, 10);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getJLabel(), c);
        c.gridy = 1;
        this.add((Component)this.getCmbAction(), c);
        c.gridy = 2;
        this.add((Component)this.getJLabel1(), c);
        c.gridy = 3;
        this.add((Component)this.getCmbCapas(), c);
        c.gridy = 4;
        c.gridwidth = 2;
        this.add((Component)this.jtaskStatus.asJComponent(), c);
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        this.add((Component)this.getBtnNew(), c);
        c.gridy = 1;
        this.add((Component)this.getBtnAdd(), c);
        c.gridy = 2;
        this.add((Component)this.getBtnFrom(), c);
        c.gridy = 3;
        this.add((Component)this.getBtnCancel(), c);
        this.setSize(540, 175);
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(this.i18nManager.getTranslation("Seleccionar_de_las_capas_activas_los_elementos_que"));
            this.jLabel.setVerticalAlignment(3);
            this.jLabel.setToolTipText(this.i18nManager.getTranslation("select_from_the_active_layers"));
        }
        return this.jLabel;
    }

    private JComboBox getCmbAction() {
        if (this.cmbAction == null) {
            this.cmbAction = new JComboBox();
            this.cmbAction.setPreferredSize(new Dimension(200, 20));
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.textosAcciones);
            this.cmbAction.setModel(model);
        }
        return this.cmbAction;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(this.i18nManager.getTranslation("Elementos_seleccionados_de_la_capa").concat(":"));
            this.jLabel1.setVerticalAlignment(3);
            this.jLabel1.setToolTipText(this.i18nManager.getTranslation("layer_to_which_belong_the_elements_selected_previously"));
        }
        return this.jLabel1;
    }

    private JComboBox getCmbCapas() {
        if (this.cmbCapas == null) {
            this.cmbCapas = new JComboBox();
            this.cmbCapas.setPreferredSize(new Dimension(200, 20));
        }
        return this.cmbCapas;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setText(this.i18nManager.getTranslation("_New_selection"));
            this.btnNew.setMargin(new Insets(3, 3, 3, 3));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionByTheme.this.callNewListeners(SelectionByTheme.this.cmbCapas.getSelectedIndex(), SelectionByTheme.this.cmbAction.getSelectedIndex());
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(this.i18nManager.getTranslation("_Add_to_selection"));
            this.btnAdd.setMargin(new Insets(3, 3, 3, 3));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionByTheme.this.callAddToListeners(SelectionByTheme.this.cmbCapas.getSelectedIndex(), SelectionByTheme.this.cmbAction.getSelectedIndex());
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnFrom() {
        if (this.btnFrom == null) {
            this.btnFrom = new JButton();
            this.btnFrom.setText(this.i18nManager.getTranslation("_Intersect_with_selection"));
            this.btnFrom.setMargin(new Insets(3, 3, 3, 3));
            this.btnFrom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionByTheme.this.callFromListeners(SelectionByTheme.this.cmbCapas.getSelectedIndex(), SelectionByTheme.this.cmbAction.getSelectedIndex());
                }
            });
        }
        return this.btnFrom;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(this.i18nManager.getTranslation("_Close"));
            this.btnCancel.setMargin(new Insets(3, 3, 3, 3));
            this.btnCancel.addActionListener(e -> this.setVisible(false));
        }
        return this.btnCancel;
    }

    public SelectionByThemeModel getModel() {
        return this.dataSource;
    }

    public void setModel(SelectionByThemeModel source) {
        this.dataSource = source;
        String[] nameLayers = new String[this.dataSource.getLayers().getLayersCount()];
        for (int i = 0; i < nameLayers.length; ++i) {
            nameLayers[i] = this.dataSource.getLayers().getLayer(i).getName();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(nameLayers);
        this.cmbCapas.setModel(model);
    }

    public WindowInfo getWindowInfo() {
        WindowInfo vi = new WindowInfo(8);
        vi.setWidth(this.getWidth());
        vi.setHeight(this.getHeight());
        vi.setTitle(this.i18nManager.getTranslation("Seleccion_por_capa"));
        return vi;
    }

    private void callNewListeners(int selection, int actionCode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SelectionByThemeListener l = this.listeners.get(i);
            l.newSet(this.dataSource.getLayers().getActives(), this.dataSource.getLayers().getLayer(selection), actionCode);
        }
    }

    private void callAddToListeners(int selection, int actionCode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SelectionByThemeListener l = this.listeners.get(i);
            l.addToSet(this.dataSource.getLayers().getActives(), this.dataSource.getLayers().getLayer(selection), actionCode);
        }
    }

    private void callFromListeners(int selection, int actionCode) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SelectionByThemeListener l = this.listeners.get(i);
            l.fromSet(this.dataSource.getLayers().getActives(), this.dataSource.getLayers().getLayer(selection), actionCode);
        }
    }

    public boolean addSelectionListener(SelectionByThemeListener arg0) {
        return this.listeners.add(arg0);
    }

    public boolean removeSelectionListener(SelectionByThemeListener arg0) {
        return this.listeners.remove(arg0);
    }

    public void viewActivated() {
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public SimpleTaskStatus getTaskStatus() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String layersStr = this.getLayersNames(this.dataSource.getLayers().getActives());
        String title = i18n.getTranslation("_Selecting") + " " + layersStr;
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(title);
        this.jtaskStatus.bind((TaskStatus)status);
        status.setTitle(title);
        return status;
    }

    protected String getLayersNames(FLayer[] layers) {
        String layersStr = null;
        for (FLayer layer : layers) {
            if (!(layer instanceof FLyrVect)) continue;
            layersStr = layersStr == null ? layer.getName() : layersStr + ", " + layer.getName();
        }
        return layersStr;
    }
}

