/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.panelGroup.loaders;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.panelGroup.exceptions.ListCouldntLoadPanelException;
import org.gvsig.gui.beans.panelGroup.exceptions.PanelBaseException;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelGroupLoaderFromExtensionPoint
implements IPanelGroupLoader,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(PanelGroupLoaderFromExtensionPoint.class);
    private static final long serialVersionUID = 6810333457209196344L;
    private String id;

    public PanelGroupLoaderFromExtensionPoint(String id) {
        this.id = id;
    }

    public void loadPanels(ArrayList<IPanel> panels) throws ListCouldntLoadPanelException {
        if (this.id == null) {
            return;
        }
        ExtensionPointManager ePManager = ToolsLocator.getExtensionPointManager();
        ListCouldntLoadPanelFromExtensionPointException lCLPException = null;
        Iterator iterator = null;
        try {
            if (!ePManager.has(this.id)) {
                return;
            }
            iterator = ePManager.get(this.id).iterator();
        }
        catch (Exception e) {
            logger.debug(PluginServices.getText((Object)this, (String)"panel_loading_exception"), (Throwable)e);
            if (lCLPException == null) {
                lCLPException = new ListCouldntLoadPanelFromExtensionPointException();
            }
            lCLPException.add(e);
        }
        AbstractPanel panel = null;
        while (iterator.hasNext()) {
            try {
                panel = (AbstractPanel)((ExtensionPoint.Extension)iterator.next()).create();
                panels.add((IPanel)panel);
            }
            catch (Exception e) {
                logger.debug(PluginServices.getText((Object)this, (String)"panel_loading_exception"), (Throwable)e);
                if (lCLPException == null) {
                    lCLPException = new ListCouldntLoadPanelFromExtensionPointException();
                }
                PanelBaseException bew = null;
                bew = panel == null ? new PanelBaseException(e, "") : new PanelBaseException(e, panel.getLabel());
                lCLPException.add(bew);
            }
        }
        Collections.sort(panels);
        if (lCLPException != null) {
            throw lCLPException;
        }
    }

    public class ListCouldntLoadPanelFromExtensionPointException
    extends ListCouldntLoadPanelException {
        private static final long serialVersionUID = -1513294728326593385L;
        private static final String formatString = "Couldn't load some panels from an extension point of classes:";
        private static final String messageKey = "couldnt_load_panels_from_extension_point_exception";

        public ListCouldntLoadPanelFromExtensionPointException() {
            super(formatString, messageKey, -1513294728326593385L);
        }

        protected Map<String, String> values() {
            return null;
        }
    }
}

