/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.actions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocumentAction;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.actions.CopyPasteDocsUtils;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDocumentAction
extends AbstractDocumentAction {
    private static Logger logger = LoggerFactory.getLogger(CopyDocumentAction.class);

    public CopyDocumentAction() {
        super("copy");
        this.order = 0;
        this.title = Messages.getText((String)"copiar");
        this.group = ProjectManager.getInstance().addDocumentActionGroup("ClipboardActions", "Clipboard actions", null, 0);
    }

    @Override
    public void execute(Document document, List<Document> documents) {
        ArrayList<Document> docs = new ArrayList<Document>(documents);
        if (document != null && !docs.contains(document)) {
            docs.add(document);
        }
        try {
            CopyPasteDocsUtils.saveToClipboard(docs);
        }
        catch (Exception e) {
            logger.info("While copying docs to clipboard.", (Throwable)e);
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Clipboard_error") + ":\n" + CopyPasteDocsUtils.getLastMessage(e), this.title, 0);
            try {
                CopyPasteDocsUtils.clearClipboard(null);
            }
            catch (Exception exc) {
                logger.error("While clearing clipboard.", (Throwable)exc);
            }
        }
    }

    @Override
    public boolean isAvailable(Document document, List<Document> selectedItems) {
        return selectedItems.size() > 0;
    }

    @Override
    public boolean isVisible(Document document, List<Document> documents) {
        return true;
    }
}

