/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui.projectpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.gui.DocumentContextMenu;
import org.gvsig.app.project.documents.gui.ProjectGeneralPropertiesPage;
import org.gvsig.app.project.documents.gui.ProjectProperties;
import org.gvsig.app.project.documents.gui.projectpanel.ProjectDocumentsPanelPageView;
import org.gvsig.app.project.documents.gui.projectpanel.ProjectPanelPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.Invocable;
import org.gvsig.utils.DefaultListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDocumentsPanelPage
extends ProjectDocumentsPanelPageView
implements ProjectPanelPage {
    private final Logger LOG = LoggerFactory.getLogger(ProjectGeneralPropertiesPage.class);
    private Project project = null;
    private DocumentManager currentDocumentType;
    private final PropertyChangeListener projectPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProjectDocumentsPanelPage.this.updateProject();
        }
    };
    private final Observer projectObserver = new Observer(){

        public void update(Observable observable, Object notification) {
            ProjectDocumentsPanelPage.this.updateProject();
        }
    };

    public ProjectDocumentsPanelPage() {
        this.initComponents();
    }

    public void setData(Object data) {
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Documents");
    }

    public int getPriority() {
        return 1000;
    }

    public boolean whenAccept() {
        return true;
    }

    public boolean whenApply() {
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.initDocumentTypes();
        this.btnDocumentNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doDocumentNew();
            }
        });
        this.btnDocumentOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doDocumentOpen();
            }
        });
        this.btnDocumentRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doDocumentRename();
            }
        });
        this.btnDocumentDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doDocumentDelete();
            }
        });
        this.btnDocumentProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doDocumentProperties();
            }
        });
        this.btnProjectProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDocumentsPanelPage.this.doProjectProperties();
            }
        });
        this.lstDocuments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ProjectDocumentsPanelPage.this.doDocumentsSelectionChanged();
            }
        });
        this.lstDocuments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    ProjectDocumentsPanelPage.this.doDocumentOpen();
                }
            }
        });
        this.lstDocuments.addMouseListener(new MouseAdapter(){

            public Document[] getSelecteds() {
                if (ProjectDocumentsPanelPage.this.lstDocuments.getSelectedIndex() < 0) {
                    return null;
                }
                Object[] seleteds = ProjectDocumentsPanelPage.this.lstDocuments.getSelectedValues();
                Document[] returnValue = new Document[seleteds.length];
                System.arraycopy(seleteds, 0, returnValue, 0, seleteds.length);
                return returnValue;
            }

            public Document getItem(MouseEvent e) {
                if (ProjectDocumentsPanelPage.this.lstDocuments.getSelectedIndex() < 0) {
                    return null;
                }
                return (Document)ProjectDocumentsPanelPage.this.lstDocuments.getSelectedValue();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    Object[] selecteds = this.getSelecteds();
                    Document item = this.getItem(e);
                    if (item == null || ArrayUtils.isEmpty((Object[])selecteds)) {
                        return;
                    }
                    DocumentContextMenu menu = new DocumentContextMenu(item.getTypeName(), item, (Document[])selecteds);
                    if (!menu.hasActions()) {
                        return;
                    }
                    ProjectDocumentsPanelPage.this.lstDocuments.add(menu);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (e.getClickCount() == 2) {
                    ProjectDocumentsPanelPage.this.doDocumentOpen();
                }
            }
        });
        this.lstDocuments.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                c.setIcon(null);
                if (value instanceof Document) {
                    Document doc = (Document)value;
                    if (((Document)value).isTemporary()) {
                        c.setIcon(IconThemeHelper.getImageIcon((String)"temporary-table-icon"));
                    }
                }
                return c;
            }
        });
        this.translate();
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblSavedIn);
        manager.translate(this.lblSessionName);
        manager.translate((JComponent)this.lblDocument);
        manager.translate((JComponent)this.lblDocumentTypes);
        manager.translate((JComponent)this.lblSessionProperties);
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblCreationDate);
        manager.translate(this.lblCreationDate);
        manager.translate((AbstractButton)this.btnDocumentDelete);
        manager.translate((AbstractButton)this.btnDocumentNew);
        manager.translate((AbstractButton)this.btnDocumentOpen);
        manager.translate((AbstractButton)this.btnDocumentProperties);
        manager.translate((AbstractButton)this.btnDocumentRename);
        manager.translate((AbstractButton)this.btnProjectProperties);
    }

    @Override
    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removePropertyChangeListener(this.projectPropertyChangeListener);
            this.project.deleteObserver(this.projectObserver);
        }
        this.project = project;
        if (project != null) {
            project.addPropertyChangeListener(this.projectPropertyChangeListener);
            project.addObserver(this.projectObserver);
        }
        this.updateProject();
    }

    private void updateProject() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectDocumentsPanelPage.this.updateProject();
                }
            });
            return;
        }
        this.updateProjectDocumens();
        this.updateProjectProperties();
    }

    private void updateProjectProperties() {
        if (this.project != null) {
            this.txtSessionName.setText(this.project.getName());
            File path = this.project.getFile();
            if (path != null) {
                this.txtSavedIn.setText(path.toString());
            } else {
                this.txtSavedIn.setText("");
            }
            this.txtCreationDate.setText(this.project.getCreationDate());
        }
    }

    private void initDocumentTypes() {
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        this.documentTypesContainer.setLayout(new FlowLayout(1, 5, 5));
        List<DocumentManager> factories = ProjectManager.getInstance().getDocumentManagers();
        Collections.sort(factories, new Comparator<DocumentManager>(){

            @Override
            public int compare(DocumentManager arg0, DocumentManager arg1) {
                return arg0.getPriority() - arg1.getPriority();
            }
        });
        this.currentDocumentType = factories.get(0);
        JRadioButton selectButton = null;
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        for (DocumentManager documentFactory : factories) {
            if (!identityManager.getCurrentIdentity().isAuthorized("project-document-access", (Object)documentFactory, documentFactory.getTypeName())) continue;
            JRadioButton button = this.createDocumentTypeButton(documentFactory);
            group.add(button);
            panel.add(button);
            if (documentFactory != this.currentDocumentType) continue;
            selectButton = button;
        }
        JScrollPane scroll = new JScrollPane(panel);
        Dimension dim = panel.getPreferredSize();
        scroll.setMinimumSize(new Dimension(dim.width + 2, dim.height + 35));
        scroll.setVerticalScrollBarPolicy(21);
        scroll.setHorizontalScrollBarPolicy(30);
        this.documentTypesContainer.setLayout(new BorderLayout());
        this.documentTypesContainer.add((Component)scroll, "Center");
        selectButton.setSelected(true);
    }

    private JRadioButton createDocumentTypeButton(final DocumentManager documentFactory) {
        final JRadioButton rb = new JRadioButton();
        rb.setIcon(documentFactory.getIcon());
        rb.setSelectedIcon(documentFactory.getIconSelected());
        rb.setHorizontalTextPosition(0);
        rb.setText(documentFactory.getTitle());
        rb.setVerticalTextPosition(3);
        rb.setName(documentFactory.getTypeName());
        rb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (rb.isSelected()) {
                    ProjectDocumentsPanelPage.this.currentDocumentType = documentFactory;
                    ProjectDocumentsPanelPage.this.updateProjectDocumens();
                }
            }
        });
        return rb;
    }

    private void openDocumentWindow(Document doc) {
        if (doc == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        IWindow window = doc.getFactory().getMainWindow(doc);
        if (window == null) {
            application.message(i18n.getTranslation("error_opening_the_document"), 2);
            return;
        }
        application.getUIManager().addWindow(window, 1816);
        this.project.setModified(true);
    }

    private void updateProjectDocumens() {
        if (this.project == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lblDocument.setText(i18n.getTranslation("documentos_existentes"));
        String documentsTypeName = this.currentDocumentType.getTypeName();
        List<Document> documents = this.project.getDocuments(documentsTypeName);
        DefaultListModel model = new DefaultListModel(documents);
        this.lstDocuments.setModel(model);
        this.lblDocument.setText(this.currentDocumentType.getTitle());
        this.updateDocumentButtons();
    }

    private void updateDocumentButtons() {
        this.btnDocumentNew.setEnabled(true);
        if (this.lstDocuments.getSelectedIndex() != -1) {
            this.btnDocumentOpen.setEnabled(true);
            this.btnDocumentDelete.setEnabled(true);
            this.btnDocumentRename.setEnabled(true);
            this.btnDocumentProperties.setEnabled(true);
        } else {
            this.btnDocumentOpen.setEnabled(false);
            this.btnDocumentDelete.setEnabled(false);
            this.btnDocumentRename.setEnabled(false);
            this.btnDocumentProperties.setEnabled(false);
        }
    }

    private void doDocumentNew() {
        String documentsTypeName = this.currentDocumentType.getTypeName();
        ProjectManager projectManager = ProjectManager.getInstance();
        Iterator<? extends Document> documents = projectManager.createDocumentsByUser(documentsTypeName, new Invocable(){

            public Object call(Object ... args) {
                Iterator docs = (Iterator)args[0];
                ProjectDocumentsPanelPage.this.addNewDocuments(docs);
                return null;
            }
        });
        this.addNewDocuments(documents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewDocuments(Iterator<? extends Document> documents) {
        while (documents != null && documents.hasNext()) {
            Document document = documents.next();
            try {
                this.project.addDocument(document);
                this.openDocumentWindow(document);
            }
            catch (Exception e) {
                this.LOG.warn("Can't open document", (Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Object)document);
            }
        }
        this.lstDocuments.requestFocus();
        this.lstDocuments.setSelectedIndex(this.lstDocuments.getModel().getSize() - 1);
    }

    private void doDocumentOpen() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        int[] indexes = this.lstDocuments.getSelectedIndices();
        for (int i = indexes.length - 1; i >= 0; --i) {
            int index = indexes[i];
            if (index == -1) {
                return;
            }
            String documentsTypeName = this.currentDocumentType.getTypeName();
            List<Document> documents = this.project.getDocuments(documentsTypeName);
            Document doc = documents.get(index);
            if (!doc.isAvailable()) {
                application.messageDialog(i18n.getTranslation("document_not_available"), i18n.getTranslation("abrir"), 2);
            }
            IWindow win = doc.getMainWindow();
            this.openDocumentWindow(doc);
        }
    }

    private void doDocumentRename() {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        int index = this.lstDocuments.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String DoumentTypeName = this.currentDocumentType.getTypeName();
        List<Document> documents = this.project.getDocuments(DoumentTypeName);
        Document doc = documents.get(index);
        String name = application.inputDialog(i18n.getTranslation("introduce_nombre"), i18n.getTranslation("renombrar"), 3, doc.getName());
        if (name != null) {
            for (Document document : documents) {
                if (!StringUtils.equals((CharSequence)document.getName(), (CharSequence)name)) continue;
                application.messageDialog(i18n.getTranslation("elemento_ya_existe"), i18n.getTranslation("warning"), 2);
                return;
            }
            doc.setName(name);
            this.updateProjectDocumens();
            this.project.setModified(true);
        }
    }

    private void doDocumentDelete() {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        int res = application.confirmDialog(i18n.getTranslation("confirmar_borrar"), i18n.getTranslation("borrar"), 0, 1, "Confirm remove document from project");
        int lastremoved = 0;
        if (res == 0) {
            String DoumentTypeName = this.currentDocumentType.getTypeName();
            int[] indexes = this.lstDocuments.getSelectedIndices();
            for (int i = indexes.length - 1; i >= 0; --i) {
                int index = indexes[i];
                List<Document> documents = this.project.getDocuments(DoumentTypeName);
                Document doc = documents.get(index);
                if (doc.isLocked()) {
                    application.messageDialog(i18n.getTranslation("locked_element_it_cannot_be_deleted"), i18n.getTranslation("Information"), 1);
                    return;
                }
                PluginServices.getMDIManager().closeSingletonWindow((Object)doc);
                this.project.removeDocument(doc);
                lastremoved = index;
            }
            if (lastremoved >= this.lstDocuments.getModel().getSize()) {
                this.lstDocuments.setSelectedIndex(this.lstDocuments.getModel().getSize() - 1);
            } else if (lastremoved >= 0) {
                this.lstDocuments.setSelectedIndex(lastremoved);
            }
            this.project.setModified(true);
        }
    }

    private void doDocumentProperties() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        int index = this.lstDocuments.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String DoumentTypeName = this.currentDocumentType.getTypeName();
        List<Document> documents = this.project.getDocuments(DoumentTypeName);
        Document doc = documents.get(index);
        if (!doc.isAvailable()) {
            application.messageDialog(i18nManager.getTranslation("document_not_available"), i18nManager.getTranslation("properties"), 2);
            return;
        }
        IWindow properties = doc.getFactory().getPropertiesWindow(doc);
        application.getUIManager().addWindow(properties);
        this.lstDocuments.setSelectedIndex(index);
        this.project.setModified(true);
    }

    private void doProjectProperties() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        ProjectProperties panel = new ProjectProperties(this.project);
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ProjectDocumentsPanelPage.this.updateProjectProperties();
            }
        });
        winmgr.showWindow((JComponent)((Object)panel), i18nManager.getTranslation("project_properties"), WindowManager.MODE.WINDOW);
    }

    private void doDocumentsSelectionChanged() {
        this.updateDocumentButtons();
    }
}

