/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.dalactions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class ViewZoomAction
extends AbstractAction {
    private final DALActionFactory.DALActionContext context;

    public ViewZoomAction(DALActionFactory.DALActionContext context) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
        this.context = context;
        this.putValue("Name", null);
        this.putValue("ShortDescription", i18nManager.getTranslation("_Zoom"));
        this.putValue("SmallIcon", iconTheme.get("view-navigation-zoom-to-selection"));
        this.putValue("ActionCommandKey", "ViewZoom");
        DataStore store = this.context.getStore();
        this.setEnabled(store instanceof FeatureStore);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        FeatureQuery query;
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewDocument.class);
        if (view == null) {
            return;
        }
        Expression filter = this.context.getFilterForSelecteds();
        if (filter == null && (query = this.context.getQuery()) != null) {
            filter = query.getExpressionFilter();
        }
        if (filter == null) {
            return;
        }
        try {
            FeatureStore store = (FeatureStore)this.context.getStore();
            FeatureSet set = store.getFeatureSet(filter);
            Envelope envelope = GeometryUtils.createEnvelope((int)0);
            for (Feature feature : set) {
                envelope.add(feature.getDefaultGeometry());
            }
            if (!envelope.isEmpty()) {
                view.getMapContext().getViewPort().setEnvelope(envelope);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ViewZoomActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "ViewZoom";

        public ViewZoomActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new ViewZoomAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new ViewZoomActionFactory());
        }
    }
}

