/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.expressionevaluator.ViewLayersElement;
import org.gvsig.app.project.documents.view.expressionevaluator.ViewTakeProjectionCodeElement;
import org.gvsig.app.project.documents.view.expressionevaluator.viewcapturepoint.ViewCapturePointElement;
import org.gvsig.app.project.documents.view.expressionevaluator.viewcapturerectangle.ViewCaptureRectangleElement;
import org.gvsig.app.project.documents.view.expressionevaluator.viewpastegeom.ViewPasteGeomElement;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class ViewElement
extends AbstractElement
implements Element.GroupElement {
    private final List<Element> children = new ArrayList<Element>();
    private final List<Element> values = new ArrayList<Element>();

    public ViewElement() {
        super("Views", (Object)ToolsLocator.getI18nManager().getTranslation("Views"), "expressionbuilder-element-view");
        this.values.add((Element)new ViewCaptureRectangleElement());
        this.values.add((Element)new ViewPasteGeomElement());
        this.values.add((Element)new ViewCapturePointElement());
        this.values.add((Element)new ViewTakeProjectionCodeElement());
        ProjectManager manager = ApplicationLocator.getProjectManager();
        List<Document> views = manager.getCurrentProject().getDocuments(ViewManager.TYPENAME);
        for (Document view : views) {
            ViewLayersElement e = new ViewLayersElement((ViewDocument)view);
            this.children.add((Element)e);
        }
    }

    public Collection<Element> getValues() {
        return this.values;
    }

    public Element setConfig(ExpressionBuilderConfig config) {
        super.setConfig(config);
        for (Element child : this.children) {
            child.setConfig(config);
        }
        return this;
    }

    public Element get(int index) {
        return this.children.get(index);
    }

    public int size() {
        return this.children.size();
    }

    public Iterator<Element> iterator() {
        return this.children.iterator();
    }

    public void addElement(Element element) {
        this.children.add(element);
    }

    public void addElement(Function function) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Element> getElements() {
        return this.children;
    }

    public void dispose() {
        for (Element child : this.children) {
            DisposeUtils.disposeQuietly((Disposable)child);
        }
        this.children.clear();
        for (Element value : this.values) {
            DisposeUtils.disposeQuietly((Disposable)value);
        }
        this.values.clear();
    }
}

