/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.DefaultProject;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.DefaultViewInformationArea;
import org.gvsig.app.project.documents.view.gui.MapOverViewPalette;
import org.gvsig.app.project.documents.view.toc.gui.TOC;
import org.gvsig.app.project.documents.view.toolListeners.AngleGeometryListener;
import org.gvsig.app.project.documents.view.toolListeners.AreaListener;
import org.gvsig.app.project.documents.view.toolListeners.IdentifyLayerListener;
import org.gvsig.app.project.documents.view.toolListeners.InfoListener;
import org.gvsig.app.project.documents.view.toolListeners.MeasureListener;
import org.gvsig.app.project.documents.view.toolListeners.PanListener;
import org.gvsig.app.project.documents.view.toolListeners.PointSelectListener;
import org.gvsig.app.project.documents.view.toolListeners.PolygonSelectListener;
import org.gvsig.app.project.documents.view.toolListeners.RectangleSelectListener;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.app.project.documents.view.toolListeners.ZoomInListener;
import org.gvsig.app.project.documents.view.toolListeners.ZoomOutListener;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControlCreationException;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolygonBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolylineBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.TwoLinesBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AngleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.utils.console.JConsole;
import org.gvsig.utils.console.JDockPanel;
import org.gvsig.utils.console.ResponseListener;
import org.gvsig.utils.console.jedit.JEditTextArea;
import org.gvsig.utils.exceptionHandling.ExceptionListener;

public class DefaultViewPanel
extends AbstractViewPanel
implements Observer,
PropertiesSupport {
    private static final long serialVersionUID = -4044661458841786519L;
    private JConsole console;
    private JDockPanel dockConsole = null;
    protected ResponseAdapter consoleResponseAdapter = new ResponseAdapter();
    protected boolean isShowConsole = false;
    private ViewPortListener viewPortListener;
    private PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();
    private static MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
    private static boolean disableConsole = false;

    public DefaultViewPanel() {
        this.propertiesHelper.setProperty("View", (Object)this);
        this.setName("View");
        if (mapControlManager == null) {
            mapControlManager = MapControlLocator.getMapControlManager();
        }
        this.viewInformationArea = new DefaultViewInformationArea();
    }

    public DefaultViewPanel(Document document) {
        this();
        this.initialize(((ViewDocument)document).getMapContext());
        this.setDocument(document);
    }

    protected void initialize(MapContext mapContext) {
        super.initialize();
        this.initComponents(mapContext);
        this.hideConsole();
        this.getConsolePanel().addResponseListener((ResponseListener)this.consoleResponseAdapter);
    }

    @Override
    public void setDocument(Document document) {
        this.setModel((ViewDocument)document);
    }

    @Override
    public Document getDocument() {
        return this.modelo;
    }

    public void setModel(ViewDocument model) {
        final ApplicationManager application = ApplicationLocator.getApplicationManager();
        this.modelo = model;
        MapContext fmap = this.modelo.getMapContext();
        FLayers layers = fmap.getLayers();
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (!layers.getLayer(i).isEditing() || !(layers.getLayer(i) instanceof FLyrVect)) continue;
            this.showConsole();
        }
        this.m_TOC.setMapContext(fmap);
        this.m_MapControl.setBackground(new Color(255, 255, 255));
        if (this.modelo.getMapOverViewContext() != null) {
            this.m_MapLoc.setModel(this.modelo.getMapOverViewContext());
        }
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("name")) {
                    PluginServices.getMDIManager().getWindowInfo((IWindow)DefaultViewPanel.this).setTitle(PluginServices.getText((Object)this, (String)"Vista") + ": " + (String)evt.getNewValue());
                }
            }
        });
        if (this.m_MapControl.getViewPort() != null) {
            this.viewPortListener = new ViewPortListener(){

                public void extentChanged(ExtentEvent e) {
                    try {
                        Document activeDoc = application.getActiveDocument(ViewManager.TYPENAME);
                        if (activeDoc != DefaultViewPanel.this.getDocument()) {
                            return;
                        }
                        if (PluginServices.getMainFrame() != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PluginServices.getMainFrame().getStatusBar().setControlValue("view-change-scale", String.valueOf(DefaultViewPanel.this.m_MapControl.getMapContext().getScaleView()));
                                    PluginServices.getMainFrame().getStatusBar().setMessage("projection", DefaultViewPanel.this.getMapControl().getViewPort().getProjection().getAbrev());
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        AbstractViewPanel.logger.warn("Problems process 'extentChanged'.", (Throwable)ex);
                    }
                }

                public void backColorChanged(ColorEvent e) {
                }

                public void projectionChanged(ProjectionEvent e) {
                    DefaultViewPanel.this.m_MapLoc.setProjection(e.getNewProjection());
                }
            };
            this.m_MapControl.getViewPort().addViewPortListener(this.viewPortListener);
        }
    }

    public JConsole getConsolePanel() {
        if (this.console == null) {
            this.console = new JConsole(true);
            this.console.setJTextName("CADConsole");
        }
        return this.console;
    }

    private JDockPanel getDockConsole() {
        if (this.dockConsole == null) {
            this.dockConsole = new JDockPanel((JComponent)this.getConsolePanel());
        }
        return this.dockConsole;
    }

    public void addConsoleListener(String prefix, ResponseListener listener) {
        this.consoleResponseAdapter.putSpaceListener(prefix, listener);
    }

    public void removeConsoleListener(ResponseListener listener) {
        this.consoleResponseAdapter.deleteListener(listener);
    }

    public void focusConsole(String text) {
        this.getConsolePanel().addResponseText(text);
        JEditTextArea jeta = this.getConsolePanel().getTxt();
        jeta.requestFocusInWindow();
        jeta.setCaretPosition(jeta.getText().length());
    }

    public void hideConsole() {
        this.isShowConsole = false;
        this.getDockConsole().setVisible(false);
    }

    public void showConsole() {
        if (this.isShowConsole || disableConsole) {
            return;
        }
        this.isShowConsole = true;
        this.getMapControl().remove((Component)this.getDockConsole());
        this.getMapControl().setLayout((LayoutManager)new BorderLayout());
        this.getMapControl().add((Component)this.getDockConsole(), (Object)"South");
        this.getDockConsole().setVisible(true);
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    protected void initComponents(MapContext mapContext) {
        try {
            this.m_MapControl = mapControlManager.createJMapControlPanel(mapContext);
            this.m_MapControl.setMapControlDrawer(mapControlManager.createDefaultMapControlDrawer());
        }
        catch (MapControlCreationException e) {
            NotificationManager.addError((Throwable)e);
        }
        this.m_MapControl.addExceptionListener((ExceptionListener)this.mapControlExceptionListener);
        this.m_TOC = new TOC();
        this.viewInformationArea.add(this.m_TOC, "TOC", 0, "ToC", null, "Table of contents");
        this.m_MapLoc = new MapOverview(this.m_MapControl);
        try {
            this.m_MapLoc.setMapControlDrawer(mapControlManager.createDefaultMapControlDrawer());
        }
        catch (MapControlCreationException e) {
            NotificationManager.addError((Throwable)e);
        }
        this.removeAll();
        this.tempMainSplit = new AbstractViewPanel.ViewSplitPane(this, 1);
        if (this.windowLayout == null) {
            this.m_MapLoc.setPreferredSize(new Dimension(150, 200));
            this.tempMainSplit.setPreferredSize(new Dimension(500, 300));
        }
        if (!this.isPalette()) {
            this.tempSplitToc = new JSplitPane(0);
            this.tempSplitToc.setTopComponent(this.viewInformationArea.asJComponent());
            this.tempSplitToc.setBottomComponent((Component)((Object)this.m_MapLoc));
            this.tempSplitToc.setResizeWeight(0.7);
            this.tempMainSplit.setLeftComponent(this.tempSplitToc);
        } else {
            this.tempMainSplit.setLeftComponent(this.viewInformationArea.asJComponent());
        }
        this.m_TOC.setVisible(true);
        this.tempMainSplit.setRightComponent((Component)this.m_MapControl);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tempMainSplit, "Center");
        if (this.windowLayout != null) {
            try {
                this.tempMainSplit.setDividerLocation(Integer.valueOf(this.windowLayout.get("MainDivider.Location")));
                if (this.windowLayout.get("TOCDivider.Location") != null) {
                    this.tempSplitToc.setDividerLocation(Integer.valueOf(this.windowLayout.get("TOCDivider.Location")));
                }
            }
            catch (NumberFormatException ex) {
                PluginServices.getLogger().error("Error restoring View properties");
            }
        }
        ZoomOutListener zoomOutListener = new ZoomOutListener(this.m_MapControl);
        this.m_MapControl.addBehavior("zoomOut", (Behavior)new PointBehavior((PointListener)zoomOutListener));
        ZoomInListener zoomInListener = new ZoomInListener(this.m_MapControl);
        this.m_MapControl.addBehavior("zoomIn", new Behavior[]{new RectangleBehavior((RectangleListener)zoomInListener), new PointBehavior((PointListener)zoomOutListener, 4)});
        PanListener panListener = new PanListener(this.m_MapControl);
        this.m_MapControl.addBehavior("pan", (Behavior)new MoveBehavior((org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener)panListener, 1));
        MeasureListener mli = new MeasureListener(this.m_MapControl);
        this.m_MapControl.addBehavior("medicion", (Behavior)new PolylineBehavior((PolylineListener)mli));
        AreaListener ali = new AreaListener(this.m_MapControl);
        this.m_MapControl.addBehavior("area", (Behavior)new PolygonBehavior((PolylineListener)ali));
        AngleGeometryListener agl = new AngleGeometryListener(this.m_MapControl);
        this.m_MapControl.addBehavior("feature-angle", (Behavior)new TwoLinesBehavior((AngleListener)agl));
        InfoListener il = new InfoListener(this.m_MapControl);
        this.m_MapControl.addBehavior("info", (Behavior)new PointBehavior((PointListener)il));
        IdentifyLayerListener ill = new IdentifyLayerListener(this.m_MapControl);
        this.m_MapControl.addBehavior("identifylayer", new Behavior[]{new PointBehavior((PointListener)ill), new RectangleBehavior((RectangleListener)ill)});
        PointSelectListener psl = new PointSelectListener(this.m_MapControl);
        this.m_MapControl.addBehavior("pointSelection", (Behavior)new PointBehavior((PointListener)psl));
        RectangleSelectListener rsl = new RectangleSelectListener(this.m_MapControl);
        this.m_MapControl.addBehavior("rectSelection", (Behavior)new RectangleBehavior((RectangleListener)rsl));
        PolygonSelectListener poligSel = new PolygonSelectListener(this.m_MapControl);
        this.m_MapControl.addBehavior("polSelection", (Behavior)new PolygonBehavior((PolylineListener)poligSel));
        this.m_MapControl.setTool("zoomIn");
        StatusBarListener statusBarListener = new StatusBarListener(this.m_MapControl);
        this.m_MapControl.addCombinedBehavior((Behavior)new MouseMovementBehavior((PointListener)statusBarListener));
        this.m_MapControl.addCombinedBehavior((Behavior)new MouseWheelBehavior());
        this.m_MapControl.addCombinedBehavior((Behavior)new MoveBehavior((org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener)panListener, 2));
        Supplier<Envelope> bboxSupplier = new Supplier<Envelope>(){

            @Override
            public Envelope get() {
                ApplicationManager application = ApplicationLocator.getApplicationManager();
                Document activeView = application.getActiveDocument(ViewManager.TYPENAME);
                if (activeView == DefaultViewPanel.this.getDocument()) {
                    MapContext mapContext = DefaultViewPanel.this.getMapControl().getMapContext();
                    Envelope env = mapContext.getViewPort().getEnvelope();
                    return env;
                }
                return null;
            }
        };
        this.m_MapControl.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DALSwingLocator.getDataSwingManager().setCurrentBoundingBox((Supplier)new Supplier<Envelope>(){

                    @Override
                    public Envelope get() {
                        MapContext mapContext = DefaultViewPanel.this.getMapControl().getMapContext();
                        Envelope env = mapContext.getViewPort().getEnvelope();
                        return env;
                    }
                });
            }
        });
        this.m_MapControl.getMapContext().getViewPort().addViewPortListener(new ViewPortListener(){

            public void extentChanged(ExtentEvent e) {
                ApplicationManager application = ApplicationLocator.getApplicationManager();
                Document activeView = application.getActiveDocument(ViewManager.TYPENAME);
                if (activeView == DefaultViewPanel.this.getDocument()) {
                    DALSwingLocator.getDataSwingManager().setCurrentBoundingBox((Supplier)new Supplier<Envelope>(){

                        @Override
                        public Envelope get() {
                            MapContext mapContext = DefaultViewPanel.this.getMapControl().getMapContext();
                            Envelope env = mapContext.getViewPort().getEnvelope();
                            return env;
                        }
                    });
                }
            }

            public void backColorChanged(ColorEvent e) {
            }

            public void projectionChanged(ProjectionEvent e) {
            }
        });
    }

    @Override
    public void windowActivated() {
        super.windowActivated();
        NewStatusBar statusbar = PluginServices.getMainFrame().getStatusBar();
        MapContext mapContext = this.getMapControl().getMapContext();
        statusbar.setMessage("units", PluginServices.getText((Object)this, (String)mapContext.getDistanceName()));
        statusbar.setControlValue("view-change-scale", String.valueOf(mapContext.getScaleView()));
        IProjection proj = this.getMapControl().getViewPort().getProjection();
        if (proj != null) {
            statusbar.setMessage("projection", proj.getAbrev());
        } else {
            statusbar.setMessage("projection", "");
        }
    }

    @Override
    public void windowClosed() {
        super.windowClosed();
        if (this.viewPortListener != null) {
            this.getMapControl().getViewPort().removeViewPortListener(this.viewPortListener);
        }
        if (this.getMapOverview() != null) {
            this.getMapOverview().getViewPort().removeViewPortListener((ViewPortListener)this.getMapOverview());
        }
    }

    @Override
    public void toPalette() {
        this.isPalette = true;
        this.m_MapLoc.setPreferredSize(new Dimension(200, 150));
        this.m_MapLoc.setSize(new Dimension(200, 150));
        this.movp = new MapOverViewPalette(this.m_MapLoc, this);
        PluginServices.getMDIManager().addWindow((IWindow)this.movp);
        FLayer[] layers = this.getViewDocument().getMapContext().getLayers().getActives();
        if (layers.length > 0 && layers[0] instanceof FLyrVect && ((FLyrVect)layers[0]).isEditing()) {
            this.showConsole();
            return;
        }
        this.hideConsole();
    }

    @Override
    public void restore() {
        this.isPalette = false;
        PluginServices.getMDIManager().closeWindow((IWindow)this.movp);
        FLayer[] layers = this.getViewDocument().getMapContext().getLayers().getActives();
        if (layers.length > 0 && layers[0] instanceof FLyrVect && ((FLyrVect)layers[0]).isEditing()) {
            this.showConsole();
            return;
        }
        this.hideConsole();
        JSplitPane tempSplitToc = new JSplitPane(0);
        tempSplitToc.setTopComponent(this.viewInformationArea.asJComponent());
        tempSplitToc.setBottomComponent((Component)((Object)this.m_MapLoc));
        tempSplitToc.setResizeWeight(0.7);
        this.tempMainSplit.setLeftComponent(tempSplitToc);
    }

    public static void setDefaultMapOverViewBackColor(Color color) {
        DefaultProject.getPreferences().setDefaultOverviewBackColor(color);
    }

    public static Color getDefaultMapOverViewBackColor() {
        return DefaultProject.getPreferences().getDefaultOverviewBackColor();
    }

    public static Color getDefaultBackColor() {
        return DefaultProject.getPreferences().getDefaultViewBackColor();
    }

    public static void setDefaultBackColor(Color color) {
        DefaultProject.getPreferences().setDefaultViewBackColor(color);
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }

    public void update(final Observable observable, final Object notification) {
        FeatureStoreNotification event;
        if (notification instanceof FeatureStoreNotification && ((event = (FeatureStoreNotification)notification).getType() == "after_CancelEditing_DataStore" || event.getType() == "after_FinishEditing_DataStore")) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultViewPanel.this.update(observable, notification);
                    }
                });
                return;
            }
            this.getMapControl().setTool("zoomIn");
            this.hideConsole();
            this.repaintMap();
        }
    }

    public static void setDisableConsole(boolean disable) {
        disableConsole = disable;
    }

    static class ResponseAdapter
    implements ResponseListener {
        private HashMap<String, ResponseListener> spaceListener = new HashMap();

        ResponseAdapter() {
        }

        public void putSpaceListener(String namespace, ResponseListener listener) {
            this.spaceListener.put(namespace, listener);
        }

        public void acceptResponse(String response) {
            boolean nameSpace = false;
            int n = -1;
            if (response != null && (n = response.indexOf(58)) != -1) {
                nameSpace = true;
            }
            if (nameSpace) {
                ResponseListener listener = this.spaceListener.get(response.substring(0, n));
                if (listener != null) {
                    listener.acceptResponse(response.substring(n + 1));
                }
            } else {
                for (ResponseListener listener : this.spaceListener.values()) {
                    listener.acceptResponse(response);
                }
            }
        }

        public void deleteListener(ResponseListener listener) {
            for (String namespace : this.spaceListener.keySet()) {
                ResponseListener l = this.spaceListener.get(namespace);
                if (l != listener) continue;
                this.spaceListener.remove(namespace);
            }
        }
    }
}

