/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemeManagerWindow {
    private static final Logger logger = LoggerFactory.getLogger(ThemeManagerWindow.class);
    private static final long serialVersionUID = 4650656815369149211L;
    private static final Map<Class<? extends AbstractThemeManagerPage>, List<Class<? extends FLayer>>> s = new HashMap<Class<? extends AbstractThemeManagerPage>, List<Class<? extends FLayer>>>();

    public static void addPage(Class<? extends AbstractThemeManagerPage> pageClass) {
        PropertiesPageManager manager = MapControlLocator.getPropertiesPageManager();
        manager.registerFactory((PropertiesPageFactory)new ThemeManagerPropertiesPageFactory(pageClass));
    }

    public static void setTabEnabledForLayer(Class<? extends AbstractThemeManagerPage> abstractThemeManagerPageClass, Class<? extends FLayer> fLayerClazz, boolean enabled) {
        if (enabled) {
            if (!s.containsKey(abstractThemeManagerPageClass)) {
                ArrayList<Class<? extends FLayer>> enabledLayers = new ArrayList<Class<? extends FLayer>>();
                enabledLayers.add(fLayerClazz);
                s.put(abstractThemeManagerPageClass, enabledLayers);
            } else {
                ArrayList enabledLayers = (ArrayList)s.get(abstractThemeManagerPageClass);
                enabledLayers.add(fLayerClazz);
            }
        } else {
            if (!s.containsKey(abstractThemeManagerPageClass)) {
                return;
            }
            ArrayList enabledLayers = (ArrayList)s.get(abstractThemeManagerPageClass);
            enabledLayers.remove(fLayerClazz);
        }
    }

    public static boolean isTabEnabledForLayer(AbstractThemeManagerPage page, FLayer layer) {
        try {
            return s.get(page.getClass()).contains(layer.getClass());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static class ThemeManagerPropertiesPageFactory
    implements PropertiesPageFactory {
        private final Class<? extends AbstractThemeManagerPage> pageClass;
        private AbstractThemeManagerPage page = null;
        private FLayer layer = null;

        public ThemeManagerPropertiesPageFactory(Class<? extends AbstractThemeManagerPage> pageClass) {
            this.pageClass = pageClass;
        }

        public String getName() {
            return this.pageClass.getName();
        }

        private AbstractThemeManagerPage getPage(FLayer layer) throws InstantiationException, IllegalAccessException {
            if (this.layer == null || this.layer != layer) {
                AbstractThemeManagerPage p;
                this.page = p = this.pageClass.newInstance();
                this.layer = layer;
            }
            try {
                this.page.setModel(this.layer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.page;
        }

        public String getGroupID() {
            return "LayerPropertiesPageGroup";
        }

        public boolean isVisible(Object obj) {
            try {
                AbstractThemeManagerPage thePage = this.getPage((FLayer)obj);
                return thePage.isTabEnabledForLayer((FLayer)obj);
            }
            catch (Throwable th) {
                logger.warn("can't determine if the page must be visible to the object '" + obj + "'", th);
                return false;
            }
        }

        public PropertiesPage create(Object container, Object obj) {
            try {
                return this.getPage((FLayer)obj);
            }
            catch (Exception ex) {
                logger.warn("Can't create the page '" + this.pageClass + "' asociated to '" + obj + "'.", (Throwable)ex);
                return null;
            }
        }
    }
}

