/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.metadata.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.metadata.Metadata;
import org.gvsig.metadata.swing.basic.api.JMetadataPanel;
import org.gvsig.metadata.swing.basic.api.MetadataSwingLocator;
import org.gvsig.metadata.swing.basic.api.MetadataSwingManager;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;

public class MetadataInfoManager
extends AbstractThemeManagerPage {
    private static final long serialVersionUID = 7432962479048597376L;
    private JMetadataPanel metadataPanel;

    public MetadataInfoManager() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JBlank(5, 10), "West");
        this.add((Component)new JBlank(5, 10), "East");
    }

    @Override
    public void setModel(FLayer layer) {
        try {
            MetadataSwingManager manager = MetadataSwingLocator.getMetadataSwingManager();
            if (this.metadataPanel == null) {
                this.metadataPanel = manager.createJMetadataPanel((Metadata)layer);
                this.add((Component)this.metadataPanel, "Center");
            } else {
                this.metadataPanel.setMetadata((Metadata)layer);
            }
        }
        catch (Exception e) {
            NotificationManager.addError((String)"Can't assign model", (Throwable)e);
        }
    }

    @Override
    public void acceptAction() {
        if (this.metadataPanel == null) {
            return;
        }
        this.saveMetadata();
    }

    private void saveMetadata() {
        try {
            this.metadataPanel.saveMetadata();
        }
        catch (DynObjectValidateException e) {
            JOptionPane.showMessageDialog(null, this.getInfoString(e), "Metadata Validation Errors", 2);
        }
    }

    private String getInfoString(DynObjectValidateException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<h2>Metadata values could not be stored due to the following errors:'").append(this.metadataPanel.getMetadata().getDynClass().getName()).append("'</h2>");
        buffer.append("<p>");
        buffer.append("<br>");
        buffer.append("<ol>");
        buffer.append("  " + e.getLocalizedMessageStack());
        buffer.append("</ol>");
        buffer.append("</p>");
        buffer.append("</body>");
        buffer.append("</html>");
        return buffer.toString().replace("\n", "<br/>");
    }

    @Override
    public void cancelAction() {
    }

    @Override
    public void applyAction() {
        if (this.metadataPanel == null) {
            return;
        }
        this.saveMetadata();
    }

    @Override
    public String getName() {
        return PluginServices.getText((Object)this, (String)"_Metadata");
    }
}

