/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.FLyrVectEditPropertiesTocMenuEntry;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;

public class TocItemBranch
implements ITocItem {
    private ImageIcon icolayer = null;
    private ImageIcon finalIcon = null;
    private BufferedImage unavailableImg = null;
    private BufferedImage temporaryLayerImg = null;
    private final String defaultIcon = "images/icolayer.PNG";
    private FLayer lyr;
    private Dimension sz;
    public static final DataFlavor INFO_FLAVOR = new DataFlavor(TocItemBranch.class, "ItemBranch");
    static DataFlavor[] flavors = new DataFlavor[]{INFO_FLAVOR};

    public TocItemBranch(FLayer lyr) {
        this.lyr = lyr;
    }

    @Override
    public String getLabel() {
        return this.lyr.getName();
    }

    @Override
    public Icon getIcon() {
        if (this.finalIcon == null) {
            ImageIcon icon = PluginServices.getIconTheme().get(this.lyr.getTocImageIcon());
            this.setIcon(icon);
        }
        this.updateStateIcon();
        return this.finalIcon;
    }

    private void setIcon(String path) {
        File f = new File(path);
        if (f.exists()) {
            this.icolayer = new ImageIcon(f.getAbsolutePath());
        } else {
            URL url = PluginServices.getPluginServices((String)"org.gvsig.app").getClassLoader().getResource(path);
            if (url != null) {
                this.icolayer = new ImageIcon(url);
                return;
            }
        }
        this.updateStateIcon();
    }

    private void updateStateIcon() {
        Image img;
        if (this.icolayer == null) {
            return;
        }
        BufferedImage newImage = new BufferedImage(this.icolayer.getIconWidth(), this.icolayer.getIconHeight(), 2);
        Graphics2D grp = newImage.createGraphics();
        grp.drawImage(this.icolayer.getImage(), 0, 0, null);
        if (this.lyr.getTocStatusImage() != null) {
            img = this.lyr.getTocStatusImage();
            grp.drawImage(img, 0, this.icolayer.getIconHeight() - img.getHeight(null), null);
        }
        if (!this.lyr.isAvailable()) {
            img = this.getUnavailableImage();
            grp.drawImage(img, 0, this.icolayer.getIconHeight() - ((BufferedImage)img).getHeight(), null);
        }
        if (this.lyr.isTemporary()) {
            img = this.getTemporaryLayerImage();
            grp.drawImage(img, this.icolayer.getIconWidth() - ((BufferedImage)img).getWidth(), this.icolayer.getIconHeight() - ((BufferedImage)img).getHeight(), null);
        }
        this.finalIcon = new ImageIcon(newImage);
    }

    private void setIcon(ImageIcon icon) {
        if (icon != null) {
            this.icolayer = icon;
        } else {
            this.setIcon("images/icolayer.PNG");
        }
        this.updateStateIcon();
    }

    public FLayer getLayer() {
        return this.lyr;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dF) {
        return dF.equals(INFO_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor dF) throws UnsupportedFlavorException, IOException {
        if (dF.equals(INFO_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(dF);
    }

    @Override
    public Dimension getSize() {
        return this.sz;
    }

    @Override
    public void setSize(Dimension sz) {
        this.sz = sz;
    }

    private BufferedImage getUnavailableImage() {
        ImageIcon uIcon;
        if (this.unavailableImg == null && (uIcon = IconThemeHelper.getImageIcon((String)"layer-chk-unavailable")) != null) {
            this.unavailableImg = new BufferedImage(uIcon.getIconWidth(), uIcon.getIconHeight(), 1);
            this.unavailableImg.getGraphics().drawImage(uIcon.getImage(), 0, 0, null);
        }
        return this.unavailableImg;
    }

    private BufferedImage getTemporaryLayerImage() {
        ImageIcon uIcon;
        if (this.temporaryLayerImg == null && (uIcon = IconThemeHelper.getImageIcon((String)"layer-chk-temporary")) != null) {
            this.temporaryLayerImg = new BufferedImage(uIcon.getIconWidth(), uIcon.getIconHeight(), 1);
            this.temporaryLayerImg.getGraphics().drawImage(uIcon.getImage(), 0, 0, null);
        }
        return this.temporaryLayerImg;
    }

    @Override
    public IContextMenuAction getDoubleClickAction() {
        if (!(this.getLayer() instanceof FLyrVect)) {
            return null;
        }
        return new FLyrVectEditPropertiesTocMenuEntry();
    }
}

