/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.info.gui.FInfoDialog;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.InfoByPoint;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.swing.dynobject.LayersDynObjectSetComponent;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoListener
implements PointListener {
    private static final Logger logger = LoggerFactory.getLogger(InfoListener.class);
    private static final String EP_INFOTOOL_NAME = "org.gvsig.app.infotool";
    private static final String EP_INFOTOOL_RENDERER = "renderer";
    private final Image img = PluginServices.getIconTheme().get("cursor-info-by-point").getImage();
    private MapControl mapCtrl;

    public static void initializeExtensionPoint() {
        ExtensionPointManager manager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = manager.add(EP_INFOTOOL_NAME, "Register of data relative to infotool");
        point.append(EP_INFOTOOL_RENDERER, "Renderer used to show in a panel the info by point tool.", (ExtensionSingleton)new DefaultInfoByPointRenderer());
    }

    public InfoListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public void point(PointEvent event) throws BehaviorException {
        try {
            SingletonWindow window;
            ApplicationManager application = ApplicationLocator.getManager();
            int numLayersInfoable = 0;
            Point point = event.getMapPoint();
            FLayer[] sel = this.mapCtrl.getMapContext().getLayers().getActives();
            HashMap<String, DynObjectSet> layer2info = new HashMap<String, DynObjectSet>(sel.length);
            for (int i = 0; i < sel.length; ++i) {
                FLayer laCapa = sel[i];
                if (!(laCapa instanceof InfoByPoint)) continue;
                InfoByPoint layer = (InfoByPoint)laCapa;
                int layerTolerance = laCapa.getDefaultTolerance();
                double tolerance = this.mapCtrl.getViewPort().toMapDistance(layerTolerance);
                DynObjectSet info = layer.getInfo(point, tolerance);
                layer2info.put(laCapa.getName(), info);
                ++numLayersInfoable;
            }
            if (numLayersInfoable == 0) {
                return;
            }
            ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
            InfoByPointRenderer renderer = (InfoByPointRenderer)extensionPoints.get(EP_INFOTOOL_NAME).create(EP_INFOTOOL_RENDERER);
            if (renderer instanceof DefaultInfoByPointRenderer) {
                ((DefaultInfoByPointRenderer)renderer).setMapContext(this.mapCtrl.getMapContext());
            }
            if ((window = renderer.getPanel(layer2info)) == null) {
                logger.info("Error. Unable to create info panel.");
                return;
            }
            PluginServices.getMDIManager().addWindow((IWindow)window, 26);
        }
        catch (Exception e) {
            NotificationManager.addError((String)"Info by Point", (Throwable)e);
            e.printStackTrace();
        }
    }

    private boolean isCurrentlyAdded(IWindow iw) {
        IWindow[] iws = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < iws.length; ++i) {
            if (iws[i] != iw) continue;
            return true;
        }
        return false;
    }

    public Image getImageCursor() {
        return this.img;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public static class DefaultInfoByPointRenderer
    implements InfoByPointRenderer,
    ExtensionSingleton {
        private FInfoDialog dlgInfo = null;
        private MapContext mapContext;

        public void setMapContext(MapContext mapContext) {
            this.mapContext = mapContext;
        }

        @Override
        public SingletonWindow getPanel(Map<String, DynObjectSet> layersInfo) {
            LayersDynObjectSetComponent infoComponent = MapControlLocator.getMapControlManager().createLayersDynObjectSetComponent(layersInfo, false);
            infoComponent.setMapContext(this.mapContext);
            if (this.dlgInfo == null) {
                this.dlgInfo = new FInfoDialog(infoComponent);
            } else {
                this.dlgInfo.setInfo(infoComponent);
            }
            return this.dlgInfo;
        }
    }

    public static interface InfoByPointRenderer {
        public SingletonWindow getPanel(Map<String, DynObjectSet> var1);
    }
}

