/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.MeasureListenerImpl;

public class MeasureListener
extends MeasureListenerImpl {
    public MeasureListener(MapControl mc) {
        super(mc);
    }

    public void points(MeasureEvent event) {
        double dist = 0.0;
        double distAll = 0.0;
        double angle = 0.0;
        double sin = 0.0;
        double cos = 0.0;
        double dm = 0.0;
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        IProjection proj = this.mapCtrl.getMapContext().getProjection();
        Point2D.Double p = new Point2D.Double(event.getXs()[0], event.getYs()[0]);
        for (int i = 1; i < event.getXs().length; ++i) {
            Point2D.Double p2 = new Point2D.Double(event.getXs()[i], event.getYs()[i]);
            dist = vp.distanceWorld((Point2D)p, (Point2D)p2);
            distAll += dist;
            if (proj.isProjected()) {
                dm = p.distance(p2);
                sin = (((Point2D)p2).getX() - ((Point2D)p).getX()) / dm;
                cos = (((Point2D)p2).getY() - ((Point2D)p).getY()) / dm;
                angle = sin >= 0.0 ? Math.toDegrees(Math.acos(cos)) : 360.0 - Math.toDegrees(Math.acos(cos));
            }
            p = p2;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (PluginServices.getMainFrame() != null) {
            double[] trans2Meter = MapContext.getDistanceTrans2Meter();
            int distanceUnits = this.mapCtrl.getViewPort().getDistanceUnits();
            PluginServices.getMainFrame().getStatusBar().setMessage("4", "Dist=" + nf.format(dist / trans2Meter[distanceUnits]) + " " + MapContext.getDistanceAbbr()[distanceUnits]);
            PluginServices.getMainFrame().getStatusBar().setMessage("5", "T=" + nf.format(distAll / trans2Meter[distanceUnits]) + " " + MapContext.getDistanceAbbr()[distanceUnits]);
            if (proj.isProjected()) {
                PluginServices.getMainFrame().getStatusBar().setMessage("azimut", "Azimut:" + GeometryUtils.formatAngle((String)"%d\u00b0%.2M\u2032", (double)angle) + "");
            } else {
                PluginServices.getMainFrame().getStatusBar().setMessage("azimut", "Azimut: (not available)");
            }
        }
    }
}

