/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.sqlQueryValidation;

import Zql.ZqlParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.gvsig.andami.PluginServices;

public class SQLQueryValidation {
    private String query;
    private boolean onlyWhereStatement;
    private int[] errorPosition;
    private String errorMessage;
    private String errorPositionAsMessage;
    private String token;
    private final String preQuery = "SELECT a FROM b WHERE ";
    private final int preQueryLenght = "SELECT a FROM b WHERE ".length();

    public SQLQueryValidation(String _query, boolean _onlyWhereStatement) {
        this.query = new String(_query);
        this.onlyWhereStatement = _onlyWhereStatement;
        this.errorPosition = new int[2];
        this.errorPosition[0] = -1;
        this.errorPosition[1] = -1;
        this.errorPositionAsMessage = null;
        this.errorMessage = null;
        this.token = null;
    }

    public boolean validateQuery() {
        String completeQuery = new String();
        if (this.query == null) {
            this.errorPosition[0] = -2;
            this.errorPosition[1] = -2;
            this.defineErrorPositionAsMessageAttribute(this.errorPosition);
            this.errorMessage = new String(PluginServices.getText(null, (String)"queryIsNull"));
            return false;
        }
        if (this.query.compareTo("") == 0) {
            this.errorPosition[0] = -1;
            this.errorPosition[1] = -1;
            this.defineErrorPositionAsMessageAttribute(this.errorPosition);
            this.errorMessage = null;
            return true;
        }
        boolean is_word = false;
        String formatted_query = new String();
        for (int index = 0; index < this.query.length(); ++index) {
            char c = this.query.charAt(index);
            if (c == '\'') {
                if (!is_word) {
                    if (index > 0 && (this.query.charAt(index - 1) == ' ' || this.query.charAt(index - 1) == '(')) {
                        is_word = true;
                    }
                    formatted_query = formatted_query + c;
                    continue;
                }
                if (index == this.query.length() - 1) {
                    formatted_query = formatted_query + c;
                    continue;
                }
                if (this.query.charAt(index + 1) == ' ' || this.query.charAt(index + 1) == ')') {
                    is_word = false;
                    formatted_query = formatted_query + c;
                    continue;
                }
                formatted_query = formatted_query + "\"";
                continue;
            }
            formatted_query = formatted_query + c;
        }
        completeQuery = this.onlyWhereStatement ? "SELECT a FROM b WHERE " + formatted_query.trim().replaceAll("\"", " ") : formatted_query.trim().replaceAll("\"", " ");
        if (completeQuery.length() > 0 && completeQuery.charAt(completeQuery.length() - 1) != ';') {
            completeQuery = completeQuery + ";";
        }
        try {
            ZqlParser p = new ZqlParser();
            p.initParser((InputStream)new ByteArrayInputStream(completeQuery.getBytes()));
            p.readStatement();
            this.errorPosition[0] = -1;
            this.errorPosition[1] = -1;
            this.defineErrorPositionAsMessageAttribute(this.errorPosition);
            this.errorMessage = null;
            return true;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            int ini_pos = e.getMessage().indexOf(34) + 1;
            this.token = new String(this.errorMessage.substring(ini_pos, this.errorMessage.indexOf(34, ini_pos)));
            String line = new String(this.errorMessage.substring(e.getMessage().indexOf("line"), this.errorMessage.indexOf(44)));
            line = line.substring(line.indexOf(32) + 1, line.length());
            String column = new String(e.getMessage().substring(this.errorMessage.indexOf("column"), this.errorMessage.indexOf(46)));
            column = column.substring(column.indexOf(32) + 1, column.length());
            this.errorPosition[0] = Integer.valueOf(line.trim());
            this.errorPosition[1] = Integer.valueOf(column.trim());
            if (this.onlyWhereStatement) {
                this.errorPosition[1] = this.errorPosition[1] - this.preQueryLenght;
            }
            this.defineErrorPositionAsMessageAttribute(this.errorPosition);
            return false;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorPositionAsMessage() {
        return this.errorPositionAsMessage;
    }

    public int[] getErrorPosition() {
        return this.errorPosition;
    }

    public String getTokenThatProducedTheSyntacticError() {
        return this.token;
    }

    private void defineErrorPositionAsMessageAttribute(int[] position) {
        this.errorPositionAsMessage = new String(PluginServices.getText(null, (String)"line") + ": " + this.errorPosition[0] + ", " + PluginServices.getText(null, (String)"column") + ": " + this.errorPosition[1]);
    }
}

