/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultTags
implements Tags {
    private Map<String, Object> tags = null;
    private static final String TAGS_PERSISTENCE_DEFINITION_NAME = "Tags";

    @Override
    public Object get(String name) {
        DynObjectManager manager;
        DynField definition;
        if (this.tags == null) {
            return null;
        }
        Object value = this.tags.get(name.toLowerCase());
        if (value != null && (definition = (manager = ToolsLocator.getDynObjectManager()).getTags().get(name)) != null) {
            try {
                value = definition.coerce(value);
            }
            catch (CoercionException coercionException) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public Object get(String name, int type) throws CoercionException {
        if (this.tags == null || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        DataTypesManager dataman = ToolsLocator.getDataTypesManager();
        return dataman.coerce(type, this.tags.get(name.toLowerCase()));
    }

    @Override
    public Object get(String name, int type, Object defaultValue) {
        if (this.tags == null || StringUtils.isBlank((CharSequence)name)) {
            return defaultValue;
        }
        DataTypesManager dataman = ToolsLocator.getDataTypesManager();
        Object value = this.tags.get(name.toLowerCase());
        if (value == null) {
            return defaultValue;
        }
        try {
            return dataman.coerce(type, value);
        }
        catch (CoercionException ex) {
            return defaultValue;
        }
    }

    @Override
    public void set(String name, Object value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Object>();
        }
        this.tags.put(name.toLowerCase(), value);
    }

    @Override
    public boolean has(String name) {
        if (this.tags == null || StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        return this.tags.containsKey(name.toLowerCase());
    }

    @Override
    public int getInt(String name) throws CoercionException {
        Object x = this.get(name, 4);
        if (x == null) {
            return 0;
        }
        return (Integer)x;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return (Integer)this.get(name, 4, defaultValue);
    }

    @Override
    public boolean getBoolean(String name) throws CoercionException {
        Object x = this.get(name, 1);
        if (x == null) {
            return false;
        }
        return (Boolean)x;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return (Boolean)this.get(name, 1, defaultValue);
    }

    @Override
    public String getString(String name) throws CoercionException {
        Object x = this.get(name, 8);
        return (String)x;
    }

    @Override
    public String getString(String name, String defaultValue) {
        return (String)this.get(name, 8, defaultValue);
    }

    @Override
    public Iterator iterator() {
        if (this.tags == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.tags.keySet().iterator();
    }

    @Override
    public Tags clone() throws CloneNotSupportedException {
        DefaultTags newTags = (DefaultTags)super.clone();
        newTags.add(this);
        return newTags;
    }

    @Override
    public boolean isEmpty() {
        if (this.tags == null) {
            return true;
        }
        return this.tags.isEmpty();
    }

    @Override
    public void add(Tags tags) {
        if (tags.isEmpty()) {
            return;
        }
        for (String key : tags) {
            this.set(key, tags.get(key));
        }
    }

    @Override
    public void removeAll() {
        this.tags = null;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        this.tags = null;
        Map elements = state.getMap("elements");
        if (elements != null && !elements.isEmpty()) {
            this.tags = new HashMap<String, Object>();
            for (Map.Entry entry : elements.entrySet()) {
                this.tags.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("elements", this.tags);
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(TAGS_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultTags.class, TAGS_PERSISTENCE_DEFINITION_NAME, "Tags persistent definition", null, null);
            definition.addDynFieldMap("elements").setClassOfItems(Object.class);
        }
    }
}

