/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.impl.DynClassImportExportTags;
import org.gvsig.tools.script.Script;

public class DynClassExportHelper
implements DynClassImportExportTags {
    public void exportSimpleDefinition(File out, DynClass dynClass) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(out);
        this.exportSimpleDefinition(os, dynClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSimpleDefinition(OutputStream out, DynClass dynClass) {
        try (PrintStream writer = null;){
            writer = new PrintStream(out);
            writer.print(this.exportSimpleDefinition(dynClass));
        }
    }

    public String exportSimpleDefinition(DynClass dynClass) {
        Script script;
        int indent = 0;
        XMLHelper buffer = new XMLHelper();
        buffer.append("<?xml version=\"1.0\"?>\n");
        buffer.append(indent++, "definitions");
        buffer.append(indent, "version", "1.0.0");
        buffer.append(indent++, "classes");
        XMLTag tag = buffer.createTag("class");
        tag.set("name", dynClass.getName());
        buffer.append(indent++, tag);
        buffer.append(indent++, "extends");
        DynClass[] superDynClasses = dynClass.getSuperDynClasses();
        if (superDynClasses != null) {
            for (int i = 0; i < superDynClasses.length; ++i) {
                DynClass superDynClass = superDynClasses[i];
                tag = buffer.createTag("class");
                tag.set("namespace", superDynClass.getNamespace());
                tag.set("name", superDynClass.getName());
                buffer.append(indent, tag);
                buffer.close(indent, tag);
            }
        }
        buffer.close(--indent, "extends");
        buffer.append(indent, "description", dynClass.getDescription());
        if (dynClass instanceof DynClass_v2 && (script = ((DynClass_v2)dynClass).getScript()) != null) {
            tag = buffer.createTag("code");
            tag.set("langcode", script.getTypeName());
            tag.setText(script.getCode());
            tag.close();
            buffer.append(indent, tag);
        }
        buffer.append(indent++, "fields");
        DynField[] fields = dynClass.getDeclaredDynFields();
        for (int ifields = 0; ifields < fields.length; ++ifields) {
            DynField field = fields[ifields];
            tag = buffer.createTag("field");
            tag.set("name", field.getName());
            tag.set("type", field.getDataType().getName());
            tag.set("mandatory", field.isMandatory());
            tag.set("minValue", field.getMinValue());
            tag.set("maxValue", field.getMaxValue());
            tag.set("defaultValue", field.getDefaultValue());
            tag.set("group", field.getGroup());
            tag.set("order", field.getOder());
            tag.set("hidden", field.isHidden());
            tag.set("readonly", field.isReadOnly());
            buffer.append(indent++, tag);
            buffer.append(indent, "description", field.getDescription());
            DynObjectValueItem[] values = field.getAvailableValues();
            if (values != null && values.length > 0) {
                buffer.append(indent++, "availableValues");
                for (int ivalues = 0; ivalues < values.length; ++ivalues) {
                    DynObjectValueItem value = values[ivalues];
                    tag = buffer.createTag("value");
                    tag.set("label", value.getLabel());
                    tag.set("value", value.getValue());
                    buffer.append(indent, tag);
                    buffer.close(indent, tag);
                }
                buffer.close(++indent, "availableValues");
            }
            buffer.close(--indent, "field");
        }
        buffer.close(--indent, "fields");
        buffer.close(--indent, "class");
        buffer.close(--indent, "classes");
        buffer.close(indent, "definitions");
        return buffer.toString();
    }

    private class XMLHelper {
        private StringBuffer buffer = new StringBuffer();

        XMLHelper() {
        }

        public XMLHelper append(String tagname) {
            this.buffer.append(tagname);
            return this;
        }

        public XMLHelper append(int indent, String tagname) {
            this.indent(indent);
            this.buffer.append("<").append(tagname).append(">\n");
            return this;
        }

        public XMLHelper append(int indent, String tagname, String value) {
            if (value == null) {
                value = "";
            }
            this.indent(indent);
            this.buffer.append("<").append(tagname).append(">").append(value).append("</").append(tagname).append(">\n");
            return this;
        }

        public XMLHelper close(int indent, String tagname) {
            this.indent(indent);
            this.buffer.append("</").append(tagname).append(">\n");
            return this;
        }

        public XMLHelper close(int indent, XMLTag tag) {
            this.close(indent, tag.getTagname());
            return this;
        }

        public XMLTag createTag(String tagname) {
            return new XMLTag(tagname, -1);
        }

        public XMLTag createTag(String tagname, int indent) {
            return new XMLTag(tagname, indent);
        }

        public XMLHelper append(int indent, XMLTag tag) {
            this.indent(indent);
            this.buffer.append(tag.toString());
            return this;
        }

        private void indent(int indent) {
            if (indent < 1) {
                return;
            }
            String spaces = "                                                                      ";
            if (indent * 2 > spaces.length()) {
                this.buffer.append(spaces);
            } else {
                this.buffer.append(spaces.substring(0, indent * 2));
            }
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    private class XMLTag {
        private String tagname;
        private Map attributes = new LinkedHashMap();
        private String text = null;
        private boolean close = false;
        private int indent = -1;

        public XMLTag(String tagname, int indent) {
            this.tagname = tagname;
            this.indent = indent;
        }

        public String getTagname() {
            return this.tagname;
        }

        public void set(String name, String value) {
            if (value == null) {
                return;
            }
            this.attributes.put(name, value);
        }

        public void set(String name, int value) {
            this.attributes.put(name, Integer.toString(value));
        }

        public void set(String name, Object value) {
            if (value == null) {
                return;
            }
            this.attributes.put(name, value.toString());
        }

        public void set(String name, boolean value) {
            this.attributes.put(name, value ? "true" : "false");
        }

        public void close() {
            this.close = true;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            buffer.append(this.tagname);
            if (this.attributes.size() > 0) {
                for (Map.Entry entry : this.attributes.entrySet()) {
                    buffer.append(" ");
                    buffer.append(entry.getKey());
                    buffer.append("=\"");
                    buffer.append(entry.getValue());
                    buffer.append("\"");
                }
            }
            buffer.append(">");
            if (!StringUtils.isEmpty((CharSequence)this.text)) {
                if (StringUtils.isAlphanumeric((CharSequence)this.text)) {
                    buffer.append(this.text);
                } else {
                    buffer.append("\n<![CDATA[\n");
                    buffer.append(this.text);
                    buffer.append("\n]]>\n");
                }
            } else {
                buffer.append("\n");
            }
            if (this.close) {
                buffer.append(this.spaces(this.indent));
                buffer.append("</").append(this.tagname).append(">\n");
            }
            return buffer.toString();
        }

        private String spaces(int indent) {
            if (indent < 1) {
                return "";
            }
            String spaces = "                                                                      ";
            if (indent * 2 > spaces.length()) {
                return spaces;
            }
            return spaces.substring(0, indent * 2);
        }
    }
}

