/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundResourcesStorage
extends AbstractDisposable
implements ResourcesStorage,
Iterable<ResourcesStorage> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CompoundResourcesStorage.class);
    private List<ResourcesStorage> storages = new ArrayList<ResourcesStorage>();

    public CompoundResourcesStorage(ResourcesStorage ... storages) {
        if (storages != null) {
            for (ResourcesStorage storage : storages) {
                if (storage == null) continue;
                this.storages.add(storage);
            }
        }
        if (this.storages.size() > 1) {
            this.storages.sort((o1, o2) -> {
                int v1 = o1.isReadOnly() ? 0 : 1;
                int v2 = o2.isReadOnly() ? 0 : 1;
                return Integer.compare(v1, v2);
            });
        }
    }

    @Override
    public String getSeparator() {
        if (this.storages == null || this.storages.isEmpty()) {
            return null;
        }
        return this.storages.get(0).getSeparator();
    }

    @Override
    public ResourcesStorage.Resource getResource(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return null;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).getResource(resourceName);
        }
        return new CompoundResource(resourceName);
    }

    @Override
    public List<ResourcesStorage.Resource> getResources(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).getResources(resourceName);
        }
        HashMap<URL, ResourcesStorage.Resource> ress = new HashMap<URL, ResourcesStorage.Resource>();
        for (ResourcesStorage storage : this.storages) {
            List<ResourcesStorage.Resource> x = storage.getResources(resourceName);
            if (x == null) continue;
            for (ResourcesStorage.Resource res : x) {
                ress.put(res.getURL(), res);
            }
        }
        if (ress.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResourcesStorage.Resource> l = new ArrayList<ResourcesStorage.Resource>(ress.values());
        return l;
    }

    @Override
    public ResourcesStorage.Resource getLocalizedResource(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return null;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).getLocalizedResource(resourceName);
        }
        return new CompoundResource(resourceName){

            @Override
            protected ResourcesStorage.Resource getResource(ResourcesStorage storage) {
                return storage.getLocalizedResource(this.name);
            }
        };
    }

    @Override
    public List<ResourcesStorage.Resource> getLocalizedResources(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).getLocalizedResources(resourceName);
        }
        HashMap<URL, ResourcesStorage.Resource> ress = new HashMap<URL, ResourcesStorage.Resource>();
        for (ResourcesStorage storage : this.storages) {
            List<ResourcesStorage.Resource> x = storage.getLocalizedResources(resourceName);
            if (x == null) continue;
            for (ResourcesStorage.Resource res : x) {
                ress.put(res.getURL(), res);
            }
        }
        if (ress.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResourcesStorage.Resource> l = new ArrayList<ResourcesStorage.Resource>(ress.values());
        return l;
    }

    @Override
    public boolean isEmpty() {
        if (this.storages == null || this.storages.isEmpty()) {
            return true;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).isEmpty();
        }
        for (ResourcesStorage storage : this.storages) {
            if (storage.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.storages == null || this.storages.isEmpty()) {
            return true;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).isReadOnly();
        }
        for (ResourcesStorage storage : this.storages) {
            if (storage.isReadOnly()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean exists(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return false;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).exists(resourceName);
        }
        for (ResourcesStorage storage : this.storages) {
            if (!storage.exists(resourceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String resourceName) {
        if (this.storages == null || this.storages.isEmpty()) {
            return false;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).remove(resourceName);
        }
        for (ResourcesStorage storage : this.storages) {
            if (!storage.allowRemove() || !storage.remove(resourceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String resourceName, InputStream is) {
        if (this.storages == null || this.storages.isEmpty()) {
            return false;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).add(resourceName, is);
        }
        for (ResourcesStorage storage : this.storages) {
            try {
                storage.add(resourceName, is);
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Can't add resource '" + resourceName + "'", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean allowRemove() {
        if (this.storages == null || this.storages.isEmpty()) {
            return false;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).allowRemove();
        }
        for (ResourcesStorage storage : this.storages) {
            if (!storage.allowRemove()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getResourceNames() {
        if (this.storages == null || this.storages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.storages.size() == 1) {
            return this.storages.get(0).getResourceNames();
        }
        HashSet<String> names = new HashSet<String>();
        for (ResourcesStorage storage : this.storages) {
            List<String> x = storage.getResourceNames();
            if (x == null) continue;
            for (String name : x) {
                names.add(name);
            }
        }
        if (names.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> l = new ArrayList<String>(names);
        return l;
    }

    @Override
    protected void doDispose() throws BaseException {
        if (this.storages != null) {
            for (ResourcesStorage storage : this.storages) {
                DisposeUtils.disposeQuietly(storage);
            }
            this.storages.clear();
            this.storages = null;
        }
    }

    @Override
    public void clearCache() {
        if (this.storages == null || this.storages.isEmpty()) {
            return;
        }
        for (ResourcesStorage storage : this.storages) {
            if (storage == null) continue;
            storage.clearCache();
        }
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            if (this.storages != null) {
                builder.append("storages", this.storages.toArray(), true);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public Iterator<ResourcesStorage> iterator() {
        return Collections.unmodifiableCollection(this.storages).iterator();
    }

    private class CompoundResource
    implements ResourcesStorage.Resource {
        protected final String name;
        private ResourcesStorage.Resource resource;

        public CompoundResource(String name) {
            this.name = name;
            this.resource = null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadOnly() {
            return CompoundResourcesStorage.this.isReadOnly();
        }

        @Override
        public URL getURL() {
            if (this.resource == null) {
                if (this.exists()) {
                    return this.resource.getURL();
                }
                ResourcesStorage storage = (ResourcesStorage)CompoundResourcesStorage.this.storages.get(0);
                if (storage.isReadOnly()) {
                    return null;
                }
                this.resource = this.getResource(storage);
            }
            return this.resource.getURL();
        }

        @Override
        public boolean exists() {
            if (this.resource != null) {
                return this.resource.exists();
            }
            if (CompoundResourcesStorage.this.storages.size() == 1) {
                this.resource = this.getResource((ResourcesStorage)CompoundResourcesStorage.this.storages.get(0));
                return this.resource.exists();
            }
            for (ResourcesStorage storage : CompoundResourcesStorage.this.storages) {
                if (!storage.exists(this.name)) continue;
                this.resource = this.getResource(storage);
                return true;
            }
            return false;
        }

        @Override
        public InputStream asInputStream() throws IOException {
            if (this.exists()) {
                return this.resource.asInputStream();
            }
            return null;
        }

        @Override
        public OutputStream asOutputStream() throws IOException {
            if (this.exists()) {
                return this.resource.asOutputStream();
            }
            ResourcesStorage storage = (ResourcesStorage)CompoundResourcesStorage.this.storages.get(0);
            if (storage.isReadOnly()) {
                return null;
            }
            this.resource = this.getResource(storage);
            return this.resource.asOutputStream();
        }

        @Override
        public void close() {
            if (this.resource != null) {
                this.resource.close();
            }
        }

        protected ResourcesStorage.Resource getResource(ResourcesStorage storage) {
            return storage.getResource(this.name);
        }
    }
}

