/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserDefault;
import org.h2gis.functions.io.gpx.model.GPXCoordinate;
import org.h2gis.functions.io.gpx.model.GPXLine;
import org.h2gis.functions.io.gpx.model.GPXPoint;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.h2gis.functions.io.gpx.model.GpxParserRte;
import org.h2gis.functions.io.gpx.model.GpxParserTrk;
import org.h2gis.functions.io.gpx.model.GpxParserWpt;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GpxParser
extends AbstractGpxParserDefault {
    private boolean author;
    private String year;
    private String license;
    private String copyrighter;
    private int idWpt = 1;
    private int idRte = 1;
    private int trkID = 1;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (localName.equalsIgnoreCase(GPXTags.LINK)) {
            if (this.author) {
                this.setAuthorLink(attributes.getValue(GPXTags.HREF));
            } else if (!this.isSpecificElement()) {
                this.setLink(attributes.getValue(GPXTags.HREF));
            }
        } else if (localName.equalsIgnoreCase(GPXTags.EMAIL)) {
            this.setEmail(attributes.getValue(GPXTags.ID) + "@" + attributes.getValue(GPXTags.DOMAIN));
        } else if (localName.equalsIgnoreCase(GPXTags.COPYRIGHT)) {
            this.copyrighter = attributes.getValue(GPXTags.AUTHOR);
        } else if (localName.equalsIgnoreCase(GPXTags.AUTHOR)) {
            this.author = true;
        } else if (localName.equalsIgnoreCase(GPXTags.WPT)) {
            this.setSpecificElement(true);
            try {
                GPXPoint currentPoint = new GPXPoint(24);
                Coordinate coordinate = GPXCoordinate.createCoordinate(attributes);
                Point geom = this.getGeometryFactory().createPoint(coordinate);
                geom.setSRID(4326);
                currentPoint.setValue(0, geom);
                currentPoint.setValue(2, coordinate.y);
                currentPoint.setValue(3, coordinate.x);
                currentPoint.setValue(4, coordinate.z);
                currentPoint.setValue(1, this.idWpt++);
                this.setCurrentPoint(currentPoint);
                this.setWptParser(new GpxParserWpt(this.getReader(), this));
                this.getReader().setContentHandler(this.getWptParser());
            }
            catch (NumberFormatException ex) {
                throw new SAXException(ex);
            }
        } else if (localName.equalsIgnoreCase(GPXTags.RTE)) {
            this.setSpecificElement(true);
            GPXLine route = new GPXLine(11);
            route.setValue(1, this.idRte++);
            this.setCurrentLine(route);
            this.setRteParser(new GpxParserRte(this.getReader(), this));
            this.getReader().setContentHandler(this.getRteParser());
        } else if (localName.equalsIgnoreCase(GPXTags.TRK)) {
            this.setSpecificElement(true);
            GPXLine track = new GPXLine(11);
            track.setValue(1, this.trkID++);
            this.setCurrentLine(track);
            this.setTrkParser(new GpxParserTrk(this.getReader(), this));
            this.getReader().setContentHandler(this.getTrkParser());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
    }

    @Override
    public void clear() {
        super.clear();
        this.author = false;
        this.year = null;
        this.license = null;
        this.copyrighter = null;
    }

    @Override
    public String getCopyright() {
        return "Copyright :\n\t" + this.copyrighter + "\n\t" + this.year + "\n\t" + this.license;
    }
}

