/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document.gui.properties;

import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.report.app.mainplugin.document.gui.properties.GeneralDocumentPropertiesPageView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;

public class GeneralDocumentPropertiesPage
extends GeneralDocumentPropertiesPageView
implements PropertiesPage {
    private final Document document;
    private final PickerController<Date> creationDateController;

    public GeneralDocumentPropertiesPage(Document document) {
        this.creationDateController = ToolsSwingLocator.getToolsSwingManager().createDatePickerController((JTextComponent)this.txtCreationDate, this.btnCreationDate);
        this.document = document;
        this.initComponents();
    }

    private void initComponents() {
        this.txtComments.setText(this.document.getComment());
        this.txtName.setText(this.document.getName());
        this.txtOwner.setText(this.document.getOwner());
        this.creationDateController.coerceAndSet((Object)this.document.getCreationDate());
    }

    public void setData(Object data) {
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Project project = application.getCurrentProject();
        List documents = project.getDocuments(this.document.getTypeName());
        for (Document theDocument : documents) {
            if (this.document.equals(theDocument) || !theDocument.getName().equals(name)) continue;
            application.messageDialog(i18n.getTranslation("elemento_ya_existe"), null, i18n.getTranslation("_Warning"), 2, "_Already_exists_a_document_with_this_name");
            return false;
        }
        this.document.setName(name);
        this.document.setCreationDate(((Date)this.creationDateController.get()).toString());
        this.document.setOwner(this.txtOwner.getText());
        this.document.setComment(this.txtComments.getText());
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("General");
    }

    public int getPriority() {
        return 10000;
    }

    public JComponent asJComponent() {
        return this;
    }

    public Document getDocument() {
        return this.document;
    }
}

