/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.legend;

import java.util.List;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.sldconverter.exception.UnsupportedLegendException;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.legend.IntervalsLegendUtils;
import org.gvsig.sldconverter.impl.legend.SingleSymbolLegendUtils;
import org.gvsig.sldconverter.impl.legend.UniqueSymbolLegendUtils;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldconverter.legend.LegendToSLDConverter;
import org.gvsig.sldconverter.legend.SLDToLegendConverter;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;

public class BasicLegendConverter
implements LegendToSLDConverter,
SLDToLegendConverter {
    public ILegend convert(SLDLayer layer) throws UnsupportedSLDObjectException {
        if (layer == null) {
            throw new UnsupportedSLDObjectException("SLDLayer", "Null");
        }
        SLDUserStyle sty = BasicUtils.getFirstUserStyle(layer);
        if (sty == null) {
            throw new UnsupportedSLDObjectException("SLDLayer", "Bad structure");
        }
        List fstys = sty.getFeatureStyles();
        if (fstys == null || fstys.size() == 0) {
            throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Bad structure");
        }
        List rules = ((SLDFeatureStyle)fstys.get(0)).getRules();
        if (SingleSymbolLegendUtils.areRulesOfSingleSymbol(rules)) {
            return SingleSymbolLegendUtils.toSingleSymbolLegend(rules);
        }
        if (UniqueSymbolLegendUtils.areRulesOfUniqueSymbol(rules)) {
            return UniqueSymbolLegendUtils.toUniqueValueLegend(rules);
        }
        if (IntervalsLegendUtils.areRulesOfIntervals(rules)) {
            return IntervalsLegendUtils.toIntervalsLegend(rules);
        }
        throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Rules do not follow recognizable pattern");
    }

    public SLDLayer convert(ILegend legend) throws UnsupportedLegendException, UnsupportedSymbolException {
        if (legend instanceof ISingleSymbolLegend) {
            return SingleSymbolLegendUtils.toSLDLayer((ISingleSymbolLegend)legend);
        }
        if (legend instanceof IVectorialUniqueValueLegend) {
            return UniqueSymbolLegendUtils.toSLDLayer((IVectorialUniqueValueLegend)legend);
        }
        if (legend instanceof IVectorialIntervalLegend) {
            return IntervalsLegendUtils.toSLDLayer((IVectorialIntervalLegend)legend);
        }
        throw new UnsupportedLegendException(legend == null ? "Null" : legend.getClass().getName(), "Unsupported legend type");
    }
}

