/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.legend;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.SLDConverterManager;
import org.gvsig.sldconverter.exception.UnsupportedLegendException;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;

public class SingleSymbolLegendUtils {
    public static boolean areRulesOfSingleSymbol(List<SLDRule> rules) {
        if (rules.size() != 1) {
            return false;
        }
        SLDRule rule = rules.get(0);
        return rule.getFilter() == null;
    }

    public static ISingleSymbolLegend toSingleSymbolLegend(List<SLDRule> rules) throws UnsupportedSLDObjectException {
        SLDRule rule = null;
        SLDConverterManager man = BasicUtils.sldMan();
        ISymbol singleSym = null;
        rule = rules.get(0);
        List sld_syms = rule.getSymbols();
        if (sld_syms.size() == 1) {
            SLDSymbol aux = (SLDSymbol)sld_syms.get(0);
            singleSym = man.toSymbol(aux);
        } else {
            int geo_type = BasicUtils.getGeometryTypeForSymbols(sld_syms);
            if (geo_type == 16) {
                SLDSymbol aux = (SLDSymbol)sld_syms.get(0);
                singleSym = man.toSymbol(aux);
            } else {
                ArrayList<ISymbol> gsyms = new ArrayList<ISymbol>();
                singleSym = BasicUtils.combineSymbols(gsyms, geo_type);
            }
        }
        ISingleSymbolLegend resp = (ISingleSymbolLegend)BasicUtils.mapMan().createLegend("SingleSymbol");
        resp.setDefaultSymbol(singleSym);
        return resp;
    }

    public static SLDLayer toSLDLayer(ISingleSymbolLegend legend) throws UnsupportedLegendException, UnsupportedSymbolException {
        ISymbol sym = legend.getDefaultSymbol();
        SLDSymbol sldsym = BasicUtils.sldMan().toSLDSymbol(sym);
        SLDRule rule = new SLDRule();
        rule.getSymbols().add(sldsym);
        SLDFeatureStyle fstyle = new SLDFeatureStyle();
        fstyle.getRules().add(rule);
        SLDUserStyle usty = new SLDUserStyle();
        usty.getFeatureStyles().add(fstyle);
        SLDNamedLayer nlayer = new SLDNamedLayer();
        nlayer.setName("Name");
        nlayer.getStyles().add(usty);
        return nlayer;
    }
}

