/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.legend;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDPropertyName;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDBinaryComparisonOperator;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.gvsig.tools.dataTypes.DataType;

public class UniqueSymbolLegendUtils {
    public static IVectorialUniqueValueLegend toUniqueValueLegend(List<SLDRule> rules) throws UnsupportedSLDObjectException {
        IVectorialUniqueValueLegend unileg = (IVectorialUniqueValueLegend)BasicUtils.mapMan().createLegend("VectorialUniqueValue");
        String pname = BasicUtils.getFirstPropertyName(rules);
        if (pname == null || pname.length() == 0) {
            throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Cannot interpret rules (no property name)");
        }
        List<SLDLiteral> lits = BasicUtils.getComparisonLiterals(rules);
        if (lits == null || lits.size() == 0) {
            throw new UnsupportedSLDObjectException("SLDFeatureStyle", "Cannot interpret rules (no literals)");
        }
        DataType dt = BasicUtils.guessDataType(lits);
        ISymbol sym = BasicUtils.getElseSymbol(rules);
        Map<Object, ISymbol> map = BasicUtils.getValueToSymbol(rules, dt, pname);
        Iterator<Object> iter = map.keySet().iterator();
        Object k = null;
        while (iter.hasNext()) {
            k = iter.next();
            unileg.addSymbol(k, map.get(k));
        }
        if (sym != null) {
            unileg.setDefaultSymbol(sym);
            unileg.useDefaultSymbol(true);
        } else {
            unileg.useDefaultSymbol(false);
        }
        String[] atts = new String[]{pname};
        unileg.setClassifyingFieldNames(atts);
        int[] typs = new int[]{dt.getType()};
        unileg.setClassifyingFieldTypes(typs);
        return unileg;
    }

    public static boolean areRulesOfUniqueSymbol(List<SLDRule> rules) {
        if (rules == null || rules.size() == 0) {
            return false;
        }
        SLDRule rule = null;
        String fieldName = null;
        for (int i = 0; i < rules.size() && (fieldName = UniqueSymbolLegendUtils.getEqualsLiteralFieldName(rule = rules.get(i))) == null; ++i) {
        }
        if (fieldName == null) {
            return false;
        }
        int elsecount = 0;
        for (int i = 1; i < rules.size(); ++i) {
            rule = rules.get(i);
            if (!BasicUtils.isElse(rule)) {
                String fname = UniqueSymbolLegendUtils.getEqualsLiteralFieldName(rule);
                if (fname != null && fname.compareTo(fieldName) == 0) continue;
                return false;
            }
            ++elsecount;
        }
        return elsecount < 2;
    }

    private static String getEqualsLiteralFieldName(SLDRule rule) {
        SLDFilter filt = rule.getFilter();
        if (filt == null) {
            return null;
        }
        SLDFilterOperator oper = filt.getFilterOperator();
        if (!(oper instanceof SLDBinaryComparisonOperator)) {
            return null;
        }
        SLDBinaryComparisonOperator bop = (SLDBinaryComparisonOperator)oper;
        if (bop.getComparisonOperator().compareToIgnoreCase("PropertyIsEqualTo") != 0) {
            return null;
        }
        SLDPropertyName pname = null;
        if (bop.getFirstExpression() instanceof SLDLiteral && bop.getSecondExpression() instanceof SLDPropertyName) {
            pname = (SLDPropertyName)bop.getSecondExpression();
            return pname.getPropertyName();
        }
        if (bop.getSecondExpression() instanceof SLDLiteral && bop.getFirstExpression() instanceof SLDPropertyName) {
            pname = (SLDPropertyName)bop.getFirstExpression();
            return pname.getPropertyName();
        }
        return null;
    }

    public static SLDLayer toSLDLayer(IVectorialUniqueValueLegend legend) throws UnsupportedSymbolException {
        String fname = legend.getClassifyingFieldNames()[0];
        SLDSymbol sldsym = null;
        SLDRule rule = null;
        SLDFeatureStyle fstyle = new SLDFeatureStyle();
        Object val = null;
        String valstr = null;
        Object[] vals = legend.getValues();
        ISymbol[] syms = legend.getSymbols();
        int n = Math.min(vals.length, syms.length);
        SLDFilter filt = null;
        SLDBinaryComparisonOperator oper = null;
        for (int i = 0; i < n; ++i) {
            rule = new SLDRule();
            sldsym = BasicUtils.sldMan().toSLDSymbol(syms[i]);
            rule.getSymbols().add(sldsym);
            filt = BasicUtils.supMan().createFilter();
            filt.setIsElse(false);
            oper = new SLDBinaryComparisonOperator();
            oper.setComparisonOperator("PropertyIsEqualTo");
            oper.setFirstExpression((SLDExpression)new SLDPropertyName(fname));
            val = vals[i];
            valstr = BasicUtils.valueToString(val);
            oper.setSecondExpression((SLDExpression)new SLDLiteral(valstr));
            filt.setFilterOperator((SLDFilterOperator)oper);
            rule.setFilter(filt);
            fstyle.getRules().add(rule);
        }
        ISymbol sym = legend.getDefaultSymbol();
        if (sym != null) {
            rule = new SLDRule();
            sldsym = BasicUtils.sldMan().toSLDSymbol(sym);
            rule.getSymbols().add(sldsym);
            filt = BasicUtils.supMan().createFilter();
            filt.setIsElse(true);
            rule.setFilter(filt);
            fstyle.getRules().add(rule);
        }
        SLDUserStyle usty = new SLDUserStyle();
        usty.getFeatureStyles().add(fstyle);
        SLDNamedLayer nlayer = new SLDNamedLayer();
        nlayer.setName("Name");
        nlayer.getStyles().add(usty);
        return nlayer;
    }
}

