/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.symbol;

import java.awt.Color;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.symbol.PointSymbolUtils;
import org.gvsig.sldconverter.impl.util.BasicUtils;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.symbol.SLDPolygonSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IPictureFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;

public class PolygonSymbolUtils {
    public static ISymbol toFillSymbol(SLDPolygonSymbol sym) throws UnsupportedSLDObjectException {
        ISimpleFillSymbol resp = BasicUtils.symMan().createSimpleFillSymbol();
        SLDFill fill = sym.getFill();
        SLDGraphic gra = fill.getFillGraphic();
        SLDStroke stro = sym.getStroke();
        Color borderColor = null;
        Double borderWidth = null;
        if (gra == null) {
            Color aux_co = BasicUtils.toColor(fill.getFillColor());
            if (aux_co != null) {
                resp.setFillColor(aux_co);
            }
            if ((borderColor = BasicUtils.toColor(stro.getColor())) != null) {
                resp.getOutline().setColor(borderColor);
            }
            if ((borderWidth = BasicUtils.toDouble(stro.getWidth())) != null) {
                resp.getOutline().setLineWidth(borderWidth.doubleValue());
            }
            return resp;
        }
        ISymbol aux = PointSymbolUtils.toMarkerSymbol(gra);
        if (aux instanceof IPictureMarkerSymbol) {
            IPictureMarkerSymbol pms = (IPictureMarkerSymbol)aux;
            IPictureFillSymbol pfs = null;
            try {
                pfs = BasicUtils.symMan().createPictureFillSymbol(pms.getSource(), pms.getSelectedSource());
            }
            catch (Exception exc) {
                throw new UnsupportedSLDObjectException((Throwable)exc, "SLDPolygonSymbol", "This type of grachic not supported as fill graphic: " + aux.getClass().getName());
            }
            return pfs;
        }
        throw new UnsupportedSLDObjectException("SLDPolygonSymbol", "This type of grachic not supported as fill graphic: " + aux.getClass().getName());
    }

    public static SLDPolygonSymbol toSLDPolygonSymbol(IFillSymbol sym) throws UnsupportedSymbolException {
        Color color = sym.getOutline().getColor();
        double w = sym.getOutline().getLineWidth();
        SLDStroke stro = new SLDStroke();
        if (color != null) {
            stro.setColor(color);
        }
        stro.setWidth((SLDExpression)new SLDLiteral(BasicUtils.df.format(w)));
        color = sym.getColor();
        SLDFill fill = new SLDFill();
        if (color != null) {
            fill.setFillColor(color);
        }
        SLDPolygonSymbol resp = new SLDPolygonSymbol();
        resp.setFill(fill);
        resp.setStroke(stro);
        return resp;
    }
}

