/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.colorchooser.ColorChooserMainPanel;
import ch.randelshofer.quaqua.colorchooser.QuaquaColorPreviewPanel;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class QuaquaColorChooserUI
extends ColorChooserUI {
    protected ColorChooserMainPanel mainPanel;
    protected JColorChooser chooser;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected JComponent previewPanel;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    private MouseListener previewMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaColorChooserUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        AbstractColorChooserPanel[] oldPanels = this.chooser.getChooserPanels();
        this.installDefaults();
        this.chooser.setLayout(new BorderLayout());
        this.mainPanel = new ColorChooserMainPanel();
        this.chooser.add(this.mainPanel);
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
        AbstractColorChooserPanel[] newPanels = this.chooser.getChooserPanels();
        this.updateColorChooserPanels(oldPanels, newPanels);
        this.installListeners();
        this.chooser.applyComponentOrientation(c.getComponentOrientation());
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] defaultChooserNames = (String[])UIManager.get("ColorChooser.defaultChoosers");
        ArrayList<Object> panels = new ArrayList<Object>(defaultChooserNames.length);
        for (int i = 0; i < defaultChooserNames.length; ++i) {
            try {
                panels.add(Methods.newInstance(defaultChooserNames[i]));
                continue;
            }
            catch (AccessControlException e) {
                System.err.println("QuaquaColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                System.err.println("QuaquaColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                e.printStackTrace();
                continue;
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("QuaquaColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                continue;
            }
            catch (Throwable t) {
                System.err.println("QuaquaColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
            }
        }
        return panels.toArray(new AbstractColorChooserPanel[panels.size()]);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.mainPanel);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.mainPanel.setPreviewPanel(null);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.mainPanel = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler th = this.chooser.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
        this.previewMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (QuaquaColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler th = QuaquaColorChooserUI.this.chooser.getTransferHandler();
                    th.exportAsDrag(QuaquaColorChooserUI.this.chooser, e, 1);
                }
            }
        };
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void installPreviewPanel() {
        Dimension layoutSize;
        if (this.previewPanel != null) {
            this.previewPanel.removeMouseListener(this.previewMouseListener);
            this.mainPanel.setPreviewPanel(null);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && (layoutSize = new BorderLayout().minimumLayoutSize(this.previewPanel)).getWidth() + layoutSize.getHeight() == 0.0) {
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new QuaquaColorPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.mainPanel.setPreviewPanel(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    private void updateColorChooserPanels(AbstractColorChooserPanel[] oldPanels, AbstractColorChooserPanel[] newPanels) {
        int i;
        for (i = 0; i < oldPanels.length; ++i) {
            Container wrapper = oldPanels[i].getParent();
            if (wrapper == null) continue;
            Container parent = wrapper.getParent();
            if (parent != null) {
                parent.remove(wrapper);
            }
            oldPanels[i].uninstallChooserPanel(this.chooser);
        }
        this.mainPanel.removeAllColorChooserPanels();
        for (i = 0; i < newPanels.length; ++i) {
            if (newPanels[i] == null) continue;
            this.mainPanel.addColorChooserPanel(newPanels[i]);
        }
        for (i = 0; i < newPanels.length; ++i) {
            if (newPanels[i] == null) continue;
            newPanels[i].installChooserPanel(this.chooser);
        }
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("chooserPanels")) {
                int i;
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (i = 0; i < oldPanels.length; ++i) {
                    Container wrapper;
                    if (oldPanels[i] == null || (wrapper = oldPanels[i].getParent()) == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(QuaquaColorChooserUI.this.chooser);
                }
                QuaquaColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    QuaquaColorChooserUI.this.mainPanel.addColorChooserPanel(newPanels[i]);
                }
                QuaquaColorChooserUI.this.chooser.applyComponentOrientation(QuaquaColorChooserUI.this.chooser.getComponentOrientation());
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    newPanels[i].installChooserPanel(QuaquaColorChooserUI.this.chooser);
                }
            }
            if (name.equals("previewPanel") && e.getNewValue() != QuaquaColorChooserUI.this.previewPanel) {
                QuaquaColorChooserUI.this.installPreviewPanel();
            }
            if (name.equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JColorChooser cc = (JColorChooser)e.getSource();
                if (o != (ComponentOrientation)e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                    cc.updateUI();
                }
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel model = (ColorSelectionModel)e.getSource();
            if (QuaquaColorChooserUI.this.previewPanel != null) {
                QuaquaColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                QuaquaColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

