/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.rectangularmatrix;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangularMatrixEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RectangularMatrixEditingProvider.class);
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    private final EditingServiceParameter selection;
    private final EditingServiceParameter columns;
    private final EditingServiceParameter rows;
    private final EditingServiceParameter basePoint;
    private final EditingServiceParameter columnDistance;
    private final EditingServiceParameter rowDistance;
    private List<Feature> selectedFeatures;

    public RectangularMatrixEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.basePoint = new DefaultEditingServiceParameter("indicate_new_point", "indicate_new_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.columns = new DefaultEditingServiceParameter("columns_number", "columns_number", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.rows = new DefaultEditingServiceParameter("rows_number", "rows_number", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.columnDistance = new DefaultEditingServiceParameter("distance_between_columns", "distance_between_columns", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
        this.rowDistance = new DefaultEditingServiceParameter("distance_between_rows", "distance_between_rows", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.columns) == null) {
            return this.columns;
        }
        if (this.values.get(this.rows) == null) {
            return this.rows;
        }
        if (this.values.get(this.basePoint) == null) {
            return this.basePoint;
        }
        if (this.values.get(this.columnDistance) == null) {
            return this.columnDistance;
        }
        if (this.values.get(this.rowDistance) == null) {
            return this.rowDistance;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        Integer columnsValue = (Integer)this.values.get(this.columns);
        Integer rowsValue = (Integer)this.values.get(this.rows);
        Point basePointValue = (Point)this.values.get(this.basePoint);
        Double columnDistanceValue = (Double)this.values.get(this.columnDistance);
        Double rowDistanceValue = (Double)this.values.get(this.rowDistance);
        if (CollectionUtils.isNotEmpty(this.selectedFeatures) && columnsValue != null && rowsValue != null && basePointValue != null) {
            int subtype = basePointValue.getGeometryType().getSubType();
            if (columnDistanceValue == null) {
                columnDistanceValue = mousePosition.getX() - basePointValue.getX();
            }
            if (rowDistanceValue == null) {
                rowDistanceValue = mousePosition.getY() - basePointValue.getY();
            }
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            drawingStatus.addStatus((Geometry)basePointValue, auxiliaryPointSymbolEditing, "");
            try {
                double textDistance = basePointValue.distance((Geometry)mousePosition) / 6.0;
                String columnsText = i18nManager.getTranslation("distance_between_columns").concat(" ").concat(String.valueOf(columnDistanceValue));
                Point pointText = geometryManager.createPoint(mousePosition.getX() + textDistance * Math.cos(0.7853981633974483), mousePosition.getY() + textDistance * Math.sin(0.7853981633974483), subtype);
                drawingStatus.addStatus((Geometry)pointText, (ISymbol)this.getTextSymbol(), columnsText);
                String rowsText = i18nManager.getTranslation("distance_between_rows").concat(" ").concat(String.valueOf(rowDistanceValue));
                pointText = geometryManager.createPoint(mousePosition.getX() + textDistance * Math.cos(0.7853981633974483), mousePosition.getY() + textDistance * Math.sin(4.71238898038469), subtype);
                drawingStatus.addStatus((Geometry)pointText, (ISymbol)this.getTextSymbol(), rowsText);
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
            try {
                for (Feature feature : this.selectedFeatures) {
                    Geometry[][] matrix;
                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                    Geometry geometry = feature.getDefaultGeometry();
                    Geometry[][] geometryArray = matrix = this.createRectangularMatrix(geometry, columnsValue, rowsValue, basePointValue, columnDistanceValue, rowDistanceValue);
                    int n = geometryArray.length;
                    for (int i = 0; i < n; ++i) {
                        Geometry[] row;
                        for (Geometry element : row = geometryArray[i]) {
                            if (element == null) continue;
                            ISymbol symbol = this.getSymbol(element);
                            if (element instanceof Aggregate) {
                                int primitivesNumber = ((Aggregate)element).getPrimitivesNumber();
                                for (int k = 0; k < primitivesNumber; ++k) {
                                    drawingStatus.addStatus((Geometry)((Aggregate)element).getPrimitiveAt(k), symbol, "");
                                    drawingStatus.addStatus((Geometry)((Aggregate)element).getPrimitiveAt(k), previewSymbol, "");
                                }
                                continue;
                            }
                            drawingStatus.addStatus(element, symbol, "");
                            drawingStatus.addStatus(element, previewSymbol, "");
                        }
                    }
                }
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return drawingStatus;
    }

    private ISymbol getSymbol(Geometry geometry) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        if (geometry instanceof Curve || geometry instanceof MultiCurve) {
            return lineSymbolEditing;
        }
        if (geometry instanceof Surface || geometry instanceof MultiSurface) {
            return polygonSymbolEditing;
        }
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return auxiliaryPointSymbolEditing;
        }
        return null;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    private Geometry[][] createRectangularMatrix(Geometry geometry, int columnsValue, int rowsValue, Point basePointValue, double spacingColumns, double spacingRows) throws BaseException {
        Geometry[][] geometryMatrix = new Geometry[columnsValue][rowsValue];
        for (int i = 0; i < columnsValue; ++i) {
            for (int j = 0; j < rowsValue; ++j) {
                if (i == 0 && j == 0) continue;
                AffineTransform at = new AffineTransform();
                at.translate(spacingColumns * (double)i, spacingRows * (double)j);
                Geometry clonedGeoemtry = geometry.cloneGeometry();
                clonedGeoemtry.transform(at);
                geometryMatrix[i][j] = clonedGeoemtry;
            }
        }
        return geometryMatrix;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.basePoint);
        parameters.add(this.columns);
        parameters.add(this.rows);
        parameters.add(this.columnDistance);
        parameters.add(this.rowDistance);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        boolean insertedValue = false;
        if (parameter.equals(this.selection) && value instanceof FeatureSelection) {
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() > 0L) {
                this.values.put(parameter, featureSelection);
                this.selectedFeatures = this.getSelectedFeaturesCopy(featureSelection);
                insertedValue = true;
            }
        } else if (parameter.equals(this.columns) || parameter.equals(this.rows)) {
            Double number;
            if (value instanceof Double && (number = (Double)value) >= 1.0) {
                this.values.put(parameter, number.intValue());
                insertedValue = true;
            }
        } else if (parameter.equals(this.basePoint) && value instanceof Point) {
            this.values.put(this.basePoint, value);
            insertedValue = true;
        } else if (parameter.equals(this.columnDistance) || parameter.equals(this.rowDistance)) {
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                this.values.put(parameter, doubleValue);
                insertedValue = true;
            } else if (value instanceof Point) {
                Point basePointValue = (Point)this.values.get(this.basePoint);
                Point valuePoint = (Point)value;
                double distance = 0.0;
                if (parameter.equals(this.columnDistance)) {
                    distance = valuePoint.getX() - basePointValue.getX();
                    this.values.put(this.columnDistance, distance);
                } else if (parameter.equals(this.rowDistance)) {
                    distance = valuePoint.getY() - basePointValue.getY();
                    this.values.put(this.rowDistance, distance);
                }
                insertedValue = true;
            }
        }
        if (!insertedValue) {
            throw new InvalidEntryException(null);
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Integer columnsValue = (Integer)this.values.get(this.columns);
        Integer rowsValue = (Integer)this.values.get(this.rows);
        Point basePointValue = (Point)this.values.get(this.basePoint);
        Double spacingColumnsValue = (Double)this.values.get(this.columnDistance);
        Double spacingRowsValue = (Double)this.values.get(this.rowDistance);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        if (CollectionUtils.isNotEmpty(this.selectedFeatures) && columnsValue != null && rowsValue != null && basePointValue != null && spacingColumnsValue != null && spacingRowsValue != null) {
            try {
                for (Feature feature : this.selectedFeatures) {
                    Geometry[][] matrix;
                    Geometry geometry = feature.getDefaultGeometry();
                    Geometry[][] geometryArray = matrix = this.createRectangularMatrix(geometry, columnsValue, rowsValue, basePointValue, spacingColumnsValue, spacingRowsValue);
                    int n = geometryArray.length;
                    for (int i = 0; i < n; ++i) {
                        Geometry[] matrix1;
                        for (Geometry item : matrix1 = geometryArray[i]) {
                            EditableFeature eFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                            eFeature.setDefaultGeometry(item);
                            editingProviderServices.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
                        }
                    }
                }
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selection, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "insert-rectangular-matrix";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

