/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.ermapper.io;

import es.gva.cit.jecwcompress.EcwException;
import es.gva.cit.jecwcompress.JniObject;
import es.gva.cit.jecwcompress.NCSEcwCompressClient;
import es.gva.cit.jecwcompress.ReadCallBack;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.CancelEvent;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.ExternalCancellable;
import org.gvsig.raster.impl.store.writer.DefaultRasterWriter;

class Reader
extends JniObject
implements ReadCallBack {
    private NCSEcwCompressClient compressclient = null;
    private int width;
    private DataServerWriter dataWriter = null;
    private DefaultRasterWriter writer = null;
    private int blockSizeRead = 1;
    private int countLine = 1;
    byte[][] buf = null;
    byte[] bufband1 = null;
    byte[] bufband2 = null;
    byte[] bufband3 = null;
    byte[] bufband4 = null;
    byte[] bufband5 = null;
    byte[] bufband6 = null;
    int[] dataBuffer = null;
    byte[][] byteBuffer = null;
    private int lineasBloqueFinal = 0;
    private int nBlocks = 0;
    private int countBlock = 1;
    private int nBands = 0;
    private boolean write = true;
    private int dataType = 0;
    protected ExternalCancellable extCancellable = null;

    public Reader(DataServerWriter dataWriter, NCSEcwCompressClient compressclient, int width, int height, int blockSizeRead, int nBands, DefaultRasterWriter writer, int dataType) {
        this.compressclient = compressclient;
        this.width = width;
        this.dataWriter = dataWriter;
        this.nBands = nBands;
        this.writer = writer;
        this.dataType = dataType;
        if (blockSizeRead != 0) {
            this.blockSizeRead = blockSizeRead;
        }
        this.nBlocks = height / this.blockSizeRead;
        this.lineasBloqueFinal = height - this.nBlocks * this.blockSizeRead;
    }

    public void setCancellableRasterDriver(ExternalCancellable cancellable) {
        this.extCancellable = cancellable;
    }

    public void loadBuffer() {
        TaskEventManager taskEventManager = RasterLocator.getManager().getRasterTask();
        if (taskEventManager.getEvent() != null && taskEventManager.getEvent() instanceof CancelEvent) {
            try {
                if (this.extCancellable != null) {
                    this.extCancellable.processFinalize();
                }
                this.compressclient.NCSEcwCompressCancel();
            }
            catch (EcwException ecwException) {
                // empty catch block
            }
            return;
        }
        int lineasLeidas = 0;
        lineasLeidas = this.countBlock <= this.nBlocks ? this.blockSizeRead : this.lineasBloqueFinal;
        try {
            if (this.nNextLine % this.blockSizeRead == 0) {
                if (this.dataWriter != null) {
                    if (this.dataType == -1) {
                        this.dataBuffer = this.dataWriter.readARGBData(this.width, lineasLeidas, 0);
                    }
                    if (this.dataType == 0) {
                        this.byteBuffer = this.dataWriter.readByteData(this.width, lineasLeidas);
                    }
                }
                this.countLine = 0;
                ++this.countBlock;
            }
            if (this.dataType == -1) {
                this.loadBufferFromImageDataType(this.dataBuffer);
            }
            if (this.dataType == 0) {
                this.loadBufferFromByteDataType(this.byteBuffer);
            }
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    private void loadBufferFromImageDataType(int[] data) {
        for (int iBand = 0; iBand < this.nBands; ++iBand) {
            for (int pos = 0; pos < this.width; ++pos) {
                switch (iBand) {
                    case 0: {
                        this.compressclient.buffer[pos + this.width * iBand] = (byte)((data[pos + this.width * this.countLine] & 0xFF0000) >> 16);
                        break;
                    }
                    case 1: {
                        this.compressclient.buffer[pos + this.width * iBand] = (byte)((data[pos + this.width * this.countLine] & 0xFF00) >> 8);
                        break;
                    }
                    case 2: {
                        this.compressclient.buffer[pos + this.width * iBand] = (byte)(data[pos + this.width * this.countLine] & 0xFF);
                    }
                }
                if (pos != this.width - 1 || iBand != this.nBands - 1) continue;
                ++this.countLine;
            }
        }
    }

    private void loadBufferFromByteDataType(byte[][] b) {
        for (int iBand = 0; iBand < this.nBands; ++iBand) {
            for (int pos = 0; pos < this.width; ++pos) {
                this.compressclient.buffer[pos + this.width * iBand] = b[iBand][pos + this.width * this.countLine];
                if (pos != this.width - 1 || iBand != this.nBands - 1) continue;
                ++this.countLine;
            }
        }
    }

    public void updatePercent() {
        this.writer.setPercent(this.compressclient.getPercent());
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }
}

