/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.preference.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.util.BasePanel;

public class PreferenceCache
extends BasePanel {
    protected static final long serialVersionUID = 1L;
    private JLabel labelWarning = null;
    private JLabel labelBlockHeight = null;
    private JComboBox comboBoxBlockHeight = null;
    private JLabel labelCacheSize = null;
    private JFormattedTextField textFieldCacheSize = null;
    private JLabel labelPagsPerGroup = null;
    private JFormattedTextField textFieldPagsPerGroup = null;
    private JLabel labelPageSize = null;
    private JFormattedTextField textFieldPageSize = null;

    public PreferenceCache() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText((Object)this, "cache")));
        this.getLabelWarning().setText(this.getText((Object)this, "preference_cache_warning"));
        this.getLabelCacheSize().setText(this.getText((Object)this, "tamanyo") + ":");
        this.getLabelPagsPerGroup().setText(this.getText((Object)this, "paginas_grupo") + ":");
        this.getLabelPageSize().setText(this.getText((Object)this, "tamanyo_pagina") + ":");
        this.getLabelBlockHeight().setText(this.getText((Object)this, "bloques_procesos") + ":");
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add(this.getLabelWarning(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelCacheSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelPagsPerGroup(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelPageSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        this.add(this.getLabelBlockHeight(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldCacheSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add(this.getComboBoxBlockHeight(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldPageSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldPagsPerGroup(), gridBagConstraints);
    }

    private JLabel getLabelWarning() {
        if (this.labelWarning == null) {
            this.labelWarning = new JLabel();
            this.labelWarning.setForeground(new Color(255, 0, 0));
            this.labelWarning.setHorizontalAlignment(0);
            this.labelWarning.setPreferredSize(new Dimension(0, 32));
        }
        return this.labelWarning;
    }

    private JFormattedTextField getTextFieldCacheSize() {
        if (this.textFieldCacheSize == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldCacheSize = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldCacheSize;
    }

    private JFormattedTextField getTextFieldPagsPerGroup() {
        if (this.textFieldPagsPerGroup == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldPagsPerGroup = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldPagsPerGroup;
    }

    private JFormattedTextField getTextFieldPageSize() {
        if (this.textFieldPageSize == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldPageSize = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldPageSize;
    }

    private JLabel getLabelCacheSize() {
        if (this.labelCacheSize == null) {
            this.labelCacheSize = new JLabel();
        }
        return this.labelCacheSize;
    }

    private JLabel getLabelPagsPerGroup() {
        if (this.labelPagsPerGroup == null) {
            this.labelPagsPerGroup = new JLabel();
        }
        return this.labelPagsPerGroup;
    }

    private JLabel getLabelPageSize() {
        if (this.labelPageSize == null) {
            this.labelPageSize = new JLabel();
        }
        return this.labelPageSize;
    }

    private JLabel getLabelBlockHeight() {
        if (this.labelBlockHeight == null) {
            this.labelBlockHeight = new JLabel();
        }
        return this.labelBlockHeight;
    }

    private JComboBox getComboBoxBlockHeight() {
        if (this.comboBoxBlockHeight == null) {
            this.comboBoxBlockHeight = new JComboBox();
            this.comboBoxBlockHeight.setModel(new DefaultComboBoxModel<String>(new String[]{"128", "256", "512", "1024", "2048", "4096"}));
        }
        return this.comboBoxBlockHeight;
    }

    public void initializeDefaults() {
        this.getTextFieldCacheSize().setValue(Configuration.getDefaultValue((String)"cache_size"));
        this.getTextFieldPageSize().setValue(Configuration.getDefaultValue((String)"cache_pagesize"));
        this.getTextFieldPagsPerGroup().setValue(Configuration.getDefaultValue((String)"cache_pagspergroup"));
        Integer blockHeight = (Integer)Configuration.getDefaultValue((String)"cache_blockheight");
        for (int i = 0; i < this.getComboBoxBlockHeight().getItemCount(); ++i) {
            if (!this.getComboBoxBlockHeight().getItemAt(i).toString().equals(blockHeight.toString())) continue;
            this.getComboBoxBlockHeight().setSelectedIndex(i);
            break;
        }
    }

    public void initializeValues() {
        this.getTextFieldCacheSize().setValue(Configuration.getValue((String)"cache_size", (Long)RasterLibrary.cacheSize));
        this.getTextFieldPageSize().setValue(Configuration.getValue((String)"cache_pagesize", (Double)RasterLibrary.pageSize));
        this.getTextFieldPagsPerGroup().setValue(Configuration.getValue((String)"cache_pagspergroup", (Integer)RasterLibrary.pagsPerGroup));
        Integer blockHeight = Configuration.getValue((String)"cache_blockheight", (Integer)RasterLibrary.blockHeight);
        for (int i = 0; i < this.getComboBoxBlockHeight().getItemCount(); ++i) {
            if (!this.getComboBoxBlockHeight().getItemAt(i).toString().equals(blockHeight.toString())) continue;
            this.getComboBoxBlockHeight().setSelectedIndex(i);
            break;
        }
    }

    public void storeValues() {
        Configuration.setValue((String)"cache_size", (Object)this.getTextFieldCacheSize().getText());
        Configuration.setValue((String)"cache_pagesize", (Object)this.getTextFieldPageSize().getText());
        Configuration.setValue((String)"cache_pagspergroup", (Object)this.getTextFieldPagsPerGroup().getText());
        Configuration.setValue((String)"cache_blockheight", (Object)this.getComboBoxBlockHeight().getSelectedItem().toString());
    }
}

