/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui.listener;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.tool.SaveRasterListenerImpl;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.clip.ClippingData;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.ClippingPanel;

public class ClippingMouseViewListener
extends SaveRasterListenerImpl {
    private final Image isaveraster = IconThemeHelper.getImageIcon((String)"rectangle-select-cursor").getImage();
    private FLyrRaster layer = null;
    private ClippingPanel clippingPanel = null;
    private ClippingData data = null;
    private MapControl mapControl = null;
    private String currentTool = null;

    public ClippingMouseViewListener(MapControl mapControl, ClippingPanel clippingPanel, ClippingData data, FLyrRaster lyr) {
        super(mapControl);
        this.clippingPanel = clippingPanel;
        this.data = data;
        this.layer = lyr;
        this.mapControl = mapControl;
        this.currentTool = mapControl.getCurrentTool();
    }

    public void setRasterLayer(FLyrRaster flyr) {
        this.layer = flyr;
    }

    public void rectangle(EnvelopeEvent event) {
        super.rectangle(event);
        if (this.layer.getAffineTransform() == null) {
            return;
        }
        AffineTransform at = this.layer.getAffineTransform();
        Point2D.Double ulWc = new Point2D.Double(this.rect.getMinimum(0), this.rect.getMaximum(1));
        Point2D.Double lrWc = new Point2D.Double(this.rect.getMaximum(0), this.rect.getMinimum(1));
        Point2D.Double urWc = new Point2D.Double(this.rect.getMaximum(0), this.rect.getMaximum(1));
        Point2D.Double llWc = new Point2D.Double(this.rect.getMinimum(0), this.rect.getMinimum(1));
        Point2D.Double ulPx = new Point2D.Double();
        Point2D.Double lrPx = new Point2D.Double();
        Point2D.Double urPx = new Point2D.Double();
        Point2D.Double llPx = new Point2D.Double();
        try {
            at.inverseTransform(ulWc, ulPx);
            at.inverseTransform(lrWc, lrPx);
            at.inverseTransform(urWc, urPx);
            at.inverseTransform(llWc, llPx);
        }
        catch (NoninvertibleTransformException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"coordenadas_erroneas"), null);
            return;
        }
        Point2D[] pointList = new Point2D[]{ulPx, lrPx, urPx, llPx};
        Point2D.Double dim = new Point2D.Double(this.layer.getDataStore().getWidth(), this.layer.getDataStore().getHeight());
        if (this.isOutside(ulPx, lrPx)) {
            this.data.setOutOfArea();
            return;
        }
        RasterLocator.getManager().getRasterUtils().adjustToPixelSize(pointList, (Point2D)dim);
        at.transform(ulPx, ulWc);
        at.transform(lrPx, lrWc);
        at.transform(llPx, llWc);
        at.transform(urPx, urWc);
        this.data.setCoorPixel(ulPx, lrPx, llPx, urPx);
        this.data.setCoorReal(ulWc, lrWc, llWc, urWc);
        this.data.setAffineTransform(at);
        this.data.initSize();
        if (this.layer.isRemote()) {
            RasterSwingLibrary.messageBoxInfo((String)Messages.getText((String)"remember_select_size"), (Object)this.clippingPanel);
        }
        this.clippingPanel.saveStatus(this.data);
        if (this.clippingPanel.getListener().activeButtons(ulPx, lrPx, ulWc, lrWc)) {
            this.clippingPanel.getButtonsPanel().getButton(3).setEnabled(true);
            this.clippingPanel.getButtonsPanel().getButton(1).setEnabled(true);
        } else {
            this.clippingPanel.getButtonsPanel().getButton(3).setEnabled(false);
            this.clippingPanel.getButtonsPanel().getButton(1).setEnabled(false);
        }
        if (this.currentTool != null) {
            this.mapControl.setTool(this.currentTool);
        }
    }

    private boolean isOutside(Point2D ulPx, Point2D lrPx) {
        double minX = Math.min(ulPx.getX(), lrPx.getX());
        double minY = Math.min(ulPx.getY(), lrPx.getY());
        double maxX = Math.max(ulPx.getX(), lrPx.getX());
        double maxY = Math.max(ulPx.getY(), lrPx.getY());
        return minX >= this.layer.getDataStore().getWidth() || minY >= this.layer.getDataStore().getHeight() || maxX < 0.0 || maxY < 0.0;
    }

    public Image getImageCursor() {
        return this.isaveraster;
    }
}

