/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.library;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.gui.ColorTablePainter;
import org.gvsig.gui.beans.listview.IIconPaint;

public class ColorTableIconPainter
implements IIconPaint,
ColorTablePainter {
    private ColorTable colorTable;

    public ColorTableIconPainter(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public void setInterpolated(boolean value) {
        this.colorTable.setInterpolated(value);
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    public Color[] getColors() {
        List cItem = this.colorTable.getColorItems();
        Color[] colorList = new Color[cItem.size()];
        for (int i = 0; i < colorList.length; ++i) {
            colorList[i] = ((ColorItem)cItem.get(i)).getColor();
        }
        return colorList;
    }

    public void paint(Graphics2D g, boolean isSelected) {
        Rectangle area = g.getClipBounds();
        int x1 = area.x;
        int x2 = area.x + area.width - 1;
        Color bgColor = new Color(224, 224, 224);
        int i = 0;
        while (i * 4 <= area.width) {
            int j = 0;
            while (j * 4 <= area.height) {
                if ((i + j) % 2 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(bgColor);
                }
                g.fillRect(area.x + 1 + i * 4, area.y + 1 + j * 4, 4, 4);
                ++j;
            }
            ++i;
        }
        if (this.colorTable.getColorItems().size() >= 1) {
            double min = ((ColorItem)this.colorTable.getColorItems().get(0)).getValue();
            double max = ((ColorItem)this.colorTable.getColorItems().get(this.colorTable.getColorItems().size() - 1)).getValue();
            for (int i2 = area.x; i2 < area.x + area.width; ++i2) {
                double pos = min + (max - min) * (double)(i2 - area.x) / (double)(area.width - 2);
                byte[] col3 = this.colorTable.getRGBAByBand(pos);
                g.setColor(new Color(col3[0] & 0xFF, col3[1] & 0xFF, col3[2] & 0xFF, col3[3] & 0xFF));
                g.drawLine(i2, area.y, i2, area.y + area.height);
            }
        } else {
            g.setColor(new Color(224, 224, 224));
            g.fillRect(x1, area.y, x2 - x1, area.height - 1);
        }
        if (isSelected) {
            g.setColor(Color.black);
        } else {
            g.setColor(new Color(96, 96, 96));
        }
        g.drawRect(x1, area.y, x2 - x1, area.height - 1);
    }

    public String getTableName() {
        return this.colorTable.getName();
    }
}

