/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.gui.beans.colorbutton.ColorButton;
import org.gvsig.gui.beans.colorbutton.ColorButtonEvent;
import org.gvsig.gui.beans.colorbutton.ColorButtonListener;
import org.gvsig.gui.beans.colorslideredition.ColorSliderEdition;
import org.gvsig.gui.beans.colorslideredition.ColorSliderEvent;
import org.gvsig.gui.beans.colorslideredition.ColorSliderListener;
import org.gvsig.gui.beans.colorslideredition.ItemColorSlider;
import org.gvsig.raster.swing.preview.PreviewBasePanelTab;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.ColorTableUIListener;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.IColorTableUI;
import org.gvsig.raster.util.BasePanel;

public class TabInterpolated
extends BasePanel
implements IColorTableUI,
ColorSliderListener,
ColorButtonListener,
FocusListener,
KeyListener,
PreviewBasePanelTab {
    private static final long serialVersionUID = -5208861410196059899L;
    private ArrayList<ColorTableUIListener> actionCommandListeners = new ArrayList();
    private boolean listenerEnabled = true;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private ColorTable colorTable = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary().createColorTable();
    private ColorSliderEdition colorSliderEdition = null;
    private ColorButton colorButton = null;
    private JTextField jTextClassName = null;
    private JTextField jTextValue = null;
    private JLabel jLabelColor = null;
    private JLabel jLabelClassName = null;
    private JLabel jLabelValue = null;

    public TabInterpolated() {
        this.init();
        this.translate();
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add((Component)this.getColorSliderEdition(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getJLabelColor(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.getColorButton(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getJLabelClassName(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getJTextClassName(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getJLabelValue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getJTextValue(), gridBagConstraints);
    }

    protected void translate() {
    }

    private JLabel getJLabelColor() {
        if (this.jLabelColor == null) {
            this.jLabelColor = new JLabel(this.getText(this, "tabinterpolated_color") + ": ");
            this.jLabelColor.setEnabled(false);
        }
        return this.jLabelColor;
    }

    private JLabel getJLabelClassName() {
        if (this.jLabelClassName == null) {
            this.jLabelClassName = new JLabel(this.getText(this, "clase") + ": ");
            this.jLabelClassName.setEnabled(false);
        }
        return this.jLabelClassName;
    }

    private JLabel getJLabelValue() {
        if (this.jLabelValue == null) {
            this.jLabelValue = new JLabel(this.getText(this, "value") + ": ");
            this.jLabelValue.setEnabled(false);
        }
        return this.jLabelValue;
    }

    private ColorSliderEdition getColorSliderEdition() {
        if (this.colorSliderEdition == null) {
            this.colorSliderEdition = new ColorSliderEdition();
            this.colorSliderEdition.addValueChangedListener((ColorSliderListener)this);
            this.colorSliderEdition.addSelectionChangedListener((ColorSliderListener)this);
        }
        return this.colorSliderEdition;
    }

    private ColorButton getColorButton() {
        if (this.colorButton == null) {
            this.colorButton = new ColorButton();
            this.colorButton.addValueChangedListener((ColorButtonListener)this);
        }
        return this.colorButton;
    }

    private JTextField getJTextClassName() {
        if (this.jTextClassName == null) {
            this.jTextClassName = new JTextField();
            this.jTextClassName.setEnabled(false);
            this.jTextClassName.addKeyListener(this);
        }
        return this.jTextClassName;
    }

    private JTextField getJTextValue() {
        if (this.jTextValue == null) {
            this.jTextValue = new JTextField();
            this.jTextValue.setEnabled(false);
            this.jTextValue.addKeyListener(this);
            this.jTextValue.addFocusListener(this);
        }
        return this.jTextValue;
    }

    public void actionSelectionChanged(ColorSliderEvent e) {
        ItemColorSlider itemColorSlider = this.getColorSliderEdition().getSelectedItem();
        boolean enabled = false;
        if (itemColorSlider != null && itemColorSlider.getSelected() == 1) {
            this.getColorButton().setColor(itemColorSlider.getColor());
            this.getJTextClassName().setText(itemColorSlider.getName());
            enabled = true;
        }
        this.setControlsEnabled(enabled);
    }

    private void updateItemSelectedToColorSlider() {
        ItemColorSlider itemColorSlider = this.getColorSliderEdition().getSelectedItem();
        if (itemColorSlider != null) {
            itemColorSlider.setColor(this.getColorButton().getColor());
            itemColorSlider.setName(this.getJTextClassName().getText());
            this.getColorSliderEdition().repaint();
        }
    }

    public void actionValueDragged(ColorButtonEvent e) {
        this.updateItemSelectedToColorSlider();
    }

    private ArrayList<ColorItem> getPalette() {
        ColorTableLibrary colorTableLibrary = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
        double min2 = this.min;
        double max2 = this.max;
        if (min2 > max2) {
            double aux = min2;
            min2 = max2;
            max2 = aux;
        }
        ArrayList<ColorItem> arrayList = new ArrayList<ColorItem>();
        ArrayList items = this.getColorSliderEdition().getItemsShowed();
        ItemColorSlider item = items.size() > 0 ? (ItemColorSlider)items.get(0) : new ItemColorSlider(0.0, Color.black);
        ColorItem colorItem = colorTableLibrary.createColorItem();
        colorItem.setColor(item.getColor());
        colorItem.setInterpolated(50.0);
        colorItem.setNameClass("");
        colorItem.setValue(min2);
        arrayList.add(colorItem);
        for (int i = 0; i < items.size(); ++i) {
            item = (ItemColorSlider)items.get(i);
            colorItem = colorTableLibrary.createColorItem();
            colorItem.setColor(item.getColor());
            colorItem.setInterpolated((double)((int)item.getInterpolated()));
            colorItem.setNameClass(item.getName());
            colorItem.setValue(min2 + item.getValue() * (max2 - min2) / 100.0);
            arrayList.add(colorItem);
        }
        item = items.size() > 0 ? (ItemColorSlider)items.get(items.size() - 1) : new ItemColorSlider(255.0, Color.white);
        colorItem = colorTableLibrary.createColorItem();
        colorItem.setColor(item.getColor());
        colorItem.setInterpolated(50.0);
        colorItem.setNameClass("");
        colorItem.setValue(max2);
        arrayList.add(colorItem);
        return arrayList;
    }

    private void refreshItems() {
        this.colorTable.createPaletteFromColorItems(this.getPalette(), false);
    }

    public void actionValueChanged(ColorButtonEvent e) {
        this.updateItemSelectedToColorSlider();
        this.refreshItems();
        this.callColorTableUIChangedListener();
    }

    public void actionValueChanged(ColorSliderEvent e) {
        this.refreshItems();
        this.changeTextValue();
        this.callColorTableUIChangedListener();
    }

    private void initialState() {
        this.getColorSliderEdition().repaint();
        this.setControlsEnabled(false);
    }

    private void setControlsEnabled(boolean value) {
        this.getColorButton().setEnabled(value);
        this.getJLabelColor().setEnabled(value);
        this.getJLabelClassName().setEnabled(value);
        this.getJTextClassName().setEnabled(value);
        this.getJLabelValue().setEnabled(value);
        this.getJTextValue().setEnabled(value);
        if (!value) {
            this.getJTextClassName().setText("");
        }
    }

    private void reloadItems() {
        ColorItem c1;
        int i;
        List colorItems = this.colorTable.getColorItems();
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < colorItems.size(); ++i) {
            c1 = (ColorItem)colorItems.get(i);
            if (c1.getValue() > this.max) {
                this.max = c1.getValue();
            }
            if (!(c1.getValue() < this.min)) continue;
            this.min = c1.getValue();
        }
        this.clearTable();
        for (i = 0; i < colorItems.size(); ++i) {
            c1 = (ColorItem)colorItems.get(i);
            double percent = (c1.getValue() - this.min) * 100.0 / (this.max - this.min);
            ItemColorSlider aux = new ItemColorSlider(percent, c1.getColor());
            aux.setInterpolated(c1.getInterpolated());
            aux.setName(c1.getNameClass());
            this.getColorSliderEdition().addItem(aux, false);
        }
        this.initialState();
        if (this.min > this.max) {
            this.min = 0.0;
            this.max = 255.0;
        }
        this.refreshItems();
    }

    private void clearTable() {
        this.getColorSliderEdition().removeAllItems();
    }

    private void updateChangedValue() {
        double min2 = Double.POSITIVE_INFINITY;
        double max2 = Double.NEGATIVE_INFINITY;
        ArrayList list = this.getColorSliderEdition().getItems();
        for (int i = 0; i < list.size(); ++i) {
            ItemColorSlider itemColorSlider = (ItemColorSlider)list.get(i);
            double value = this.SliderToValue(itemColorSlider.getValue());
            itemColorSlider.setTag((Object)new Double(value));
            if (itemColorSlider.getSelected() == 1) continue;
            if (min2 > value) {
                min2 = value;
            }
            if (!(max2 < value)) continue;
            max2 = value;
        }
        try {
            double value = Double.parseDouble(this.getJTextValue().getText());
            if (min2 > value) {
                min2 = value;
            }
            if (max2 < value) {
                max2 = value;
            }
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        this.min = min2;
        this.max = max2;
        for (int i = 0; i < list.size(); ++i) {
            ItemColorSlider itemColorSlider = (ItemColorSlider)list.get(i);
            double value = this.ValueToSlider((Double)itemColorSlider.getTag());
            itemColorSlider.setValue(value);
            if (itemColorSlider.getSelected() != 1) continue;
            try {
                value = Double.parseDouble(this.getJTextValue().getText());
                itemColorSlider.setValue(this.ValueToSlider(value));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.getJTextValue()) {
            this.updateChangedValue();
        }
        this.updateItemSelectedToColorSlider();
        this.refreshItems();
        this.callColorTableUIChangedListener();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.getJTextValue()) {
            this.updateChangedValue();
            this.updateItemSelectedToColorSlider();
            this.refreshItems();
            this.callColorTableUIChangedListener();
        }
        if (e.getSource() == this.getJTextClassName()) {
            this.updateItemSelectedToColorSlider();
            this.refreshItems();
            this.callColorTableUIChangedListener();
        }
    }

    private void changeTextValue() {
        if (this.getColorSliderEdition().getSelectedItem() != null) {
            double value = this.SliderToValue(this.getColorSliderEdition().getSelectedItem().getValue());
            MathUtils math = RasterLocator.getManager().getMathUtils();
            this.getJTextValue().setText(math.format(value, 3) + "");
        }
    }

    public void actionValueDragged(ColorSliderEvent e) {
        this.changeTextValue();
    }

    private double[] getLimits() {
        double min2 = this.min;
        double max2 = this.max;
        if (min2 > max2) {
            double aux = min2;
            min2 = max2;
            max2 = aux;
        }
        if (min2 == max2) {
            max2 += 1.0;
        }
        double[] limits = new double[]{min2, max2};
        return limits;
    }

    private double ValueToSlider(double value) {
        double[] limits = this.getLimits();
        return (value - limits[0]) * 100.0 / (limits[1] - limits[0]);
    }

    private double SliderToValue(double value) {
        double[] limits = this.getLimits();
        return limits[0] + value * (limits[1] - limits[0]) / 100.0;
    }

    @Override
    public ColorTable getColorTable() {
        return this.colorTable;
    }

    @Override
    public void setColorTable(ColorTable colorTable) {
        this.listenerEnabled = false;
        this.colorTable = colorTable;
        this.reloadItems();
        this.getColorSliderEdition().setInterpolated(colorTable.isInterpolated());
        this.listenerEnabled = true;
    }

    @Override
    public void addColorTableUIChangedListener(ColorTableUIListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    @Override
    public void removeColorTableUIChangedListener(ColorTableUIListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callColorTableUIChangedListener() {
        if (!this.listenerEnabled) {
            return;
        }
        for (ColorTableUIListener listener : this.actionCommandListeners) {
            listener.actionColorTableUIChanged(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            try {
                double value = Double.parseDouble(this.getJTextValue().getText());
                this.getJTextValue().setText(Double.valueOf(value += 10.0).toString());
                this.updateChangedValue();
                this.updateItemSelectedToColorSlider();
                this.refreshItems();
                this.callColorTableUIChangedListener();
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        if (e.getKeyCode() == 40) {
            try {
                double value = Double.parseDouble(this.getJTextValue().getText());
                this.getJTextValue().setText(Double.valueOf(value -= 10.0).toString());
                this.updateChangedValue();
                this.updateItemSelectedToColorSlider();
                this.refreshItems();
                this.callColorTableUIChangedListener();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getTitle() {
        return RasterToolsUtil.getText(this, "rampa");
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }
}

