/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.gcanvas.BaseFunction;
import org.gvsig.raster.swing.gcanvas.DensitySlicingLine;
import org.gvsig.raster.swing.gcanvas.DrawableElement;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.GraphicHistogram;
import org.gvsig.raster.swing.gcanvas.InfoLayer;
import org.gvsig.raster.swing.gcanvas.MinMaxLines;

public abstract class HistogramGraphicBase
extends JPanel {
    private static final long serialVersionUID = 68166939596605313L;
    protected Color minMaxLineColor = Color.WHITE;
    protected Color borderColor = Color.WHITE;
    protected Color functionColor = Color.YELLOW;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int GRAY = 3;
    public static final int DRAWED = 4;
    protected GCanvas canvas = null;
    protected HistogramStatus histogramRed = null;
    protected HistogramStatus histogramGreen = null;
    protected HistogramStatus histogramBlue = null;
    protected HistogramStatus histogramGray = null;
    protected HistogramStatus histogramDrawed = null;
    private FLyrRaster lyr = null;

    public HistogramGraphicBase(BufferHistogram hist, FLyrRaster lyr, double[] minList, double[] maxList) {
        this.lyr = lyr;
        this.setHistogram(hist, minList, maxList);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCanvas(), "Center");
    }

    public void setHistogram(BufferHistogram hist, double[] minList, double[] maxList) {
        long[][] table = hist.getTable();
        if (this.lyr.getRender().isRenderingAsGray()) {
            this.setHistogramBand(3, minList, maxList, table);
            this.setHistogramBand(0, minList, maxList, table);
            this.setHistogramBand(1, minList, maxList, table);
            this.setHistogramBand(2, minList, maxList, table);
        } else {
            this.setHistogramBand(0, minList, maxList, table);
            this.setHistogramDrawed(0);
            this.setHistogramBand(1, minList, maxList, table);
            this.setHistogramBand(2, minList, maxList, table);
        }
    }

    private void setHistogramBand(int color, double[] minList, double[] maxList, long[][] table) {
        int position = 0;
        switch (color) {
            case 1: {
                position = 1;
                break;
            }
            case 2: {
                position = 2;
            }
        }
        ColorInterpretation ci = this.lyr.getRender().getRenderColorInterpretation();
        int[] renderBands = ci.buildRenderBands();
        if (position >= renderBands.length) {
            return;
        }
        int band = renderBands[position];
        if (band < 0 || band >= table.length) {
            return;
        }
        double[] histogram = new double[table[band].length];
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = table[band][i];
        }
        this.setHistogram(histogram, color);
        HistogramStatus histogramStatus = this.getHistogramStatus(color);
        if (histogramStatus == null) {
            return;
        }
        if (band >= minList.length || band >= maxList.length) {
            return;
        }
        histogramStatus.setLimits(minList[band], maxList[band]);
    }

    public void setHistogram(double[] hist, int colorInterp) {
        switch (colorInterp) {
            case 1: {
                if (this.histogramGreen == null) {
                    this.histogramGreen = new HistogramStatus(Color.green);
                }
                this.histogramGreen.setHistogram(hist);
                break;
            }
            case 2: {
                if (this.histogramBlue == null) {
                    this.histogramBlue = new HistogramStatus(Color.blue);
                }
                this.histogramBlue.setHistogram(hist);
                break;
            }
            case 3: {
                if (this.histogramGray == null) {
                    this.histogramGray = new HistogramStatus(Color.gray);
                }
                this.histogramGray.setHistogram(hist);
                break;
            }
            default: {
                if (this.histogramRed == null) {
                    this.histogramRed = new HistogramStatus(Color.red);
                }
                this.histogramRed.setHistogram(hist);
            }
        }
        if (this.histogramDrawed == null) {
            this.setHistogramDrawed(colorInterp);
        }
    }

    public HistogramStatus getHistogramStatus(int colorInterp) {
        switch (colorInterp) {
            case 0: {
                return this.histogramRed;
            }
            case 1: {
                return this.histogramGreen;
            }
            case 2: {
                return this.histogramBlue;
            }
            case 3: {
                return this.histogramGray;
            }
            case 4: {
                return this.histogramDrawed;
            }
        }
        return null;
    }

    public void setHistogramDrawed(int colorInterp) {
        switch (colorInterp) {
            case 0: {
                this.histogramDrawed = this.histogramRed;
                break;
            }
            case 1: {
                this.histogramDrawed = this.histogramGreen;
                break;
            }
            case 2: {
                this.histogramDrawed = this.histogramBlue;
                break;
            }
            case 3: {
                this.histogramDrawed = this.histogramGray;
            }
        }
        if (this.histogramDrawed != null) {
            this.getCanvas().replaceDrawableElement((DrawableElement)this.histogramDrawed.getGraphicHistogram());
            this.getCanvas().replaceDrawableElement((DrawableElement)this.histogramDrawed.getMinMaxLines());
            this.getCanvas().replaceDrawableElement((DrawableElement)this.histogramDrawed.getBaseFunction(), BaseFunction.class);
            this.getCanvas().replaceDrawableElement((DrawableElement)this.histogramDrawed.getInfoLayer());
            ((Component)this.getCanvas()).repaint();
        }
    }

    public void setHistogramType(int type) {
        if (this.histogramDrawed != null) {
            this.histogramDrawed.getGraphicHistogram().setTypeViewed(type);
        }
    }

    public void setType(int type) {
        List elements = this.getCanvas().getDrawableElements(GraphicHistogram.class);
        for (int i = 0; i < elements.size(); ++i) {
            ((GraphicHistogram)elements.get(i)).setType(type);
        }
    }

    public abstract GCanvas getCanvas();

    public class HistogramStatus {
        private double[] histogram = new double[]{0.0, 0.0, 3.0, 4.0, 5.0, 8.0, 7.0, 18.0, 45.0, 36.0, 21.0, 36.0, 12.0, 23.0, 23.0, 40.0, 17.0, 10.0, 5.0, 1.0, 0.0, 0.0, 0.0};
        private double min = 0.0;
        private double max = 1.0;
        private BaseFunction baseFunction = null;
        private GraphicHistogram graphicHistogram = null;
        private MinMaxLines minMaxLines = null;
        private InfoLayer infoLayer = null;

        public HistogramStatus(Color color) {
            GCanvas canvas = RasterSwingLocator.getSwingManager().createGraphicCanvas(Color.black);
            this.graphicHistogram = canvas.createHistogramForGCanvas(null, color);
            this.graphicHistogram.setType(1);
            this.baseFunction = canvas.createStraightLineForGCanvas(HistogramGraphicBase.this.functionColor);
            this.minMaxLines = canvas.createMinMaxLinesForGCanvas(HistogramGraphicBase.this.minMaxLineColor);
            this.infoLayer = canvas.createInfoLayerForGCanvas(Color.WHITE);
        }

        public void setLimits(double min, double max) {
            this.min = min;
            this.max = max;
            this.infoLayer.setLimits(min, max);
        }

        public double[] getHistogram() {
            return this.histogram;
        }

        public void setHistogram(double[] histogram) {
            this.graphicHistogram.setHistogramDrawed(histogram);
            this.histogram = histogram;
        }

        public GraphicHistogram getGraphicHistogram() {
            return this.graphicHistogram;
        }

        public MinMaxLines getMinMaxLines() {
            return this.minMaxLines;
        }

        public BaseFunction getBaseFunction() {
            return this.baseFunction;
        }

        public void setBaseFunction(BaseFunction baseFunction) {
            this.baseFunction = baseFunction;
        }

        public void setLevel(int level) {
            if (this.baseFunction instanceof DensitySlicingLine) {
                ((DensitySlicingLine)this.baseFunction).setShape(level);
            }
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public InfoLayer getInfoLayer() {
            return this.infoLayer;
        }
    }
}

