/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.graphics;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.gcanvas.BaseFunction;
import org.gvsig.raster.swing.gcanvas.DensitySlicingLine;
import org.gvsig.raster.swing.gcanvas.DrawableElement;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.IGCanvasListener;
import org.gvsig.raster.swing.gcanvas.LogaritmicExponentialLine;
import org.gvsig.raster.swing.gcanvas.SquareRootPowLine;
import org.gvsig.raster.swing.gcanvas.StraightLine;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.HistogramGraphicBase;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedListener;

public class InputHistogram
extends HistogramGraphicBase {
    private static final long serialVersionUID = 681848373747974757L;

    public InputHistogram(BufferHistogram hist, FLyrRaster lyr, double[] minList, double[] maxList) {
        super(hist, lyr, minList, maxList);
    }

    @Override
    public GCanvas getCanvas() {
        if (this.canvas == null) {
            this.canvas = RasterSwingLocator.getSwingManager().createGraphicCanvas(Color.BLACK);
            this.canvas.addDrawableElement((DrawableElement)this.canvas.createHistogramForGCanvas(null, Color.white));
            this.canvas.addDrawableElement((DrawableElement)this.canvas.createMinMaxLinesForGCanvas(this.minMaxLineColor));
            this.canvas.addDrawableElement((DrawableElement)this.canvas.createStraightLineForGCanvas(this.functionColor));
            this.canvas.addDrawableElement(this.canvas.createBorderLayerForGCanvas(this.borderColor));
            this.canvas.addDrawableElement((DrawableElement)this.canvas.createInfoLayerForGCanvas(Color.WHITE));
        }
        return this.canvas;
    }

    public void setListener(EnhancedListener listener) {
        this.getCanvas().addValueChangedListener((IGCanvasListener)listener);
    }

    public void setLevel(int level) {
        if (this.histogramDrawed != null) {
            this.histogramDrawed.setLevel(level);
        }
        ((Component)this.getCanvas()).repaint();
    }

    public void setFunction(int function) {
        if (this.histogramDrawed == null) {
            return;
        }
        BaseFunction baseFunction = this.histogramDrawed.getBaseFunction();
        List listBaseFunc = this.canvas.getDrawableElements(BaseFunction.class);
        if (listBaseFunc != null && listBaseFunc.get(0) instanceof DrawableElement) {
            ((DrawableElement)listBaseFunc.get(0)).setDrawing(true);
        }
        boolean regen = false;
        switch (function) {
            case 6: {
                if (baseFunction.getClass().equals(DensitySlicingLine.class)) break;
                baseFunction = this.canvas.createDensitySliceForGCanvas(((DrawableElement)this.histogramDrawed.getBaseFunction()).getColor(), -1);
                break;
            }
            case 0: {
                if (baseFunction.getClass().equals(StraightLine.class)) break;
                baseFunction = this.canvas.createStraightLineForGCanvas(((DrawableElement)this.histogramDrawed.getBaseFunction()).getColor());
                break;
            }
            case 3: {
                regen = false;
                if (!baseFunction.getClass().equals(LogaritmicExponentialLine.class)) {
                    regen = true;
                } else if (!((LogaritmicExponentialLine)baseFunction).isLogaritmical()) {
                    regen = true;
                }
                if (!regen) break;
                baseFunction = this.canvas.createLogaritmicExponentialLineForGCanvas(((DrawableElement)this.histogramDrawed.getBaseFunction()).getColor(), 1.0);
                break;
            }
            case 2: {
                regen = false;
                if (!baseFunction.getClass().equals(LogaritmicExponentialLine.class)) {
                    regen = true;
                } else if (!((LogaritmicExponentialLine)baseFunction).isExponencial()) {
                    regen = true;
                }
                if (!regen) break;
                baseFunction = this.canvas.createLogaritmicExponentialLineForGCanvas(((DrawableElement)this.histogramDrawed.getBaseFunction()).getColor(), -1.0);
                break;
            }
            case 4: {
                if (baseFunction.getClass().equals(SquareRootPowLine.class)) break;
                baseFunction = this.canvas.createSquareRootPowLineForGCanvas(((DrawableElement)this.histogramDrawed.getBaseFunction()).getColor(), 1.0);
                break;
            }
            case -1: {
                ((DrawableElement)listBaseFunc.get(0)).setDrawing(false);
            }
        }
        this.histogramDrawed.setBaseFunction(baseFunction);
        this.getCanvas().replaceDrawableElement((DrawableElement)this.histogramDrawed.getBaseFunction(), BaseFunction.class);
        this.getCanvas().paint(((JPanel)this.getCanvas()).getGraphics());
    }
}

