/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter;

import javax.swing.Icon;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.filter.ui.FilterDialog;

public class FilterTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static FilterTocMenuEntry singleton = null;

    private FilterTocMenuEntry() {
    }

    public static FilterTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new FilterTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "Enhanced";
    }

    public int getGroupOrder() {
        return 55;
    }

    public int getOrder() {
        return 0;
    }

    public String getText() {
        return RasterToolsUtil.getText((Object)this, "filtros");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        RasterFilterList filterList;
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        if (!((ILayerState)selectedItems[0]).isOpen()) {
            return false;
        }
        FLyrRaster lyr = (FLyrRaster)selectedItems[0];
        if (lyr.getDataStore().getDataType()[0] != 0 && (filterList = lyr.getRender().getFilterList()) != null) {
            return filterList.get("enhanced_stretch") != null;
        }
        return true;
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(5);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1 || !(selectedItems[0] instanceof FLyrRaster)) {
            return;
        }
        FilterDialog rasterFilterDialog = new FilterDialog((FLyrRaster)selectedItems[0], 740, 400);
        PluginServices.getMDIManager().addCentredWindow((IWindow)rasterFilterDialog);
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("layer-filter-raster");
    }
}

