/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.filter.ui.FilterPanel;

public class FilterDialog
extends JPanel
implements IWindow,
IWindowListener,
ButtonsPanelListener {
    private static final long serialVersionUID = 818691082984915388L;
    private FLyrRaster layer = null;
    private FilterPanel filterPanel = null;

    public FilterDialog(FLyrRaster layer, int width, int height) {
        this.layer = layer;
        this.setSize(width, height);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.getFilterPanel(), "Center");
    }

    private FilterPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new FilterPanel(this.layer, this);
        }
        return this.filterPanel;
    }

    private void close() {
        try {
            RasterLocator.getManager().getFileUtils().removeOnlyLayerNameListener((PropertyListener)this.getFilterPanel().getNewLayerPanel().getPanelNewLayer());
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(19);
        if (this.layer != null) {
            m_viewinfo.setAdditionalInfo(this.layer.getName());
        }
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"filtros"));
        m_viewinfo.setHeight(this.getHeight());
        m_viewinfo.setWidth(this.getWidth());
        return m_viewinfo;
    }

    public void windowClosed() {
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 3) {
            this.getFilterPanel().getLayerVisualStatus().restoreVisualStatus(this.layer);
            this.getFilterPanel().apply();
        }
        if (e.getButton() == 2) {
            this.getFilterPanel().getLayerVisualStatus().restoreVisualStatus(this.layer);
            this.getFilterPanel().cancel();
        }
        if (e.getButton() == 1) {
            this.getFilterPanel().getPreviewBasePanel().closePreviewLayer();
            this.close();
        }
    }

    public void windowActivated() {
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

