/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.BorderLayout;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationOpeningRasterPanel;

public class GeoLocationOpeningRasterDialog
extends JPanel
implements IWindow,
IWindowListener,
ITransformIO {
    private static final long serialVersionUID = 7362459094802955247L;
    private GeoLocationOpeningRasterPanel geolocationPanel = null;
    private int widthWindow = 260;
    private int heightWindow = 165;

    public GeoLocationOpeningRasterDialog() {
        BorderLayout bl = new BorderLayout(5, 5);
        this.setLayout(bl);
        this.add(this.getGeoLocationPanel());
    }

    public GeoLocationOpeningRasterDialog(FLyrRaster lyr) {
        BorderLayout bl = new BorderLayout(5, 5);
        this.setLayout(bl);
        this.add(this.getGeoLocationPanel());
        this.getGeoLocationPanel().setParams(lyr);
    }

    public void init(MapControl mapCtrl) {
        this.geolocationPanel.setMapCtrl(mapCtrl);
        FLyrRaster lyr = this.getGeoLocationPanel().getLayer();
        if (lyr != null) {
            lyr.getAffineTransformHistorical().clear();
            lyr.getAffineTransformHistorical().add((Object)lyr.getDataStore().getAffineTransform());
            this.loadTransform(lyr.getDataStore().getAffineTransform());
        }
        this.activeButtons();
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.geolocationPanel.loadTransform(at);
    }

    @Override
    public void applyTransformation() {
        this.geolocationPanel.setModify(true);
        this.geolocationPanel.activeButtons();
    }

    public GeoLocationOpeningRasterPanel getGeoLocationPanel() {
        if (this.geolocationPanel == null) {
            this.geolocationPanel = new GeoLocationOpeningRasterPanel(this);
        }
        return this.geolocationPanel;
    }

    public void activeButtons() {
        this.getGeoLocationPanel().activeButtons();
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setHeight(this.heightWindow);
        m_viewinfo.setWidth(this.widthWindow);
        return m_viewinfo;
    }

    public void windowActivated() {
    }

    public void windowClosed() {
        if (this.geolocationPanel.getModify()) {
            if (RasterSwingLibrary.messageBoxYesOrNot((String)Messages.getText((String)"aviso_salir_salvando"), (Object)this.geolocationPanel)) {
                try {
                    this.geolocationPanel.getLayer().saveGeoToRmf();
                }
                catch (RmfSerializerException e1) {
                    RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_salvando_rmf"), (Object)this.geolocationPanel, (Exception)((Object)e1));
                }
            }
            this.geolocationPanel.setModify(false);
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

