/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.geolocation.listener.GeoLocationPanelListener;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeolocationBaseClassPanel;

public class GeoLocationOpeningRasterTransfPanel
extends GeolocationBaseClassPanel {
    private static final long serialVersionUID = -7797379892312214949L;
    private DataInputContainer ulx = null;
    private DataInputContainer uly = null;
    private DataInputContainer psx = null;
    private DataInputContainer psy = null;
    private DataInputContainer rotx = null;
    private DataInputContainer roty = null;
    private JPanel coordsPanel = null;
    private JPanel paramsPanel = null;
    private int tailValue = 2;

    public GeoLocationOpeningRasterTransfPanel(GeoLocationPanelListener list) {
        this.listener = list;
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"geolocation"), 0, 0, null, null));
        this.ulx = new DataInputContainer();
        this.ulx.setLabelText(PluginServices.getText((Object)this, (String)"ux"));
        this.ulx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.ulx.addKeyListener((KeyListener)this.listener);
        this.uly = new DataInputContainer();
        this.uly.setLabelText(PluginServices.getText((Object)this, (String)"uy"));
        this.uly.addValueChangedListener((DataInputContainerListener)this.listener);
        this.uly.addKeyListener((KeyListener)this.listener);
        this.psx = new DataInputContainer();
        this.psx.setLabelText(PluginServices.getText((Object)this, (String)"px"));
        this.psx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.psx.addKeyListener((KeyListener)this.listener);
        this.psy = new DataInputContainer();
        this.psy.setLabelText(PluginServices.getText((Object)this, (String)"py"));
        this.psy.addValueChangedListener((DataInputContainerListener)this.listener);
        this.psy.addKeyListener((KeyListener)this.listener);
        this.rotx = new DataInputContainer();
        this.rotx.setLabelText(PluginServices.getText((Object)this, (String)"rx"));
        this.rotx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.rotx.addKeyListener((KeyListener)this.listener);
        this.roty = new DataInputContainer();
        this.roty.setLabelText(PluginServices.getText((Object)this, (String)"ry"));
        this.roty.addValueChangedListener((DataInputContainerListener)this.listener);
        this.roty.addKeyListener((KeyListener)this.listener);
        this.coordsPanel = new JPanel();
        GridLayout l = new GridLayout(2, 1);
        l.setVgap(2);
        this.coordsPanel.setLayout(l);
        this.paramsPanel = new JPanel();
        GridLayout l1 = new GridLayout(2, 2);
        l1.setVgap(2);
        this.paramsPanel.setLayout(l1);
        this.init();
    }

    private void init() {
        this.coordsPanel.add((Component)this.ulx);
        this.coordsPanel.add((Component)this.uly);
        this.paramsPanel.add((Component)this.psx);
        this.paramsPanel.add((Component)this.psy);
        this.paramsPanel.add((Component)this.rotx);
        this.paramsPanel.add((Component)this.roty);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.coordsPanel, gbc);
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.paramsPanel, gbc);
    }

    @Override
    public void activeButtons() {
    }

    public void setParams(FLyrRaster lyr, ViewPort vp) {
        this.setLayer(lyr);
        this.setViewPort(vp);
        this.loadTransform(lyr.getAffineTransform());
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.listener.setEnableValueChangeEvent(false);
        MathUtils math = RasterLocator.getManager().getMathUtils();
        this.setUlx(String.valueOf(math.format(at.getTranslateX(), this.tailValue)));
        this.setUly(String.valueOf(math.format(at.getTranslateY(), this.tailValue)));
        this.setPsx(String.valueOf(math.format(at.getScaleX(), this.tailValue)));
        this.setPsy(String.valueOf(math.format(at.getScaleY(), this.tailValue)));
        this.setRotx(String.valueOf(math.format(at.getShearX(), this.tailValue)));
        this.setRoty(String.valueOf(math.format(at.getShearY(), this.tailValue)));
        this.listener.setEnableValueChangeEvent(true);
    }

    public void setPsx(String psx) {
        this.psx.setValue(psx);
    }

    public void setPsy(String psy) {
        this.psy.setValue(psy);
    }

    public void setRotx(String rotx) {
        this.rotx.setValue(rotx);
    }

    public void setRoty(String roty) {
        this.roty.setValue(roty);
    }

    public void setUlx(String ulx) {
        this.ulx.setValue(ulx);
    }

    public void setUly(String uly) {
        this.uly.setValue(uly);
    }

    @Override
    public DataInputContainer getPsx() {
        return this.psx;
    }

    @Override
    public DataInputContainer getPsy() {
        return this.psy;
    }

    @Override
    public DataInputContainer getRotx() {
        return this.rotx;
    }

    @Override
    public DataInputContainer getRoty() {
        return this.roty;
    }

    @Override
    public DataInputContainer getUlx() {
        return this.ulx;
    }

    @Override
    public DataInputContainer getUly() {
        return this.uly;
    }
}

