/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.slidertext.SliderTextContainer;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;

public class EnhancedBrightnessContrastPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -475762560608930500L;
    private InternalPanel internalPanel = new InternalPanel();
    private JCheckBox active = null;

    public EnhancedBrightnessContrastPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"brillo_y_contraste"), 0, 0, null, null));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getActive(), "North");
        this.add((Component)this.internalPanel, "Center");
        this.getActive().addActionListener(this);
        this.setPreferredSize(new Dimension(100, 80));
    }

    public JCheckBox getActive() {
        if (this.active == null) {
            this.active = new JCheckBox(PluginServices.getText((Object)this, (String)"activar"));
            this.active.setSelected(false);
            this.setControlEnabled(false);
        }
        return this.active;
    }

    public void setControlEnabled(boolean enabled) {
        this.getActive().setSelected(enabled);
        this.internalPanel.setControlEnabled(enabled);
    }

    public double getBrightnessValue() {
        return this.internalPanel.brightness.getValue();
    }

    public double getContrastValue() {
        return this.internalPanel.contrast.getValue();
    }

    public void setBrightnessValue(double value) {
        this.internalPanel.brightness.setValue(value);
    }

    public void setContrastValue(double value) {
        this.internalPanel.contrast.setValue(value);
    }

    public void addBrightnessValueChangedListener(SliderListener l) {
        this.internalPanel.brightness.addValueChangedListener(l);
    }

    public void addContrastValueChangedListener(SliderListener l) {
        this.internalPanel.contrast.addValueChangedListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getActive()) {
            if (this.getActive().isSelected()) {
                this.setControlEnabled(true);
            } else {
                this.setControlEnabled(false);
            }
        }
    }

    class InternalPanel
    extends JPanel {
        private static final long serialVersionUID = 0L;
        protected SliderTextContainer brightness = new SliderTextContainer(-255, 255, 0, false);
        protected SliderTextContainer contrast = new SliderTextContainer(-255, 255, 0, false);

        public InternalPanel() {
            this.brightness.setBorder(PluginServices.getText((Object)this, (String)"brillo"));
            this.contrast.setBorder(PluginServices.getText((Object)this, (String)"contraste"));
            this.init();
        }

        private void init() {
            this.setLayout(new GridLayout(2, 1));
            this.add((Component)this.brightness);
            this.add((Component)this.contrast);
        }

        public void setControlEnabled(boolean enabled) {
            this.brightness.setControlEnabled(enabled);
            this.contrast.setControlEnabled(enabled);
        }
    }
}

