/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.gvsig.gui.beans.checkslidertext.CheckColorSliderTextContainer;
import org.gvsig.gui.beans.doubleslider.DoubleSliderEvent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderListener;

public class TranspByPixelRGBInputPanel
extends JPanel
implements DoubleSliderListener {
    private static final long serialVersionUID = 5858119425941331458L;
    private int[] rangeRed = null;
    private int[] rangeGreen = null;
    private int[] rangeBlue = null;
    CheckColorSliderTextContainer tRed = null;
    CheckColorSliderTextContainer tGreen = null;
    CheckColorSliderTextContainer tBlue = null;
    CheckColorSliderTextContainer tAlpha = null;

    public TranspByPixelRGBInputPanel() {
        this.initialize();
        this.updateColors();
        this.validateValues();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getTRed());
        this.add((Component)this.getTGreen());
        this.add((Component)this.getTBlue());
        this.add((Component)this.getTAlpha());
        this.getTBlue().addValueChangedListener((DoubleSliderListener)this);
        this.getTGreen().addValueChangedListener((DoubleSliderListener)this);
        this.getTRed().addValueChangedListener((DoubleSliderListener)this);
        this.getTAlpha().addValueChangedListener((DoubleSliderListener)this);
    }

    public CheckColorSliderTextContainer getTRed() {
        if (this.tRed == null) {
            this.tRed = new CheckColorSliderTextContainer(0, 255, 0, "R", true);
        }
        return this.tRed;
    }

    public CheckColorSliderTextContainer getTAlpha() {
        if (this.tAlpha == null) {
            this.tAlpha = new CheckColorSliderTextContainer(0, 255, 255, "A", false);
            this.tAlpha.setColor2(this.getBackground(), true);
        }
        return this.tAlpha;
    }

    public CheckColorSliderTextContainer getTGreen() {
        if (this.tGreen == null) {
            this.tGreen = new CheckColorSliderTextContainer(0, 255, 0, "G", true);
        }
        return this.tGreen;
    }

    public CheckColorSliderTextContainer getTBlue() {
        if (this.tBlue == null) {
            this.tBlue = new CheckColorSliderTextContainer(0, 255, 0, "B", true);
        }
        return this.tBlue;
    }

    public int[] getRangeBlue() {
        return this.rangeBlue;
    }

    public int[] getRangeGreen() {
        return this.rangeGreen;
    }

    public int[] getRangeRed() {
        return this.rangeRed;
    }

    public void setControlEnabled(boolean enabled) {
        this.getTRed().setEnabled(enabled);
        this.getTGreen().setEnabled(enabled);
        this.getTBlue().setEnabled(enabled);
        this.getTAlpha().setEnabled(enabled);
    }

    public void setActiveBands(int n) {
        this.getTRed().setEnabled(true);
        switch (n) {
            case 1: {
                this.getTGreen().setEnabled(false);
                this.getTBlue().setEnabled(false);
                break;
            }
            case 2: {
                this.getTGreen().setEnabled(true);
                this.getTBlue().setEnabled(false);
                break;
            }
            case 3: {
                this.getTGreen().setEnabled(true);
                this.getTBlue().setEnabled(true);
            }
        }
    }

    public void clear() {
        this.getTRed().setValue(0);
        this.getTGreen().setValue(0);
        this.getTBlue().setValue(0);
        this.getTRed().setControlEnabled(true);
        this.getTGreen().setControlEnabled(true);
        this.getTBlue().setControlEnabled(true);
    }

    public void updateColors() {
        int r = this.tRed.getValue();
        int g = this.tGreen.getValue();
        int b = this.tBlue.getValue();
        if (!this.tRed.isChecked()) {
            r = 0;
        }
        if (!this.tGreen.isChecked()) {
            g = 0;
        }
        if (!this.tBlue.isChecked()) {
            b = 0;
        }
        this.tRed.setColor1(new Color(0, g, b), false);
        this.tRed.setColor2(new Color(255, g, b), true);
        this.tGreen.setColor1(new Color(r, 0, b), false);
        this.tGreen.setColor2(new Color(r, 255, b), true);
        this.tBlue.setColor1(new Color(r, g, 0), false);
        this.tBlue.setColor2(new Color(r, g, 255), true);
    }

    public void validateValues() {
        this.rangeRed = new int[]{0, 255};
        this.rangeGreen = new int[]{0, 255};
        this.rangeBlue = new int[]{0, 255};
        if (this.getTRed().isChecked()) {
            this.rangeRed[0] = this.rangeRed[1] = this.getTRed().getValue();
        }
        if (this.getTGreen().isChecked()) {
            this.rangeGreen[0] = this.rangeGreen[1] = this.getTGreen().getValue();
        }
        if (this.getTBlue().isChecked()) {
            this.rangeBlue[0] = this.rangeBlue[1] = this.getTBlue().getValue();
        }
    }

    public void actionValueChanged(DoubleSliderEvent e) {
        this.updateColors();
        this.validateValues();
    }

    public void actionValueDragged(DoubleSliderEvent e) {
        this.updateColors();
        this.validateValues();
    }
}

