/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.checkslidertext.CheckSliderTextContainer;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.slidertext.listeners.SliderEvent;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;
import org.gvsig.gui.util.StatusComponent;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.tools.app.basic.RasterExtension;
import org.gvsig.raster.tools.app.basic.tool.properties.control.TransparencyListener;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelRGBInputPanel;

public class TransparencyPanel
extends AbstractPanel
implements ActionListener,
SliderListener {
    private static final long serialVersionUID = -4556920949255458471L;
    private FLyrRaster lyr = null;
    public int nBands = 3;
    private JCheckBox cbTransparencia = null;
    private TranspByPixelPanel pTranspByPixel = null;
    private CheckSliderTextContainer pOpacity = null;
    private TransparencyListener transparencyListener = null;

    public TransparencyPanel() {
        this.setLabel(PluginServices.getText((Object)this, (String)"transparencia"));
        this.initialize();
    }

    private TransparencyListener getTransparencyListener() {
        if (this.transparencyListener == null) {
            this.transparencyListener = new TransparencyListener(this);
        }
        return this.transparencyListener;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getOpacityPanel(), "North");
        this.add(this.getPTranspByPixel(), "Center");
        this.initControls();
        this.setPreferredSize(new Dimension(100, 80));
        this.setPriority(70);
    }

    public void setBands(int nBands) {
        this.nBands = nBands;
    }

    public void initControls() {
        this.setActiveTransparencyControl(false);
    }

    public JCheckBox getTransparencyCheck() {
        if (this.cbTransparencia == null) {
            this.cbTransparencia = new JCheckBox();
            this.cbTransparencia.setText("Activar");
            this.cbTransparencia.addActionListener(this);
        }
        return this.cbTransparencia;
    }

    public CheckSliderTextContainer getOpacityPanel() {
        if (this.pOpacity == null) {
            this.pOpacity = new CheckSliderTextContainer(0, 100, 100, false, PluginServices.getText((Object)this, (String)"activar"), false, false, true);
            this.pOpacity.setDecimal(false);
            this.pOpacity.setBorder(PluginServices.getText((Object)this, (String)"opacidad"));
            this.pOpacity.addValueChangedListener((SliderListener)this);
        }
        return this.pOpacity;
    }

    public void setActiveTransparencyControl(boolean active) {
        this.getTransparencyCheck().setSelected(active);
        TranspByPixelRGBInputPanel rgbPanel = this.getPTranspByPixel().getPRGBInput();
        rgbPanel.getTRed().setEnabled(active);
        if (this.lyr != null) {
            if (this.lyr.getDataStore().getBandCount() == 2) {
                rgbPanel.getTGreen().setEnabled(active);
                rgbPanel.getTBlue().setEnabled(false);
            }
            if (this.lyr.getDataStore().getBandCount() == 3) {
                rgbPanel.getTGreen().setEnabled(active);
                rgbPanel.getTBlue().setEnabled(active);
            }
        }
    }

    public TranspByPixelPanel getPTranspByPixel() {
        if (this.pTranspByPixel == null) {
            this.pTranspByPixel = new TranspByPixelPanel();
            this.pTranspByPixel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"transp_by_pixel"), 0, 0, null, null));
        }
        return this.pTranspByPixel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getTransparencyCheck())) {
            if (this.getTransparencyCheck().isSelected()) {
                this.getPTranspByPixel().setControlEnabled(true);
                this.getPTranspByPixel().getPRGBInput().setActiveBands(this.nBands);
            } else {
                this.getPTranspByPixel().setControlEnabled(false);
            }
        }
    }

    public FLayer getLayer() {
        if (this.lyr instanceof FLayer) {
            return this.lyr;
        }
        return null;
    }

    public void setReference(Object ref) {
        super.setReference(ref);
        if (!(ref instanceof FLyrRaster)) {
            return;
        }
        this.lyr = (FLyrRaster)ref;
        this.getTransparencyListener().setLayer(this.lyr);
        this.actionEnabled();
    }

    private void actionEnabled() {
        if (this.lyr == null) {
            this.setVisible(false);
            return;
        }
        IRasterLayerActions fLyrRasterSE = (IRasterLayerActions)this.lyr;
        if (!fLyrRasterSE.isActionEnabled(11)) {
            StatusComponent.setDisabled((JComponent)this.getOpacityPanel());
        }
        if (!fLyrRasterSE.isActionEnabled(10)) {
            StatusComponent.setDisabled((JComponent)this.getPTranspByPixel());
        }
        if (!fLyrRasterSE.isActionEnabled(10) && !fLyrRasterSE.isActionEnabled(11)) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public void accept() {
        this.getTransparencyListener().accept();
    }

    public void apply() {
        this.getTransparencyListener().apply();
    }

    public void cancel() {
        this.getTransparencyListener().cancel();
    }

    public void actionValueChanged(SliderEvent e) {
        if (!RasterExtension.autoRefreshView) {
            return;
        }
        this.getTransparencyListener().onlyApply();
    }

    public void actionValueDragged(SliderEvent e) {
    }

    public void selected() {
    }
}

