/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.operation;

import java.io.File;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.gui.beans.incrementabletask.IncrementableTask;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.process.ClippingProcess;
import org.gvsig.raster.tools.app.basic.tool.saveas.SaveAsActions;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.ExternalCancellable;

public class CopyDataset {
    private String fDstName = null;
    private String fSrcName = null;
    private FLyrRaster src = null;
    private DataProcess clippingProcess = null;
    private IncrementableTask incrementableTask = null;
    private RasterManager rManager = RasterLocator.getManager();

    public CopyDataset(String src, String dst) throws LoadLayerException {
        this.fSrcName = src;
        this.fDstName = dst;
        File f = new File(this.fDstName);
        if (f.exists()) {
            f.delete();
        }
        this.src = DefaultFLyrRaster.createLayer((String)"lyr", (File)new File(this.fSrcName));
    }

    public CopyDataset(String src, String dst, IncrementableTask incrementableTask) throws LoadLayerException {
        this.fSrcName = src;
        this.fDstName = dst;
        this.incrementableTask = incrementableTask;
        File f = new File(this.fDstName);
        if (f.exists()) {
            f.delete();
        }
        this.src = DefaultFLyrRaster.createLayer((String)"lyr", (File)new File(this.fSrcName));
    }

    public void copy() throws ProcessInterruptedException, ProcessException {
        String suffix;
        int[] dValues = new int[]{0, (int)this.src.getDataStore().getHeight(), (int)this.src.getDataStore().getWidth(), 0};
        int[] drawableBands = new int[this.src.getDataStore().getBandCount()];
        for (int i = 0; i < this.src.getDataStore().getBandCount(); ++i) {
            drawableBands[i] = i;
        }
        Params params = null;
        try {
            params = this.rManager.createWriter(this.fDstName).getParams();
        }
        catch (NotSupportedExtensionException e1) {
            RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)this, (Exception)((Object)e1));
        }
        catch (RasterDriverException e1) {
            RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)this, (Exception)((Object)e1));
        }
        this.clippingProcess = new ClippingProcess();
        this.clippingProcess.setActions((IProcessActions)new SaveAsActions());
        if (this.incrementableTask != null) {
            this.clippingProcess.addParam("cancellable", (Object)new ExternalCancellable(this.incrementableTask));
        }
        this.clippingProcess.addParam("showenddialog", (Object)new Boolean(false));
        this.clippingProcess.addParam("pixelcoordinates", (Object)dValues);
        int index = this.fDstName.lastIndexOf(".");
        if (index > 0 && (suffix = this.fDstName.substring(index, this.fDstName.length())).length() == 4) {
            this.clippingProcess.addParam("suffix", (Object)suffix);
        }
        this.clippingProcess.addParam("filename", (Object)this.fDstName);
        this.clippingProcess.addParam("layer", (Object)this.src.getDataStore());
        this.clippingProcess.addParam("drawablebands", (Object)drawableBands);
        this.clippingProcess.addParam("colorInterpretation", (Object)this.src.getDataStore().getColorInterpretation());
        this.clippingProcess.addParam("onelayerperband", (Object)new Boolean(false));
        this.clippingProcess.addParam("interpolationmethod", (Object)new Integer(1));
        this.clippingProcess.addParam("affinetransform", (Object)this.src.getDataStore().getAffineTransform());
        this.clippingProcess.addParam("resolution", (Object)new int[]{(int)this.src.getDataStore().getWidth(), (int)this.src.getDataStore().getHeight()});
        this.clippingProcess.addParam("driverparams", (Object)params);
        this.clippingProcess.execute();
    }

    public int getPercent() {
        if (this.clippingProcess != null) {
            return this.clippingProcess.getPercent();
        }
        return 0;
    }
}

