/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.ui.listener;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.algorithm.swing.saveraster.SaveRasterPanel;
import org.gvsig.raster.util.ExtendedFileFilter;

public class DataInputListener
implements ActionListener,
MouseListener,
FocusListener,
KeyListener,
DataInputContainerListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3370601314380922368L;
    private SaveRasterPanel controlPanel = null;
    private String fName = null;
    private boolean enableEventValueChanged = true;
    private MathUtils math = RasterLocator.getManager().getMathUtils();

    public DataInputListener(SaveRasterPanel controlPanel) {
        this.controlPanel = controlPanel;
        this.initialize();
    }

    public void setLayers(FLayers layers) {
    }

    void initialize() {
        this.controlPanel.addPropertiesChangeListener((PropertyChangeListener)this);
        this.controlPanel.addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getCbResolution().addKeyListener(this);
        this.controlPanel.addActionListener((ActionListener)this);
    }

    private boolean checkInteger(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() > 8) {
            RasterSwingLibrary.messageBoxError((String)"output_too_big", (Object)this.controlPanel);
            return false;
        }
        int v = 0;
        try {
            v = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return v > 0;
    }

    private boolean checkDouble(String value) {
        if (value == null) {
            return false;
        }
        double v = 0.0;
        try {
            v = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return !(v <= 0.0);
    }

    private void recalcParams(Object obj, Object oldValue) {
        this.controlPanel.validateFields();
        double widthMts = 0.0;
        double heightMts = 0.0;
        try {
            double[] size = this.calcSizeInMts();
            if (size == null) {
                return;
            }
            widthMts = size[0];
            heightMts = size[1];
        }
        catch (NumberFormatException e) {
            return;
        }
        if (this.controlPanel.isPixelMethodSelected()) {
            this.modifyPixelMethod(obj, widthMts, heightMts, oldValue);
        } else {
            this.modifyPrintMethod(obj, widthMts, heightMts, oldValue);
        }
        this.calculateFileSize();
    }

    private void modifyPixelMethod(Object obj, double widthMts, double heightMts, Object oldValue) {
        double rel = widthMts / heightMts;
        if (this.controlPanel.getComponentID(obj) == 0 && !this.controlPanel.getWidthPxValue().equals("")) {
            if (!this.checkInteger(this.controlPanel.getWidthPxValue())) {
                this.controlPanel.setWidthPxValue(String.valueOf(oldValue));
                return;
            }
            int w = Integer.parseInt(this.controlPanel.getWidthPxValue());
            int h = (int)Math.floor((double)w / rel);
            this.controlPanel.setHeightPxValue(String.valueOf(h));
            this.controlPanel.setCellSize(String.valueOf(widthMts / (double)w));
        } else if (this.controlPanel.getComponentID(obj) == 1 && !this.controlPanel.getHeightPxValue().equals("")) {
            if (!this.checkInteger(this.controlPanel.getHeightPxValue())) {
                this.controlPanel.setHeightPxValue(String.valueOf(oldValue));
                return;
            }
            int h = Integer.parseInt(this.controlPanel.getHeightPxValue());
            int w = (int)Math.ceil((double)h * rel);
            this.controlPanel.setWidthPxValue(String.valueOf(w));
            this.controlPanel.setCellSize(String.valueOf(widthMts / (double)w));
        } else if (this.controlPanel.getComponentID(obj) == 2 && !this.controlPanel.getScaleValue().equals("")) {
            if (!this.checkDouble(this.controlPanel.getCellSize())) {
                this.controlPanel.setCellSize(String.valueOf(oldValue));
                return;
            }
            double cellsize = Double.parseDouble(this.controlPanel.getCellSize());
            int w = (int)Math.round(widthMts / cellsize);
            int h = (int)Math.round(heightMts / cellsize);
            if (widthMts / cellsize >= 2.147483647E9 || heightMts / cellsize >= 2.147483647E9) {
                RasterSwingLibrary.messageBoxError((String)"output_too_big", (Object)this.controlPanel);
                this.controlPanel.setCellSize(String.valueOf(oldValue));
                return;
            }
            this.controlPanel.setWidthPxValue(String.valueOf(w));
            this.controlPanel.setHeightPxValue(String.valueOf(h));
            this.controlPanel.setCellSize(String.valueOf(widthMts / (double)w));
        } else if (this.controlPanel.getComponentID(obj) == 9 || this.controlPanel.getComponentID(obj) == 10 || this.controlPanel.getComponentID(obj) == 11 || this.controlPanel.getComponentID(obj) == 12) {
            int w = Integer.parseInt(this.controlPanel.getWidthPxValue());
            if (w == 0) {
                return;
            }
            this.controlPanel.setCellSize(String.valueOf(widthMts / (double)w));
        }
    }

    private void modifyPrintMethod(Object obj, double widthMts, double heightMts, Object oldValue) {
        double rel = widthMts / heightMts;
        if (this.controlPanel.getComponentID(obj) == 3 && !this.controlPanel.getValueXCms().equals("")) {
            if (!this.checkInteger(this.controlPanel.getValueXCms())) {
                this.controlPanel.setValueXCms(String.valueOf(oldValue));
                return;
            }
            int cmsx = Integer.parseInt(this.controlPanel.getValueXCms());
            int cmsy = (int)Math.round((double)cmsx / rel);
            int scale = (int)Math.round(widthMts / ((double)cmsx / 100.0));
            this.controlPanel.setValueYCms(String.valueOf(cmsy));
            this.controlPanel.setScaleValue(String.valueOf(scale));
        } else if (this.controlPanel.getComponentID(obj) == 4 && !this.controlPanel.getValueYCms().equals("")) {
            if (!this.checkInteger(this.controlPanel.getValueYCms())) {
                this.controlPanel.setValueYCms(String.valueOf(oldValue));
                return;
            }
            int cmsy = Integer.parseInt(this.controlPanel.getValueYCms());
            int cmsx = (int)Math.round((double)cmsy * rel);
            int scale = (int)Math.round(widthMts / ((double)cmsx / 100.0));
            this.controlPanel.setValueXCms(String.valueOf(cmsx));
            this.controlPanel.setScaleValue(String.valueOf(scale));
        } else if (this.controlPanel.getComponentID(obj) == 5 && !this.controlPanel.getScaleValue().equals("")) {
            if (!this.checkInteger(this.controlPanel.getScaleValue())) {
                this.controlPanel.setScaleValue(String.valueOf(oldValue));
                return;
            }
            int scale = Integer.parseInt(this.controlPanel.getScaleValue());
            int cmsx = (int)Math.round(widthMts / (double)scale * 100.0);
            int cmsy = (int)Math.round(heightMts / (double)scale * 100.0);
            this.controlPanel.setValueXCms(String.valueOf(cmsx));
            this.controlPanel.setValueYCms(String.valueOf(cmsy));
            scale = (int)Math.round(widthMts / ((double)cmsx / 100.0));
            this.controlPanel.setScaleValue(String.valueOf(scale));
        } else if (this.controlPanel.getComponentID(obj) == 9 || this.controlPanel.getComponentID(obj) == 10 || this.controlPanel.getComponentID(obj) == 11 || this.controlPanel.getComponentID(obj) == 12) {
            int cmsx = Integer.parseInt(this.controlPanel.getValueXCms());
            if (cmsx == 0) {
                return;
            }
            int scale = (int)Math.round(widthMts / ((double)cmsx / 100.0));
            this.controlPanel.setScaleValue(String.valueOf(scale));
        }
        this.calculateSizePxResult();
    }

    private void calculateSizePxResult() {
        int resolution = Integer.parseInt((String)this.controlPanel.getCbResolution().getSelectedItem());
        int cmsx = Integer.parseInt(this.controlPanel.getValueXCms());
        int cmsy = Integer.parseInt(this.controlPanel.getValueYCms());
        int wpx = (int)Math.round((double)cmsx * 0.3973007874 * (double)resolution);
        int hpx = (int)Math.round((double)cmsy * 0.3973007874 * (double)resolution);
        this.controlPanel.setSizePxPrintResult(wpx, hpx);
    }

    private void calculateFileSize() {
        int w = 0;
        int h = 0;
        if (this.controlPanel.isPixelMethodSelected()) {
            w = Integer.parseInt(this.controlPanel.getWidthPxValue());
            h = Integer.parseInt(this.controlPanel.getHeightPxValue());
        } else {
            w = this.controlPanel.getWidthPxPrint();
            h = this.controlPanel.getHeightPxPrint();
        }
        this.controlPanel.setSizeMB(this.math.clipDecimals((double)((long)w * (long)h * 3L) / 1048576.0, 1));
    }

    private double[] calcSizeInMts() throws NumberFormatException {
        double lrx = Double.parseDouble(this.controlPanel.getValueLRX());
        double lry = Double.parseDouble(this.controlPanel.getValueLRY());
        double ulx = Double.parseDouble(this.controlPanel.getValueULX());
        double uly = Double.parseDouble(this.controlPanel.getValueULY());
        double distWidth = 0.0;
        double distHeight = 0.0;
        distWidth = ulx > lrx ? ulx - lrx : lrx - ulx;
        distHeight = uly > lry ? uly - lry : lry - uly;
        return new double[]{distWidth, distHeight};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.controlPanel.getBSelect())) {
            int returnVal;
            ExtendedFileFilter fileFilter;
            JFileChooser chooser = new JFileChooser("DATA_INPUT_LISTENER", JFileChooser.getLastPath((String)"DATA_INPUT_LISTENER", null));
            chooser.setDialogTitle(PluginServices.getText((Object)this, (String)"seleccionar_fichero"));
            chooser.setAcceptAllFileFilterUsed(false);
            String[] extList = RasterLocator.getManager().getProviderServices().getDriversExtensions();
            ExtendedFileFilter selectedFilter = null;
            for (int i = 0; i < extList.length; ++i) {
                fileFilter = new ExtendedFileFilter(extList[i]);
                chooser.addChoosableFileFilter((FileFilter)fileFilter);
                if (!extList[i].toLowerCase().equals("tif")) continue;
                selectedFilter = fileFilter;
            }
            if (selectedFilter != null) {
                chooser.setFileFilter(selectedFilter);
            }
            if ((returnVal = chooser.showOpenDialog((Component)this.controlPanel.getComponent())) == 0) {
                fileFilter = (ExtendedFileFilter)chooser.getFileFilter();
                this.fName = chooser.getSelectedFile().toString();
                this.fName = fileFilter.getNormalizedFilename(chooser.getSelectedFile());
                String ext = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(this.fName);
                this.controlPanel.getBProperties().setEnabled(true);
                this.controlPanel.getLFileName().setText(this.fName.substring(this.fName.lastIndexOf(File.separator) + 1, this.fName.length()));
                JFileChooser.setLastPath((String)"DATA_INPUT_LISTENER", (File)chooser.getSelectedFile());
            }
        }
        if (this.controlPanel.getComponentID(obj) == 6) {
            if (!this.enableEventValueChanged) {
                return;
            }
            this.enableEventValueChanged = false;
            this.recalcParams(e.getSource(), null);
            this.enableEventValueChanged = true;
        }
        if (this.controlPanel.getComponentID(obj) == 13 || this.controlPanel.getComponentID(obj) == 14) {
            this.calculateFileSize();
        }
    }

    public String getFileName() {
        return this.fName;
    }

    public void resetFileName() {
        this.fName = null;
        this.controlPanel.getLFileName().setText("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void actionValueChanged(EventObject e) {
        if (!this.enableEventValueChanged) {
            return;
        }
        this.enableEventValueChanged = false;
        this.recalcParams(e.getSource(), "0");
        this.enableEventValueChanged = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.enableEventValueChanged) {
            return;
        }
        this.enableEventValueChanged = false;
        this.recalcParams(e.getSource(), e.getOldValue());
        this.enableEventValueChanged = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

