/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterSelection
extends Parameter {
    private static final String OPTIONS = "options";
    private static final String PATH = "path";

    @Override
    public String getParameterTypeName() {
        return "Selection";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (Integer)this.m_ParameterValue;
        }
        throw new NullParameterValueException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return ((Integer)this.m_ParameterValue).doubleValue();
        }
        throw new NullParameterValueException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException, NullParameterAdditionalInfoException {
        if (this.m_ParameterValue != null) {
            if (this.m_ParameterAdditionalInfo != null) {
                String[] sValues = ((AdditionalInfoSelection)this.m_ParameterAdditionalInfo).getValues();
                return sValues[(Integer)this.m_ParameterValue];
            }
            throw new NullParameterAdditionalInfoException();
        }
        throw new NullParameterValueException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoSelection) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof Integer) {
            String[] sValues = ((AdditionalInfoSelection)this.m_ParameterAdditionalInfo).getValues();
            if ((Integer)value < sValues.length) {
                this.m_ParameterValue = value;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return Integer.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        String s;
        AdditionalInfoSelection ais = (AdditionalInfoSelection)this.m_ParameterAdditionalInfo;
        if (ais != null) {
            serializer.text("\n");
            serializer.text("\t\t\t");
            serializer.startTag(null, "attribute");
            String[] sFields = ais.getValues();
            s = sFields[0];
            for (int i = 1; i < sFields.length; ++i) {
                s = s + ";" + sFields[i];
            }
        } else {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.attribute(null, "name", OPTIONS);
        serializer.attribute(null, "value", s);
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", PATH);
        serializer.attribute(null, "value", ais.getSelectionPath());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        String sValues = null;
        String sPath = null;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(OPTIONS) == 0) {
                        sValues = parser.getAttributeValue("", "value");
                    }
                    if (sName.compareTo(PATH) != 0) break;
                    sPath = parser.getAttributeValue("", "value");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterSelection param = new ParameterSelection();
        AdditionalInfoSelection ai = new AdditionalInfoSelection(sValues.split("\\;"));
        if (sPath != null) {
            ai.setSelectionPath(sPath);
        }
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        Integer i = (Integer)this.m_ParameterValue;
        return "\"" + i.toString() + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        return this.m_ParameterValue != null;
    }
}

