/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.picturemarkersymboltable.lib.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.AbstractLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMarkerSymbol
extends AbstractMarkerSymbol
implements IMarkerSymbol,
IMultiLayerSymbol,
TransparencySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageMarkerSymbol.class);
    private ImageMarkerSymbol selectionSym;
    private boolean selected;
    private BufferedImage image;
    private BufferedImage imagesel;
    private ISymbol[] layers = new ISymbol[]{new LineSymbol(this), new ImageSymbol(this)};

    void setImage(BufferedImage img) {
        this.image = img;
    }

    void setImageSel(BufferedImage img) {
        this.imagesel = img;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        for (int i = 0; !(cancel != null && cancel.isCanceled() || this.layers == null || i >= this.layers.length); ++i) {
            ISymbol layer = this.layers[i];
            if (layer == null) continue;
            if (layer instanceof CartographicSupport) {
                ((CartographicSupport)layer).setCartographicContext(this.getCartographicContext());
            }
            if (layer instanceof ISymbol_v2) {
                ((ISymbol_v2)layer).draw(g, affineTransform, geom, f, cancel, r);
                continue;
            }
            layer.draw(g, affineTransform, geom, f, cancel);
        }
    }

    private void drawInsideRectangle(Graphics2D g, Rectangle r, boolean keepAspectRatio) {
        BufferedImage theImage;
        BufferedImage bufferedImage = theImage = !this.selected ? this.image : this.imagesel;
        if (theImage != null) {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double xScale = 1.0;
            double yScale = 1.0;
            if (keepAspectRatio) {
                double scale;
                if (theImage.getWidth() > theImage.getHeight()) {
                    scale = r.getWidth() / (double)theImage.getWidth();
                    yOffset = 0.5 * (r.getHeight() - (double)theImage.getHeight() * scale);
                } else {
                    scale = r.getHeight() / (double)theImage.getHeight();
                    xOffset = 0.5 * (r.getWidth() - (double)theImage.getWidth() * scale);
                }
                xScale = yScale = scale;
            } else {
                xScale = r.getWidth() / (double)theImage.getWidth();
                yScale = r.getHeight() / (double)theImage.getHeight();
                yOffset = (double)theImage.getHeight() * 0.5 * yScale;
            }
            AffineTransform at = AffineTransform.getTranslateInstance(xOffset, yOffset);
            at.concatenate(AffineTransform.getScaleInstance(xScale, yScale));
            g.drawRenderedImage(theImage, at);
        }
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSym == null) {
            try {
                this.selectionSym = (ImageMarkerSymbol)((Object)this.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.selectionSym.selected = true;
            this.selectionSym.selectionSym = this.selectionSym;
        }
        this.selectionSym.setColor(selectionColor);
        return this.selectionSym;
    }

    public Object clone() throws CloneNotSupportedException {
        ImageMarkerSymbol copy = (ImageMarkerSymbol)((Object)super.clone());
        copy.layers = new ISymbol[]{new LineSymbol(copy), new ImageSymbol(copy)};
        return copy;
    }

    public void setTransparency(double d) {
    }

    public double getTransparency() {
        return 0.0;
    }

    public void setLayer(int i, ISymbol is) throws IndexOutOfBoundsException {
    }

    public void swapLayers(int i, int i1) {
    }

    public ISymbol getLayer(int i) {
        return this.getLayers()[i];
    }

    public int getLayerCount() {
        return 2;
    }

    public void addLayer(ISymbol is) {
    }

    public void addLayer(ISymbol is, int i) throws IndexOutOfBoundsException {
    }

    public boolean removeLayer(ISymbol is) {
        return false;
    }

    public ISymbol[] getLayers() {
        return this.layers;
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        super.setCartographicContext(ctx);
    }

    private static class LineSymbol
    extends AbstractLineSymbol
    implements ILineSymbol {
        private final ImageMarkerSymbol parent;

        public LineSymbol(ImageMarkerSymbol parent) {
            this.parent = parent;
        }

        public ISymbol getSymbolForSelection() {
            return ((ImageMarkerSymbol)this.parent.getSymbolForSelection()).getLayer(0);
        }

        public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cnclbl, Rectangle rect) {
            Point p;
            try {
                p = geom.centroid();
            }
            catch (Exception ex) {
                return;
            }
            if (affineTransform != null) {
                p.transform(affineTransform);
            }
            int size = (int)Math.round(this.parent.getEfectiveSize(f));
            Point2D theOffset = this.parent.getEfectiveOffset(f);
            int xOffset = (int)theOffset.getX();
            int yOffset = (int)theOffset.getY();
            if (size > 0 && this.parent.isDrawLineToOffset()) {
                g.setColor(this.parent.getEfectiveLineToOffsetColor(f));
                g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX() + xOffset, (int)p.getY() + yOffset);
            }
        }

        public void setLineWidth(double d) {
        }

        public double getLineWidth() {
            return 1.0;
        }

        public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
            super.setCartographicContext(ctx);
            this.parent.setCartographicContext(ctx);
        }

        public int getUnit() {
            return this.parent.getUnit();
        }
    }

    private static class ImageSymbol
    extends AbstractMarkerSymbol
    implements IMarkerSymbol {
        private final ImageMarkerSymbol parent;

        public ImageSymbol(ImageMarkerSymbol parent) {
            this.parent = parent;
        }

        public ISymbol getSymbolForSelection() {
            return ((ImageMarkerSymbol)this.parent.getSymbolForSelection()).getLayer(1);
        }

        public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cnclbl, Rectangle r) {
            Point p;
            if (r != null) {
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                try {
                    p = geometryManager.createPoint(r.getCenterX(), r.getCenterY(), 0);
                }
                catch (CreateGeometryException ex) {
                    return;
                }
            }
            try {
                p = geom.centroid();
            }
            catch (Exception ex) {
                return;
            }
            try {
                if (geom.getType() == 18) {
                    p = (Point)geom.closestPoints((Geometry)p)[0];
                } else if (geom.getType() == 21 && ((Aggregate)geom).getPrimitivesNumber() == 1) {
                    p = (Point)((Aggregate)geom).getPrimitiveAt(0).closestPoints((Geometry)p)[0];
                }
            }
            catch (Throwable th) {
                LOGGER.debug("Problems calculating the center of geometry", th);
            }
            if (affineTransform != null) {
                p.transform(affineTransform);
            }
            int size = (int)Math.round(this.parent.getEfectiveSize(f));
            double halfSize = this.parent.getEfectiveSize(f) / 2.0;
            double x = p.getX() - halfSize;
            double y = p.getY() - halfSize;
            Point2D theOffset = this.parent.getEfectiveOffset(f);
            int xOffset = (int)theOffset.getX();
            int yOffset = (int)theOffset.getY();
            if (size > 0) {
                Rectangle rect = new Rectangle(size, size);
                g.translate(x + (double)xOffset, y + (double)yOffset);
                double auxRotation = this.parent.getEfectiveRotationInRadians(f);
                g.rotate(auxRotation, halfSize, halfSize);
                this.parent.drawInsideRectangle(g, rect, true);
                g.rotate(-auxRotation, halfSize, halfSize);
                g.translate(-(x + (double)xOffset), -(y + (double)yOffset));
            }
        }

        public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
            super.setCartographicContext(ctx);
            this.parent.setCartographicContext(ctx);
        }

        public int getUnit() {
            return this.parent.getUnit();
        }
    }
}

