/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.impl;

import java.util.List;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.service.AbstractService;
import org.gvsig.tools.service.Manager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.AbstractProviderServices;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingLocator;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class DefaultEditingService
extends AbstractService
implements EditingService {
    private final ObservableHelper observableHelper;

    DefaultEditingService(DynObject arg0, EditingProviderServices editingProviderServices) throws ServiceException {
        this.init(arg0, (ProviderServices)editingProviderServices);
        ((AbstractProviderServices)editingProviderServices).setService((Service)this);
        this.observableHelper = new ObservableHelper();
    }

    protected EditingProvider getProvider() {
        return (EditingProvider)super.getProvider();
    }

    public Manager getManager() {
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return this.getProvider().getDrawingStatus(mousePosition);
    }

    public List<EditingServiceParameter> getParameters() {
        return this.getProvider().getParameters();
    }

    public EditingServiceParameter next() {
        EditingServiceParameter x = this.getProvider().next();
        this.updateObservers("EditingService.Next", x, null);
        return x;
    }

    public void setValue(Object value) throws InvalidEntryException {
        this.getProvider().setValue(value);
        this.updateObservers("EditingService.ParameterChanged1", value, null);
    }

    public void stop() throws StopServiceException {
        this.getProvider().stop();
        this.updateObservers("EditingService.Stop", null, null);
    }

    public void finishAndStore() throws FinishServiceException {
        this.getProvider().finishAndStore();
        this.updateObservers("EditingService.FinishAndStore", null, null);
    }

    public Geometry finish() throws FinishServiceException {
        Geometry x = this.getProvider().finish();
        this.updateObservers("EditingService.Finish", x, null);
        return x;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.getProvider().start();
        this.getProvider().initDefaultValues();
        this.updateObservers("EditingService.Start", null, null);
    }

    public String getName() {
        return this.getProvider().getName();
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.getProvider().setValue(parameter, value);
        this.updateObservers("EditingService.ParameterChanged2", parameter, value);
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return this.getProvider().isEnabled(parameter);
    }

    public void activate() {
        this.getProvider().activate();
        this.updateObservers("EditingService.Activate", null, null);
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.getProvider().getValue(parameter);
    }

    public Object getValue(EditingServiceParameter parameter, EditingServiceParameter.TYPE type) {
        return this.getProvider().getValue(parameter, type);
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    private void updateObservers(String type, Object v1, Object v2) {
        BaseNotification notification = new BaseNotification(type, new Object[]{v1, v2});
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    public void setDefaultFeatureValues(EditableFeature feature) {
        this.getProvider().setDefaultFeatureValues(feature);
    }

    public EditableFeature getDefaultFeatureValues() {
        return this.getProvider().getDefaultFeatureValues();
    }

    public FeatureStore getStore() {
        return (FeatureStore)this.getServiceParameters().getDynValue("featureStore");
    }

    public IVectorLegend getLegend() {
        return (IVectorLegend)this.getServiceParameters().getDynValue("legendField");
    }

    public String getDescription() {
        String name = this.getProvider().getName();
        try {
            DynObject params = EditingLocator.getManager().createServiceParameters(name);
            DynClass dynclass = params.getDynClass();
            return dynclass.getDescription();
        }
        catch (ServiceException ex) {
            return name;
        }
    }

    protected EditingProviderManager getProviderManager() {
        return EditingProviderLocator.getProviderManager();
    }

    public void setShowPreviewSymbol(boolean showPreviewSymbol) {
        this.getProvider().setShowPreviewSymbol(showPreviewSymbol);
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.getProvider().restart();
        this.updateObservers("EditingService.Restart", null, null);
    }

    public boolean mustRestartAtFinish() {
        return this.getProvider().mustRestartAtFinish();
    }
}

