/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.euclidean;

import java.awt.geom.Point2D;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanLine2DImpl;
import org.gvsig.euclidean.EuclideanManager;

public class DefaultEuclideanManager
implements EuclideanManager {
    public EuclideanLine2D createLine2D(double coefA, double coefB, double coefC) {
        return new EuclideanLine2DImpl(coefA, coefB, coefC);
    }

    public EuclideanLine2D createLine2D(double m, double b) {
        return new EuclideanLine2DImpl(m, b);
    }

    public EuclideanLine2D createLine2D(double x0, double y0, double x1, double y1) {
        return new EuclideanLine2DImpl(x0, y0, x1, y1);
    }

    public EuclideanLine2D createLine2D(Point2D p1, Point2D p2) {
        return new EuclideanLine2DImpl(p2, p1);
    }

    public EuclideanLine2D createLine2D(double m, Point2D p) {
        if (Double.isInfinite(m)) {
            return new EuclideanLine2DImpl(1.0, 0.0, -p.getX());
        }
        return new EuclideanLine2DImpl(m, this.getYIntercept(m, p));
    }

    public double getYIntercept(double m, Point2D p) {
        return this.getYIntercept(m, p.getX(), p.getY());
    }

    public double getYIntercept(double m, double x, double y) {
        return -m * x + y;
    }

    public double distance(Point2D p1, Point2D p2) {
        double x = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
        return x;
    }

    public double distance(double x1, double y1, double x2, double y2) {
        double x = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        return x;
    }

    public Point2D getCenter(double ax, double ay, double bx, double by, double cx, double cy) {
        Point2D midPointAC = this.getMidPoint(ax, ay, cx, cy);
        EuclideanLine2D lineAC = this.createLine2D(ax, ay, cx, cy);
        EuclideanLine2D bisectorAC = lineAC.getPerpendicular(midPointAC.getX(), midPointAC.getY());
        Point2D midPointBC = this.getMidPoint(bx, by, cx, cy);
        EuclideanLine2D lineBC = this.createLine2D(bx, by, cx, cy);
        EuclideanLine2D bisectorBC = lineBC.getPerpendicular(midPointBC.getX(), midPointBC.getY());
        Point2D intersection = bisectorAC.getIntersection(bisectorBC);
        return new Point2D.Double(intersection.getX(), intersection.getY());
    }

    public Point2D getCenter(Point2D a, Point2D b, Point2D c) {
        return this.getCenter(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
    }

    public Point2D getMidPoint(Point2D a, Point2D b) {
        return this.getMidPoint(a.getX(), a.getY(), b.getX(), b.getY());
    }

    public Point2D getMidPoint(double ax, double ay, double bx, double by) {
        double x = (ax + bx) / 2.0;
        double y = (ay + by) / 2.0;
        return new Point2D.Double(x, y);
    }

    public double getCoefDirection(double centerx, double centery, double point1x, double point1y, double point2x, double point2y) {
        return Math.signum((point1x - centerx) * (point2y - centery) - (point1y - centery) * (point2x - centerx));
    }

    public double getCoefDirection(Point2D center, Point2D point1, Point2D point2) {
        return this.getCoefDirection(center.getX(), center.getY(), point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public double calculateAngle(double vertexx, double vertexy, double p1x, double p1y, double p2x, double p2y) {
        double angle = Math.atan2(p2y - vertexy, p2x - vertexx) - Math.atan2(p1y - vertexy, p1x - vertexx);
        if (angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }

    public double calculateAngle(double vertexx, double vertexy, double px, double py) {
        double angle = Math.atan2(py - vertexy, px - vertexx) - Math.atan2(0.0, 1.0);
        if (angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }

    public boolean areThreePointsInLine(double ax, double ay, double bx, double by, double cx, double cy) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return true;
        }
        return Math.abs((bx - ax) / (cx - bx) - (by - ay) / (cy - by)) < 9.9E-324;
    }

    public Point2D getPointAtDistance(double x1, double y1, double distance, double angle, String unit) {
        if ("s".equals(unit)) {
            angle = Math.toRadians(angle);
        } else if ("g".equals(unit)) {
            angle = Math.PI * angle / 200.0;
        }
        double deltaX = distance * Math.cos(angle);
        double deltaY = distance * Math.sin(angle);
        Point2D.Double r = new Point2D.Double(x1 + deltaX, y1 + deltaY);
        return r;
    }
}

