/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.LookAndFeelProxy15;
import ch.randelshofer.quaqua.QuaquaButtonListener;
import ch.randelshofer.quaqua.QuaquaKeyboardFocusManager;
import ch.randelshofer.quaqua.QuaquaLazyActionMap;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaPopupFactory;
import ch.randelshofer.quaqua.QuaquaPopupMenuUI;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.color.AlphaColorUIResource;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.osx.OSXPreferences;
import java.awt.Color;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import sun.awt.AppContext;

public class BasicQuaquaNativeLookAndFeel
extends LookAndFeelProxy15 {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String pantherDir = "/ch/randelshofer/quaqua/panther/images/";
    protected static final String tigerDir = "/ch/randelshofer/quaqua/tiger/images/";
    protected static final String leopardDir = "/ch/randelshofer/quaqua/leopard/images/";
    protected static final String snowLeopardDir = "/ch/randelshofer/quaqua/snowleopard/images/";
    protected static final String lionDir = "/ch/randelshofer/quaqua/lion/images/";
    private static final int[][] selectionColors = new int[][]{{-3682085, 7835048}, {-3750202, 0x7F7F7F}, {-4860417, 3700183}, {-266893, 0xFFC11F}, {-20084, 15943240}, {-11647, 16747042}, {-3933807, 6735175}, {-1459969, 9195192}};

    public BasicQuaquaNativeLookAndFeel(String targetClassName) {
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    @Override
    public String getID() {
        return "Aqua";
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = this.target.getDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        this.installKeyboardFocusManager();
        this.installPopupFactory();
        this.installMouseGrabber();
        return table;
    }

    @Override
    protected final void initComponentDefaults(UIDefaults table) {
        this.initResourceBundle(table);
        this.initColorDefaults(table);
        this.initInputMapDefaults(table);
        this.initFontDefaults(table);
        this.initGeneralDefaults(table);
        this.initDesignDefaults(table);
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels", Locale.getDefault(), this.getClass().getClassLoader());
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        ColorUIResource listSelectionBackground;
        ColorUIResource listSelectionForeground;
        ColorUIResource textSelectionBackground;
        ColorUIResource inactiveSelectionBackground = new ColorUIResource(0xD0D0D0);
        String colorValues = OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleHighlightColor", "0.709800 0.835300 1.000000");
        try {
            float[] rgb = new float[3];
            StringTokenizer tt = new StringTokenizer(colorValues);
            for (int i = 0; i < 3; ++i) {
                String value = tt.nextToken();
                rgb[i] = Float.valueOf(value).floatValue();
            }
            textSelectionBackground = new ColorUIResource(rgb[0], rgb[1], rgb[2]);
        }
        catch (Exception e) {
            textSelectionBackground = new ColorUIResource(-4860417);
        }
        ColorUIResource listSelectionBorderColor = new ColorUIResource(0x808080);
        if (QuaquaManager.getProperty("Quaqua.selectionStyle", "auto").equals("bright")) {
            listSelectionForeground = new ColorUIResource(0);
            listSelectionBackground = textSelectionBackground;
        } else {
            listSelectionForeground = new ColorUIResource(0xFFFFFF);
            int textSelectionRGB = textSelectionBackground.getRGB() | 0xFF000000;
            listSelectionBackground = null;
            for (int i = 0; i < selectionColors.length; ++i) {
                if (selectionColors[i][0] != textSelectionRGB) continue;
                listSelectionBackground = new ColorUIResource(selectionColors[i][1]);
                break;
            }
            if (listSelectionBackground == null) {
                float[] hsb = Color.RGBtoHSB(textSelectionBackground.getRed(), textSelectionBackground.getGreen(), textSelectionBackground.getBlue(), null);
                listSelectionBackground = new ColorUIResource(Color.getHSBColor(hsb[0], hsb[1], hsb[2] * 0.8f));
            }
        }
        boolean isGraphite = OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleAquaColorVariant", "1").equals("6");
        Object[] uiDefaults = new Object[]{"desktop", new ColorUIResource(isGraphite ? 6582661 : 3828138), "activeCaption", table.get("InternalFrame.activeTitleBackground"), "activeCaptionText", new ColorUIResource(0), "activeCaptionBorder", table.get("InternalFrame.borderColor"), "inactiveCaption", table.get("InternalFrame.inactiveTitleBackground"), "inactiveCaptionText", new ColorUIResource(0x666666), "inactiveCaptionBorder", table.get("InternalFrame.borderColor"), "window", table.get("control"), "windowBorder", table.get("control"), "windowText", new ColorUIResource(0), "menu", table.get("MenuItem.background"), "menuText", new ColorUIResource(0), "text", new ColorUIResource(0xFFFFFF), "textText", new ColorUIResource(0), "textHighlight", textSelectionBackground, "textHighlightText", new ColorUIResource(0), "textInactiveText", new ColorUIResource(0x808080), "control", table.get("control"), "controlText", new ColorUIResource(0), "controlHighlight", new ColorUIResource(0xC0C0C0), "controlLtHighlight", new ColorUIResource(0xFFFFFF), "controlShadow", new ColorUIResource(0x808080), "controlDkShadow", new ColorUIResource(0), "scrollbar", table.get("control"), "info", new ColorUIResource(0xFFFFC1), "infoText", new ColorUIResource(0), "list", new ColorUIResource(0xFFFFFF), "listText", new ColorUIResource(0), "listHighlight", listSelectionBackground, "listHighlightText", listSelectionForeground, "listHighlightBorder", listSelectionBorderColor, "listInactiveHighlight", inactiveSelectionBackground, "listInactiveText", new ColorUIResource(0x808080), "menuHighlightText", new ColorUIResource(0xFFFFFF), "menuHighlight", table.get("Menu.selectionBackground")};
        this.putDefaults(table, uiDefaults);
    }

    protected void initColorDefaults(UIDefaults table) {
        Object controlForeground = table.get("controlText");
        Object controlBackground = table.get("control");
        Object textBackground = table.get("text");
        Object textForeground = table.get("textText");
        Object textSelectionBackground = table.get("textHighlight");
        AlphaColorUIResource translucentColor = new AlphaColorUIResource(0);
        Object disabledForeground = table.get("textInactiveText");
        ColorUIResource inactiveSelectionBackground = new ColorUIResource(208, 208, 208);
        Object inactiveSelectionForeground = controlForeground;
        Object menuBackground = table.get("menu");
        Object menuForeground = table.get("menuText");
        Object menuSelectionForeground = table.get("menuHighlightText");
        Object menuSelectionBackground = table.get("menuHighlight");
        Object menuDisabledBackground = menuBackground;
        Object menuDisabledForeground = disabledForeground;
        Object listBackground = table.get("list");
        Object listForeground = table.get("listText");
        InactivatableColorUIResource listSelectionBackground = new InactivatableColorUIResource(((Color)table.get("listHighlight")).getRGB(), inactiveSelectionBackground.getRGB());
        InactivatableColorUIResource listSelectionForeground = new InactivatableColorUIResource(((Color)table.get("listHighlightText")).getRGB(), ((Color)inactiveSelectionForeground).getRGB());
        ColorUIResource listSelectionBorderColor = (ColorUIResource)table.get("listHighlightBorder");
        ColorUIResource listAlternateBackground = OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleAquaColorVariant", "1").equals("6") ? new ColorUIResource(0xF0F0F0) : new ColorUIResource(15594494);
        Object[] uiDefaults = new Object[]{"Browser.selectionBackground", listSelectionBackground, "Browser.selectionForeground", listSelectionForeground, "Browser.selectionBorderColor", listSelectionBorderColor, "Browser.inactiveSelectionBackground", inactiveSelectionBackground, "Browser.inactiveSelectionForeground", inactiveSelectionForeground, "Button.background", controlBackground, "Button.foreground", controlForeground, "Button.disabledForeground", disabledForeground, "CheckBox.background", controlBackground, "CheckBox.foreground", controlForeground, "CheckBox.disabledForeground", disabledForeground, "CheckBoxMenuItem.background", menuBackground, "CheckBoxMenuItem.foreground", menuForeground, "CheckBoxMenuItem.selectionForeground", menuSelectionForeground, "CheckBoxMenuItem.selectionBackground", menuSelectionBackground, "CheckBoxMenuItem.disabledForeground", disabledForeground, "CheckBoxMenuItem.acceleratorForeground", menuForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", menuSelectionForeground, "ColorChooser.background", controlBackground, "ColorChooser.foreground", controlForeground, "ColorChooser.listSelectionBackground", new ColorUIResource(0xD4D4D4), "ColorChooser.listSelectionForeground", new ColorUIResource(0), "ComboBox.background", controlBackground, "ComboBox.foreground", controlForeground, "ComboBox.disabledBackground", controlBackground, "ComboBox.disabledForeground", disabledForeground, "ComboBox.selectionBackground", menuSelectionBackground, "ComboBox.selectionForeground", menuSelectionForeground, "Dialog.background", controlBackground, "Dialog.foreground", controlForeground, "Desktop.background", table.get("desktop"), "EditorPane.background", textBackground, "EditorPane.caretForeground", textForeground, "EditorPane.foreground", textForeground, "EditorPane.inactiveBackground", textBackground, "EditorPane.inactiveForeground", disabledForeground, "EditorPane.selectionBackground", textSelectionBackground, "EditorPane.selectionForeground", textForeground, "FileChooser.previewLabelForeground", textForeground, "FileChooser.previewValueForeground", textForeground, "FormattedTextField.background", textBackground, "FormattedTextField.foreground", textForeground, "FormattedTextField.inactiveBackground", textBackground, "FormattedTextField.inactiveForeground", disabledForeground, "FormattedTextField.selectionBackground", textSelectionBackground, "FormattedTextField.selectionForeground", textForeground, "InternalFrame.titlePaneBackground.small", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.titlePane.small.png"), "InternalFrame.vTitlePaneBackground.small", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.vTitlePane.small.png"), "InternalFrame.titlePaneForeground.small", controlForeground, "InternalFrame.titlePaneShadow.small", new ColorUIResource(0x8E8E8E), "InternalFrame.closeIcon.small", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.closeIcons.small.png", 12), "InternalFrame.maximizeIcon.small", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.maximizeIcons.small.png", 12), "InternalFrame.iconifyIcon.small", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.iconifyIcons.small.png", 12), "InternalFrame.titlePaneBackground", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.titlePane.png"), "InternalFrame.vTitlePaneBackground", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.vTitlePane.png"), "InternalFrame.titlePaneForeground", controlForeground, "InternalFrame.titlePaneShadow", new ColorUIResource(0x8E8E8E), "InternalFrame.closeIcon", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.closeIcons.png", 12), "InternalFrame.maximizeIcon", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.maximizeIcons.png", 12), "InternalFrame.iconifyIcon", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.iconifyIcons.png", 12), "InternalFrame.titlePaneBackground.mini", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.titlePane.mini.png"), "InternalFrame.vTitlePaneBackground.mini", this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/images/Frame.vTitlePane.mini.png"), "InternalFrame.titlePaneForeground.mini", controlForeground, "InternalFrame.titlePaneShadow.mini", new ColorUIResource(0x8E8E8E), "InternalFrame.closeIcon.mini", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.closeIcons.mini.png", 12), "InternalFrame.maximizeIcon,mini", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.maximizeIcons.mini.png", 12), "InternalFrame.iconifyIcon.mini", BasicQuaquaNativeLookAndFeel.makeFrameButtonStateIcon("/ch/randelshofer/quaqua/images/Frame.iconifyIcons.mini.png", 12), "InternalFrame.resizeIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Frame.resize.png"), "Label.background", controlBackground, "Label.foreground", controlForeground, "Label.disabledForeground", disabledForeground, "List.alternateBackground.0", listAlternateBackground, "List.alternateBackground.1", listBackground, "List.background", textBackground, "List.foreground", controlForeground, "List.selectionBackground", listSelectionBackground, "List.selectionForeground", listSelectionForeground, "Menu.background", menuBackground, "Menu.foreground", menuForeground, "Menu.acceleratorForeground", menuForeground, "Menu.acceleratorSelectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.disabledBackground", menuDisabledBackground, "Menu.disabledForeground", menuDisabledForeground, "MenuBar.background", menuBackground, "MenuBar.foreground", menuForeground, "MenuItem.background", menuBackground, "MenuItem.foreground", menuForeground, "MenuItem.acceleratorForeground", menuForeground, "MenuItem.acceleratorSelectionForeground", menuSelectionForeground, "MenuItem.selectionBackground", menuSelectionBackground, "MenuItem.selectionForeground", menuSelectionForeground, "MenuItem.disabledBackground", menuDisabledBackground, "MenuItem.disabledForeground", menuDisabledForeground, "MenuSeparator.background", menuBackground, "OptionPane.background", controlBackground, "OptionPane.foreground", controlForeground, "OptionPane.messageForeground", controlForeground, "Panel.background", controlBackground, "Panel.foreground", controlForeground, "PasswordField.background", textBackground, "PasswordField.foreground", textForeground, "PasswordField.caretForeground", textForeground, "PasswordField.inactiveBackground", textBackground, "PasswordField.inactiveForeground", disabledForeground, "PasswordField.selectionBackground", textSelectionBackground, "PasswordField.selectionForeground", textForeground, "PopupMenu.foreground", menuForeground, "PopupMenu.background", menuBackground, "PopupMenu.selectionBackground", menuSelectionBackground, "RadioButton.disabledForeground", disabledForeground, "RadioButton.background", controlBackground, "RadioButton.foreground", controlForeground, "RadioButtonMenuItem.foreground", controlForeground, "RadioButtonMenuItem.selectionForeground", menuSelectionForeground, "RadioButtonMenuItem.background", menuBackground, "RadioButtonMenuItem.foreground", menuForeground, "RadioButtonMenuItem.acceleratorForeground", menuForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", menuSelectionForeground, "RadioButtonMenuItem.selectionBackground", menuSelectionBackground, "RadioButtonMenuItem.selectionForeground", menuSelectionForeground, "RadioButtonMenuItem.disabledBackground", menuDisabledBackground, "RadioButtonMenuItem.disabledForeground", menuDisabledForeground, "RootPane.background", controlBackground, "ScrollBar.background", controlBackground, "ScrollBar.foreground", controlForeground, "ScrollPane.background", controlBackground, "ScrollPane.foreground", controlForeground, "Separator.background", controlBackground, "Separator.foreground", new ColorUIResource(0x808080), "Separator.highlight", new ColorUIResource(0xE0E0E0), "Separator.shadow", new ColorUIResource(0x808080), "Slider.background", controlBackground, "Slider.foreground", controlForeground, "Spinner.background", textBackground, "Spinner.foreground", controlForeground, "Spinner.borderPainted", Boolean.TRUE, "SplitPane.background", controlBackground, "SplitPane.foreground", controlForeground, "SplitPaneDivider.draggingColor", new AlphaColorUIResource(-1603901850), "TabbedPane.background", controlBackground, "TabbedPane.disabledForeground", disabledForeground, "TabbedPane.foreground", controlForeground, "TabbedPane.wrap.background", controlBackground, "TabbedPane.wrap.disabledForeground", disabledForeground, "TabbedPane.wrap.foreground", controlForeground, "TabbedPane.wrap.contentBorder", this.makeImageBevelBorder("/ch/randelshofer/quaqua/jaguar/images/TabbedPane.contentBorder.png", new Insets(8, 7, 8, 7), new Insets(1, 3, 3, 3), false), "TabbedPane.wrapBarTopBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/TabbedPane.wrapBarsTop.png", new Insets(0, 1, 0, 1), 3, true), "TabbedPane.wrapBarBottomBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/TabbedPane.wrapBarsBottom.png", new Insets(0, 1, 0, 1), 3, false), "TabbedPane.wrapBarRightBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/TabbedPane.wrapBarsRight.png", new Insets(1, 0, 1, 0), 3, true), "TabbedPane.wrapBarLeftBorders", this.makeImageBevelBorders("/ch/randelshofer/quaqua/jaguar/images/TabbedPane.wrapBarsLeft.png", new Insets(1, 0, 1, 0), 3, true), "TabbedPane.scroll.background", controlBackground, "TabbedPane.scroll.disabledForeground", disabledForeground, "TabbedPane.scroll.foreground", controlForeground, "Table.alternateBackground.0", listAlternateBackground, "Table.alternateBackground.1", listBackground, "Table.focusCellBackground", listBackground, "Table.focusCellForeground", listForeground, "Table.background", listBackground, "Table.foreground", listForeground, "Table.selectionBackground", listSelectionBackground, "Table.selectionForeground", listSelectionForeground, "Table.gridColor", new AlphaColorUIResource(0x33000000), "Table.focusCellForeground", listSelectionForeground, "Table.focusCellBackground", listSelectionBackground, "TableHeader.background", controlBackground, "TableHeader.foreground", controlForeground, "TextArea.background", textBackground, "TextArea.foreground", textForeground, "TextArea.inactiveForeground", disabledForeground, "TextArea.selectionBackground", textSelectionBackground, "TextArea.selectionForeground", textForeground, "TextField.background", textBackground, "TextField.foreground", textForeground, "TextField.inactiveBackground", textBackground, "TextField.inactiveForeground", disabledForeground, "TextField.inactiveSelectionBackground", inactiveSelectionBackground, "TextField.selectionBackground", textSelectionBackground, "TextField.selectionForeground", textForeground, "TextPane.background", textBackground, "TextPane.foreground", textForeground, "TextPane.inactiveForeground", disabledForeground, "TextPane.selectionBackground", textSelectionBackground, "TextPane.selectionForeground", textForeground, "ToggleButton.background", controlBackground, "ToggleButton.disabledForeground", disabledForeground, "ToggleButton.foreground", controlForeground, "ToolBar.dockingForeground", listSelectionBackground, "ToolBar.floatingForeground", new AlphaColorUIResource(0), "ToolTip.foreground", table.get("infoText"), "ToolTip.background", table.get("info"), "Tree.alternateBackground.0", listAlternateBackground, "Tree.alternateBackground.1", listBackground, "Tree.selectionBackground", listSelectionBackground, "Tree.selectionBorderColor", listSelectionBorderColor, "Tree.selectionForeground", listSelectionForeground, "Tree.controlForeground", listForeground, "Tree.textBackground", translucentColor, "Tree.textForeground", listForeground, "Viewport.background", listBackground, "Viewport.foreground", listForeground};
        this.putDefaults(table, uiDefaults);
    }

    protected void initInputMapDefaults(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap passwordFieldInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "beep", "meta C", "beep", "meta V", "paste-from-clipboard", "CUT", "beep", "COPY", "beep", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap spinnerInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new String[]{"shift ENTER", "insert-break", "alt ENTER", "insert-break", "ENTER", "insert-break", "TAB", "insert-tab", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "alt UP", "caret-begin-line", "alt KP_UP", "caret-begin-line", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "alt DOWN", "caret-end-line", "alt KP_DOWN", "caret-end-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "meta shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "meta shift KP_RIGHT", "selection-end-line", "HOME", "caret-begin", "END", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word"});
        UIDefaults.LazyInputMap comboEditorInputMap = new UIDefaults.LazyInputMap(new String[]{"BACK_SPACE", "delete-previous", "DELETE", "delete-next", "meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "alt shift LEFT", "selection-previous-word", "alt shift KP_LEFT", "selection-previous-word", "alt shift RIGHT", "selection-next-word", "alt shift KP_RIGHT", "selection-next-word", "ctrl LEFT", "caret-begin-line", "meta LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "meta RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "meta shift LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "meta shift RIGHT", "selection-end-line", "shift HOME", "selection-begin", "shift END", "selection-end", "meta A", "select-all", "meta shift A", "unselect", "controlBackground shift O", "toggle-componentOrientation", "alt DELETE", "delete-next-word", "alt BACK_SPACE", "delete-previous-word", "ENTER", "notify-field-accept"});
        UIDefaults.LazyInputMap tabbedPaneFocusInputMap = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "meta DOWN", "requestFocusForVisibleComponent", "meta KP_DOWN", "requestFocusForVisibleComponent"});
        UIDefaults.LazyInputMap tabbedPaneAncestorInputMap = new UIDefaults.LazyInputMap(new Object[]{"meta PAGE_DOWN", "navigatePageDown", "meta PAGE_UP", "navigatePageUp", "meta UP", "requestFocus", "meta KP_UP", "requestFocus"});
        UIDefaults.LazyInputMap tableAncestorInputMap = new UIDefaults.LazyInputMap(new Object[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "meta shift RIGHT", "selectNextColumnExtendSelection", "meta shift KP_RIGHT", "selectNextColumnExtendSelection", "meta RIGHT", "selectNextColumnChangeLead", "meta KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "meta shift LEFT", "selectPreviousColumnExtendSelection", "meta shift KP_LEFT", "selectPreviousColumnExtendSelection", "meta LEFT", "selectPreviousColumnChangeLead", "meta KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "meta shift DOWN", "selectNextRowExtendSelection", "meta shift KP_DOWN", "selectNextRowExtendSelection", "meta DOWN", "selectNextRowChangeLead", "meta KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "meta shift UP", "selectPreviousRowExtendSelection", "meta shift KP_UP", "selectPreviousRowExtendSelection", "meta UP", "selectPreviousRowChangeLead", "meta KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "meta shift HOME", "selectFirstRowExtendSelection", "meta HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "meta shift END", "selectLastRowExtendSelection", "meta END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "meta shift PAGE_UP", "scrollLeftExtendSelection", "meta PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "meta shift PAGE_DOWN", "scrollRightExtendSelection", "meta PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "meta A", "selectAll", "meta shift A", "clearSelection", "ESCAPE", "cancel", "meta PERIOD", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "meta SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "meta shift SPACE", "moveSelectionTo"});
        UIDefaults.LazyInputMap tableAncestorInputMapRightToLeft = new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "meta shift RIGHT", "selectPreviousColumnExtendSelection", "meta shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift RIGHT", "selectPreviousColumnChangeLead", "shift KP_RIGHT", "selectPreviousColumnChangeLead", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "meta shift LEFT", "selectNextColumnExtendSelection", "meta shift KP_LEFT", "selectNextColumnExtendSelection", "meta LEFT", "selectNextColumnChangeLead", "meta KP_LEFT", "selectNextColumnChangeLead", "meta PAGE_UP", "scrollRightChangeSelection", "meta PAGE_DOWN", "scrollLeftChangeSelection", "meta shift PAGE_UP", "scrollRightExtendSelection", "meta shift PAGE_DOWN", "scrollLeftExtendSelection"});
        Object[] uiDefaults = new Object[]{"ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "meta PERIOD", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.editorInputMap", comboEditorInputMap, "EditorPane.focusInputMap", multilineInputMap, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "meta PERIOD", "cancelSelection", "F5", "refresh"}), "FormattedTextField.focusInputMap", fieldInputMap, "FormattedTextField.keyBindings", null, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "meta shift UP", "selectPreviousRowExtendSelection", "meta shift KP_UP", "selectPreviousRowExtendSelection", "meta UP", "selectPreviousRowChangeLead", "meta KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "meta shift DOWN", "selectNextRowExtendSelection", "meta shift KP_DOWN", "selectNextRowExtendSelection", "meta DOWN", "selectNextRowChangeLead", "meta KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "meta shift LEFT", "selectPreviousColumnExtendSelection", "meta shift KP_LEFT", "selectPreviousColumnExtendSelection", "meta LEFT", "selectPreviousColumnChangeLead", "meta KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "meta shift RIGHT", "selectNextColumnExtendSelection", "meta shift KP_RIGHT", "selectNextColumnExtendSelection", "meta RIGHT", "selectNextColumnChangeLead", "meta KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "meta shift HOME", "selectFirstRowExtendSelection", "meta HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "meta shift END", "selectLastRowExtendSelection", "meta END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "meta shift PAGE_UP", "scrollUpExtendSelection", "meta PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "meta shift PAGE_DOWN", "scrollDownExtendSelection", "meta PAGE_DOWN", "scrollDownChangeLead", "meta A", "selectAll", "meta SLASH", "selectAll", "meta shift A", "clearSelection", "meta BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "meta SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "meta shift SPACE", "moveSelectionTo"}), "List.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "meta shift LEFT", "selectNextColumnExtendSelection", "meta shift KP_LEFT", "selectNextColumnExtendSelection", "meta LEFT", "selectNextColumnChangeLead", "meta KP_LEFT", "selectNextColumnChangeLead", "RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "meta shift RIGHT", "selectPreviousColumnExtendSelection", "meta shift KP_RIGHT", "selectPreviousColumnExtendSelection", "meta RIGHT", "selectPreviousColumnChangeLead", "meta KP_RIGHT", "selectPreviousColumnChangeLead"}), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close", "meta PERIOD", "close"}, "PasswordField.focusInputMap", passwordFieldInputMap, "PasswordField.keyBindings", null, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed", "UP", "selectPreviousButton", "KP_UP", "selectPreviousButton", "DOWN", "selectNextButton", "KP_DOWN", "selectNextButton", "LEFT", "selectPreviousButton", "KP_LEFT", "selectPreviousButton", "RIGHT", "selectNextButton", "KP_RIGHT", "selectNextButton"}), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.focusInputMap", spinnerInputMap, "TabbedPane.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.actionMap", table.get("TabbedPane.actionMap"), "TabbedPane.wrap.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.wrap.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.wrap.actionMap", table.get("TabbedPane.actionMap"), "TabbedPane.scroll.focusInputMap", tabbedPaneFocusInputMap, "TabbedPane.scroll.ancestorInputMap", tabbedPaneAncestorInputMap, "TabbedPane.scroll.actionMap", table.get("TabbedPane.actionMap"), "Table.focusInputMap", tableAncestorInputMap, "Table.focusInputMap.rightToLeft", tableAncestorInputMapRightToLeft, "Table.ancestorInputMap", tableAncestorInputMap, "Table.ancestorInputMap.rightToLeft", tableAncestorInputMapRightToLeft, "TextArea.focusInputMap", multilineInputMap, "TextArea.keyBindings", null, "TextField.focusInputMap", fieldInputMap, "TextField.keyBindings", null, "TextPane.focusInputMap", multilineInputMap, "TextPane.keyBindings", null, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "alt UP", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "alt DOWN", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "meta A", "selectAll", "meta shift A", "clearSelection", "meta SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "meta HOME", "selectFirstChangeLead", "meta END", "selectLastChangeLead", "meta UP", "selectPreviousChangeLead", "meta KP_UP", "selectPreviousChangeLead", "meta DOWN", "selectNextChangeLead", "meta KP_DOWN", "selectNextChangeLead", "meta PAGE_DOWN", "scrollDownChangeLead", "meta shift PAGE_DOWN", "scrollDownExtendSelection", "meta PAGE_UP", "scrollUpChangeLead", "meta shift PAGE_UP", "scrollUpExtendSelection", "meta LEFT", "scrollLeft", "meta KP_LEFT", "scrollLeft", "meta RIGHT", "scrollRight", "meta KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"})};
        this.putDefaults(table, uiDefaults);
    }

    protected Font getBaseSystemFont() {
        return new FontUIResource("Lucida Grande", 0, 13);
    }

    protected void initFontDefaults(UIDefaults table) {
        Font baseSystemFont = this.getBaseSystemFont();
        float fourteen = 14.0f;
        float thirteen = 13.0f;
        float twelve = 12.0f;
        float eleven = 11.0f;
        float ten = 10.0f;
        float nine = 9.0f;
        int fontPlain = 0;
        int fontBold = 1;
        UIDefaults.ProxyLazyValue systemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, thirteen)});
        UIDefaults.ProxyLazyValue emphasizedSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, thirteen)});
        UIDefaults.ProxyLazyValue smallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, eleven)});
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, eleven)});
        UIDefaults.ProxyLazyValue miniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, nine)});
        UIDefaults.ProxyLazyValue emphasizedMiniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, nine)});
        Object applicationFont = baseSystemFont;
        UIDefaults.ProxyLazyValue labelFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, ten)});
        UIDefaults.ProxyLazyValue viewFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, twelve)});
        UIDefaults.ProxyLazyValue menuFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, fourteen)});
        if (QuaquaManager.getProperty("Quaqua.sizeStyle", "regular").equals("small")) {
            viewFont = smallSystemFont;
            systemFont = smallSystemFont;
            emphasizedSystemFont = emphasizedSmallSystemFont;
            menuFont = smallSystemFont;
            applicationFont = smallSystemFont;
        }
        Object[] uiDefaults = new Object[]{"SystemFont", systemFont, "EmphasizedSystemFont", emphasizedSystemFont, "SmallSystemFont", smallSystemFont, "EmphasizedSmallSystemFont", emphasizedSmallSystemFont, "MiniSystemFont", miniSystemFont, "EmphasizedMiniSystemFont", emphasizedMiniSystemFont, "ApplicationFont", applicationFont, "LabelFont", labelFont, "ViewFont", viewFont, "MenuFont", menuFont, "Browser.font", viewFont, "Button.font", systemFont, "Button.smallFont", smallSystemFont, "CheckBox.font", systemFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "CheckBoxMenuItem.font", menuFont, "ColorChooser.font", smallSystemFont, "ColorChooser.crayonsFont", systemFont, "ComboBox.font", systemFont, "EditorPane.font", applicationFont, "FormattedTextField.font", applicationFont, "FileChooser.previewLabelFont", smallSystemFont, "FileChooser.previewValueFont", smallSystemFont, "IconButton.font", smallSystemFont, "InternalFrame.optionDialogTitleFont", menuFont, "InternalFrame.titleFont", menuFont, "Label.font", systemFont, "List.font", viewFont, "List.focusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{table.get("listHighlightBorder")}), "List.cellNoFocusBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{1, 1, 1, 1}), "Menu.acceleratorFont", menuFont, "Menu.font", menuFont, "MenuBar.font", menuFont, "MenuItem.acceleratorFont", menuFont, "MenuItem.font", menuFont, "OptionPane.buttonFont", systemFont, "OptionPane.font", systemFont, "OptionPane.messageFont", emphasizedSystemFont, "OptionPane.htmlMessageFont", systemFont, "Panel.font", systemFont, "PasswordField.font", applicationFont, "PopupMenu.font", menuFont, "ProgressBar.font", systemFont, "RadioButton.font", systemFont, "RadioButtonMenuItem.acceleratorFont", menuFont, "RadioButtonMenuItem.font", menuFont, "RootPane.font", systemFont, "ScrollBar.font", systemFont, "ScrollPane.font", systemFont, "Slider.font", systemFont, "Slider.labelFont", labelFont, "Spinner.font", systemFont, "TabbedPane.font", systemFont, "TabbedPane.smallFont", smallSystemFont, "TabbedPane.wrap.font", systemFont, "TabbedPane.wrap.smallFont", smallSystemFont, "TabbedPane.scroll.font", systemFont, "TabbedPane.scroll.smallFont", smallSystemFont, "Table.font", viewFont, "TableHeader.font", smallSystemFont, "TextArea.font", applicationFont, "TextField.font", applicationFont, "TextPane.font", applicationFont, "TitledBorder.font", smallSystemFont, "ToggleButton.font", systemFont, "ToolBar.font", miniSystemFont, "ToolBar.titleFont", miniSystemFont, "ToolTip.font", smallSystemFont, "Tree.font", viewFont, "Viewport.font", systemFont};
        this.putDefaults(table, uiDefaults);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        int intValue;
        String javaVersion = QuaquaManager.getProperty("java.version", "");
        String systemFontName = this.getBaseSystemFont().getName();
        Boolean isRequestFocusEnabled = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.requestFocusEnabled", "false"));
        String prefValue = OSXPreferences.getString(OSXPreferences.GLOBAL_PREFERENCES, "AppleKeyboardUIMode", "2");
        try {
            intValue = Integer.valueOf(prefValue);
        }
        catch (NumberFormatException e) {
            intValue = 2;
        }
        Boolean allControlsFocusable = isRequestFocusEnabled != false || (intValue & 2) == 2;
        UIDefaults.ProxyLazyValue dialogBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$DialogBorder");
        UIDefaults.ProxyLazyValue questionDialogBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$QuestionDialogBorder");
        ColorUIResource listSelectionBorderColor = (ColorUIResource)table.get("listHighlightBorder");
        Color menuBackground = (Color)table.get("menu");
        int[] values = QuaquaManager.getProperty("Quaqua.visualMargin", new int[]{3, 3, 3, 3});
        InsetsUIResource visualMargin = new InsetsUIResource(values[0], values[1], values[2], values[3]);
        Boolean opaque = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.opaque", "false"));
        Boolean autovalidate = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.FileChooser.autovalidate", "true"));
        UIDefaults.ProxyLazyValue textComponentPopupHandler = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTextComponentPopupHandler");
        UIDefaults.ProxyLazyValue textFieldFocusHandler = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaTextFieldFocusHandler");
        Boolean autoselect = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.TextComponent.autoSelect", "true"));
        UIDefaults.ProxyLazyValue textFieldBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaNativeTextFieldBorder$UIResource", new Object[]{new Insets(0, 0, 0, 0), new Insets(6, 8, 6, 8), true});
        UIDefaults.ProxyLazyValue buttonBorder = new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaNativeButtonBorder$UIResource");
        boolean isOrderFilesByType = false;
        prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "AppleShowAllFiles", "false").toLowerCase();
        boolean isFileHidingEnabled = prefValue.equals("false") || prefValue.equals("no");
        boolean isQuickLookEnabled = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.FileChooser.quickLookEnabled", "true"));
        Boolean enforceVisualMargin = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.enforceVisualMargin", "false"));
        Object[] uiDefaults = new Object[]{"Browser.sizeHandleIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/images/Browser.sizeHandleIcon.png", 1, Boolean.TRUE, 1}), "Button.actionMap", new QuaquaLazyActionMap(QuaquaButtonListener.class), "Button.border", buttonBorder, "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.margin", new InsetsUIResource(2, 2, 2, 2), "Button.opaque", opaque, "Button.textIconGap", 4, "Button.textShiftOffset", 0, "Button.helpIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRoundHelp, 0, 1, 21, 21, true), "Button.smallHelpIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRoundHelp, 0, 1, 18, 18, true), "Button.miniHelpIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRoundHelp, 1, 1, 15, 15, true), "Button.requestFocusEnabled", isRequestFocusEnabled, "Button.minimumWidth", 80, "Button.focusable", allControlsFocusable, "CheckBox.border", new VisualMarginBorder(0, 0, 0, 0), "CheckBox.icon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonCheckBox, 0, 0, 16, 20, true), "CheckBox.smallIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonCheckBox, 0, 0, 14, 16, true), "CheckBox.miniIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonCheckBox, 0, -1, 10, 15, true), "CheckBox.margin", new InsetsUIResource(0, 0, 0, 0), "CheckBox.opaque", opaque, "CheckBox.textIconGap", 4, "CheckBox.textShiftOffset", 0, "CheckBox.requestFocusEnabled", isRequestFocusEnabled, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBox.focusable", allControlsFocusable, "CheckBox.enforceVisualMargin", enforceVisualMargin, "ColorChooser.defaultChoosers", new String[]{"ch.randelshofer.quaqua.colorchooser.ColorWheelChooser", "ch.randelshofer.quaqua.colorchooser.ColorSlidersChooser", "ch.randelshofer.quaqua.colorchooser.ColorPalettesChooser", "ch.randelshofer.quaqua.colorchooser.SwatchesChooser", "ch.randelshofer.quaqua.colorchooser.CrayonsChooser", "ch.randelshofer.quaqua.colorchooser.QuaquaColorPicker"}, "ColorChooser.swatchesSwatchSize", new DimensionUIResource(5, 5), "ColorChooser.resetMnemonic", -1, "ColorChooser.crayonsImage", this.makeImage("/ch/randelshofer/quaqua/images/ColorChooser.crayons.png"), "ColorChooser.textSliderGap", 0, "ColorChooser.colorPalettesIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorPalettesIcons.png", 3), "ColorChooser.colorSlidersIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorSlidersIcons.png", 3), "ColorChooser.colorSwatchesIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorSwatchesIcons.png", 3), "ColorChooser.colorWheelIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.colorWheelIcons.png", 3), "ColorChooser.crayonsIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.crayonsIcons.png", 3), "ColorChooser.imagePalettesIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ColorChooser.imagePalettesIcons.png", 3), "ColorChooser.colorPickerIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/ColorChooser.colorPickerIcon.png"), "ColorChooser.colorPickerMagnifier", this.makeBufferedImage("/ch/randelshofer/quaqua/images/ColorChooser.colorPickerMagnifier.png"), "ColorChooser.colorPickerHotSpot", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{29, 29}), "ColorChooser.colorPickerPickOffset", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{-13, -13}), "ColorChooser.colorPickerGlassRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{2, 2, 29, 29}), "ColorChooser.colorPickerCaptureRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{-15, -15, 5, 5}), "ColorChooser.colorPickerZoomRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{4, 4, 25, 25}), "ColorChooser.ColorSlider.northThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.northThumbs.small.png"), "ColorChooser.ColorSlider.westThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.westThumbs.small.png"), "ComboBox.buttonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonComboBox, new Insets(0, -10, 0, -2), new Insets(0, 0, 0, 0), true), "ComboBox.smallButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonComboBox, new Insets(0, -20, 0, -1), new Insets(0, 0, 0, 0), true), "ComboBox.miniButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonComboBox, new Insets(0, -12, 0, -2), new Insets(0, 0, 0, 0), true), "ComboBox.cellBorder", null, "ComboBox.editorBorder", textFieldBorder, "ComboBox.smallCellBorder", null, "ComboBox.cellAndButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonPopUp, new Insets(1, 1, 0, 0), new Insets(3, 3, 3, 3), true), "ComboBox.smallCellAndButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonPopUp, new Insets(1, 0, 0, 0), new Insets(3, 3, 3, 3), true), "ComboBox.miniCellAndButtonBorder", this.makeNativeButtonStateBorder(OSXAquaPainter.Widget.buttonPopUp, new Insets(1, 2, 0, 1), new Insets(3, 3, 3, 3), true), "ComboBox.buttonInsets", new Insets(-3, -3, -3, -3), "ComboBox.border", new VisualMarginBorder(2, 0, 2, 0), "ComboBox.dropDownIcon", null, "ComboBox.opaque", opaque, "ComboBox.popupIcon", null, "ComboBox.smallPopupIcon", null, "ComboBox.miniPopupIcon", null, "ComboBox.cellEditorPopupIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/ComboBox.small.popupIcons.png", 6), "ComboBox.smallDropDownIcon", null, "ComboBox.miniDropDownIcon", null, "ComboBox.dropDownWidth", 18, "ComboBox.smallDropDownWidth", 16, "ComboBox.miniDropDownWidth", 14, "ComboBox.popupWidth", 19, "ComboBox.smallPopupWidth", 17, "ComboBox.miniPopupWidth", 16, "ComboBox.maximumRowCount", 8, "ComboBox.arrowButtonInsets", new InsetsUIResource(4, 8, 3, 5), "ComboBox.smallArrowButtonInsets", new InsetsUIResource(4, 6, 3, 5), "ComboBox.miniArrowButtonInsets", new InsetsUIResource(4, 3, 3, 5), "ComboBox.requestFocusEnabled", isRequestFocusEnabled, "ComboBox.showPopupOnNavigation", Boolean.TRUE, "ComboBox.harmonizePreferredHeight", Boolean.FALSE, "ComboBoxButton.margin", new InsetsUIResource(0, 0, 0, 0), "ComboBox.changeEditorForeground", Boolean.TRUE, "ComboBox.focusable", allControlsFocusable, "Component.visualMargin", visualMargin, "EditorPane.margin", new InsetsUIResource(1, 3, 1, 3), "EditorPane.popupHandler", textComponentPopupHandler, "FileChooser.autovalidate", autovalidate, "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{table.get("listHighlightBorder")}), "FileChooser.browserCellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.disclosureButtonIcon", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/leopard/images/FileChooser.disclosureButtonIcons.png", 10), "FileChooser.fileHidingEnabled", isFileHidingEnabled, "FileChooser.quickLookEnabled", isQuickLookEnabled, "FileChooser.homeFolderIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileChooser.homeFolderIcon.png"), "FileChooser.orderByType", isOrderFilesByType, "FileChooser.previewLabelForeground", new ColorUIResource(0), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 1), "FileChooser.previewLabelDelimiter", ":", "FileChooser.splitPaneDividerSize", 4, "FileChooser.speed", QuaquaManager.getProperty("Quaqua.FileChooser.speed") != null && QuaquaManager.getProperty("Quaqua.FileChooser.speed").equals("true"), "FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.computerIcon.png"), "FileView.directoryIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.directoryIcon.png"), "FileView.fileIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.fileIcon.png"), "FileView.aliasBadge", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.aliasBadge.png"), "FormattedTextField.border", textFieldBorder, "FormattedTextField.opaque", opaque, "FormattedTextField.focusHandler", textFieldFocusHandler, "FormattedTextField.popupHandler", textComponentPopupHandler, "FormattedTextField.autoSelect", autoselect, "Label.border", new VisualMarginBorder(0, 0, 0, 0), "Label.opaque", opaque, "List.cellRenderer", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaDefaultListCellRenderer"), "Menu.borderPainted", Boolean.TRUE, "MenuItem.borderPainted", Boolean.TRUE, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0), "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.errorIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{0}), "OptionPane.errorIconResource", "/ch/randelshofer/quaqua/images/OptionPane.errorIcon.png", "OptionPane.informationIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{1}), "OptionPane.questionIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{3}), "OptionPane.warningIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOptionPaneIcon", new Object[]{2}), "OptionPane.warningIconResource", "/ch/randelshofer/quaqua/images/OptionPane.warningIcon.png", "OptionPane.css", "<head><style type=\"text/css\">b { font: 13pt \"" + systemFontName + "\" }" + "p { font: 11pt \"" + systemFontName + "\"; margin-top: 8px }" + "</style>" + "</head>", "OptionPane.messageLabelWidth", 360, "OptionPane.maxCharactersPerLineCount", 60, "Panel.opaque", opaque, "PopupMenu.enableHeavyWeightPopup", Boolean.TRUE, "PasswordField.border", textFieldBorder, "PasswordField.opaque", opaque, "PasswordField.focusHandler", textFieldFocusHandler, "PasswordField.popupHandler", textComponentPopupHandler, "PasswordField.autoSelect", autoselect, "RadioButton.border", new VisualMarginBorder(0, 0, 0, 0), "RadioButton.margin", new InsetsUIResource(0, 0, 0, 0), "RadioButton.icon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRadio, 0, 1, 16, 20, true), "RadioButton.smallIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRadio, 0, 1, 14, 17, true), "RadioButton.miniIcon", this.makeNativeButtonStateIcon(OSXAquaPainter.Widget.buttonRadio, 0, 1, 10, 16, true), "RadioButton.opaque", opaque, "RadioButton.textIconGap", 4, "RadioButton.textShiftOffset", 0, "RadioButton.requestFocusEnabled", isRequestFocusEnabled, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButton.enforceVisualMargin", enforceVisualMargin, "RadioButton.focusable", allControlsFocusable, "RootPane.opaque", Boolean.TRUE, "RootPane.frameBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$FrameBorder"), "RootPane.plainDialogBorder", dialogBorder, "RootPane.informationDialogBorder", dialogBorder, "RootPane.errorDialogBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$ErrorDialogBorder"), "RootPane.colorChooserDialogBorder", questionDialogBorder, "RootPane.fileChooserDialogBorder", questionDialogBorder, "RootPane.questionDialogBorder", questionDialogBorder, "RootPane.warningDialogBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorders$WarningDialogBorder"), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "RootPane.windowSnapDistance", 10, "RootPane.draggableWindowBackground", Boolean.FALSE, "RootPane.windowShadow", Boolean.TRUE, "ScrollBar.focusable", Boolean.FALSE, "ScrollPane.requesFocusEnabled", Boolean.FALSE, "ScrollPane.focusable", Boolean.FALSE, "ScrollPane.opaque", opaque, "ScrollPane.growBoxSize", new DimensionUIResource(0, 0), "Separator.border", new VisualMarginBorder(), "Sheet.showAsSheet", Boolean.TRUE, "Slider.roundThumb", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.roundThumbs.png"), "Slider.roundThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.roundThumbs.small.png"), "Slider.southThumb", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.southThumbs.png"), "Slider.eastThumb", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.eastThumbs.png"), "Slider.northThumb", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.northThumbs.png"), "Slider.westThumb", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.westThumbs.png"), "Slider.eastThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.eastThumbs.small.png"), "Slider.southThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.southThumbs.small.png"), "Slider.northThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.northThumbs.small.png"), "Slider.westThumb.small", BasicQuaquaNativeLookAndFeel.makeSliderThumbIcon("/ch/randelshofer/quaqua/images/Slider.westThumbs.small.png"), "Slider.opaque", opaque, "Slider.requestFocusEnabled", isRequestFocusEnabled, "Slider.tickColor", new ColorUIResource(0x808080), "Slider.focusInsets", new Insets(0, 0, 0, 0), "Slider.verticalTracks", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Slider.verticalTracks.png", new Insets(4, 5, 4, 0), 2, true), "Slider.horizontalTracks", this.makeImageBevelBorders("/ch/randelshofer/quaqua/images/Slider.horizontalTracks.png", new Insets(5, 4, 0, 4), 2, false), "Slider.focusable", allControlsFocusable, "Spinner.arrowButtonBorder", null, "Spinner.arrowButtonInsets", null, "Spinner.border", null, "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.opaque", opaque, "Spinner.north", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.north.png", 10), "Spinner.south", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.south.png", 10), "Spinner.smallNorth", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.small.north.png", 10), "Spinner.smallSouth", BasicQuaquaNativeLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/Spinner.small.south.png", 10), "SplitPane.opaque", opaque, "SplitPane.border", null, "SplitPane.dividerSize", 10, "SplitPane.thumbDimple", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.thumbDimple.png"), "SplitPane.barDimple", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.barDimple.png"), "SplitPane.hBar", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/SplitPane.hBar.png", new Insets(4, 0, 5, 0), true), "SplitPane.vBar", this.makeImageBevelBorder("/ch/randelshofer/quaqua/images/SplitPane.vBar.png", new Insets(0, 4, 0, 5), true), "SplitPane.upArrow", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.upArrow.png"), "SplitPane.downArrow", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.downArrow.png"), "SplitPane.rightArrow", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.rightArrow.png"), "SplitPane.leftArrow", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/SplitPane.leftArrow.png"), "SplitPane.focusable", Boolean.FALSE, "SplitPane.requestFocusEnabled", Boolean.FALSE, "SplitPaneDivider.border", null, "SplitPaneDivider.focusable", Boolean.FALSE, "SplitPaneDivider.requestFocusEnabled", Boolean.FALSE, "TabbedPane.opaque", opaque, "TabbedPane.wrap.opaque", opaque, "TabbedPane.scroll.opaque", opaque, "TabbedPane.requestFocusEnabled", isRequestFocusEnabled, "TabbedPane.textIconGap", 4, "TabbedPane.scroll.textIconGap", 4, "TabbedPane.wrap.textIconGap", 4, "Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(listSelectionBorderColor), "TextArea.margin", new InsetsUIResource(1, 3, 1, 3), "TextArea.opaque", Boolean.TRUE, "TextArea.popupHandler", textComponentPopupHandler, "TextComponent.showNonEditableCaret", QuaquaManager.getProperty("Quaqua.showNonEditableCaret", "true").equals("true"), "TextField.border", textFieldBorder, "TextField.opaque", opaque, "TextField.focusHandler", textFieldFocusHandler, "TextField.popupHandler", textComponentPopupHandler, "TextField.autoSelect", autoselect, "TextPane.margin", new InsetsUIResource(1, 3, 1, 3), "TextPane.opaque", Boolean.TRUE, "TextPane.popupHandler", textComponentPopupHandler, "ToggleButton.border", buttonBorder, "ToggleButton.margin", new InsetsUIResource(2, 2, 2, 2), "ToggleButton.opaque", opaque, "ToggleButton.textIconGap", 4, "ToggleButton.textShiftOffset", 0, "ToggleButton.requestFocusEnabled", isRequestFocusEnabled, "ToggleButton.focusable", allControlsFocusable, "ToolBar.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaNativeToolBarBorder$UIResource"), "ToolBar.separatorSize", null, "ToolBar.margin", new InsetsUIResource(0, 0, 0, 0), "ToolBar.borderBright", new AlphaColorUIResource(0x999999), "ToolBar.borderDark", new ColorUIResource(0x8C8C8C), "ToolBar.borderDivider", new ColorUIResource(0x9F9F9F), "ToolBar.borderDividerInactive", new ColorUIResource(0x9F9F9F), "ToolBar.bottom.gradient", new Color[]{new Color(0xD8D8D8), new Color(0xBDBDBD), new Color(0xAEAEAE), new Color(0x969696)}, "ToolBar.bottom.gradientInactive", new Color[]{new Color(0xEEEEEE), new Color(0xE4E4E4), new Color(0xCFCFCF)}, "ToolBar.opaque", Boolean.TRUE, "ToolTip.border", new BorderUIResource.LineBorderUIResource(new ColorUIResource(0x303030)), "Tree.collapsedIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.collapsedIcon.png"), "Tree.expandedIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.expandedIcon.png"), "Tree.leftChildIndent", 7, "Tree.line", new AlphaColorUIResource(0), "Tree.paintLines", Boolean.FALSE, "Tree.rightChildIndent", 13, "Tree.rowHeight", 19, "Tree.leafIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.leafIcon.png"), "Tree.openIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.openIcon.png"), "Tree.closedIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Tree.closedIcon.png"), "Tree.showsRootHandles", Boolean.TRUE, "Viewport.opaque", Boolean.TRUE, "Quaqua.Debug.colorizePaintEvents", QuaquaManager.getProperty("Quaqua.Debug.colorizePaintEvents", "false"), "Quaqua.Debug.showClipBounds", QuaquaManager.getProperty("Quaqua.Debug.showClipBounds", "false").equals("true"), "Quaqua.Debug.showVisualBounds", QuaquaManager.getProperty("Quaqua.Debug.showVisualBounds", "false").equals("true"), "Quaqua.Debug.clipBoundsForeground", new AlphaColorUIResource(0, 0, 255, 128), "Quaqua.Debug.componentBoundsForeground", new AlphaColorUIResource(255, 0, 0, 128), "Quaqua.Debug.textBoundsForeground", new AlphaColorUIResource(255, 0, 0, 128), "ClassLoader", this.getClass().getClassLoader()};
        this.putDefaults(table, uiDefaults);
    }

    protected Object makeImage(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createImage", new Object[]{location});
    }

    protected Object makeBufferedImage(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createBufferedImage", new Object[]{location});
    }

    protected Object makeBufferedImage(String location, Rectangle subimage) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createBufferedImage", new Object[]{location, subimage});
    }

    public static Object makeIcon(Class baseClass, String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location});
    }

    public static Object makeIcon(Class baseClass, String location, Point shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location, shift});
    }

    public static Object makeIcon(Class baseClass, String location, Rectangle shiftAndSize) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{baseClass, location, shiftAndSize});
    }

    protected static Object makeIcons(String location, int states, boolean horizontal) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcons", new Object[]{location, states, horizontal});
    }

    protected static Object makeIcons(String location, Rectangle subimage, int states, boolean horizontal) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcons", new Object[]{location, subimage, states, horizontal});
    }

    public static Object makeNativeSidebarIcon(String path, int size, Color color, Color selectionColor) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeSidebarIcon", new Object[]{path, size, size, color, selectionColor});
    }

    public static Object makeNativeIcon(String path, int size) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeIcon", new Object[]{path, size});
    }

    public static Object makeNativeIcon(String path, int width, int height) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeIcon", new Object[]{path, width, height});
    }

    protected Object makeNativeButtonStateIcon(OSXAquaPainter.Widget widget, int xoffset, int yoffset, int width, int height, boolean withFocusRing) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeButtonStateIcon", new Object[]{widget, xoffset, yoffset, width, height, withFocusRing});
    }

    protected static Object makeButtonStateIcon(String location, int states) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, states});
    }

    protected static Object makeButtonStateIcon(String location, int states, Point shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, states, shift});
    }

    protected static Object makeButtonStateIcon(String location, int states, Rectangle shift) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createButtonStateIcon", new Object[]{location, states, shift});
    }

    protected static Object makeFrameButtonStateIcon(String location, int states) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createFrameButtonStateIcon", new Object[]{location, states});
    }

    protected static Object makeSliderThumbIcon(String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createSliderThumbIcon", new Object[]{location});
    }

    protected Object makeOverlaidButtonStateIcon(String location1, int states1, String location2, int states2, Rectangle layoutRect) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createOverlaidButtonStateIcon", new Object[]{location1, states1, location2, states2, layoutRect});
    }

    protected Object makeImageBevelBorder(String location, Rectangle subimage, Insets insets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, subimage, insets, insets, fill});
    }

    protected Object makeImageBevelBorder(String location, Insets insets) {
        return this.makeImageBevelBorder(location, insets, false);
    }

    protected Object makeImageBevelBorder(String location, Insets insets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, insets, fill});
    }

    protected Object makeImageBevelBorder(String location, Insets insets, boolean fill, Color fillColor) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, insets, insets, fill, fillColor});
    }

    protected Object makeImageBevelBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, imageInsets, borderInsets, fill});
    }

    protected Object makeImageBevelBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createBackgroundBorder", new Object[]{location, imageInsets, borderInsets, fill});
    }

    protected Object makeImageBevelBorders(String location, Insets insets, int states, boolean horizontal) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "create", new Object[]{location, insets, states, horizontal});
    }

    protected Object makeNativeImageBevelBorder(OSXAquaPainter.Widget widget, Insets painterInsets, Insets imageBevelInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createNativeImageBevelBorder", new Object[]{widget, painterInsets, imageBevelInsets, borderInsets, fill});
    }

    protected Object makeTextureColor(int rgb, String location) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.color.TextureColor$UIResource", new Object[]{rgb, location});
    }

    protected Object makeButtonStateBorder(String location, int tileCount, boolean isTiledHorizontaly, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createButtonStateBorder", new Object[]{location, tileCount, isTiledHorizontaly, imageInsets, borderInsets, fill});
    }

    protected Object makeNativeButtonStateBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets, boolean withFocusRing) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaBorderFactory", "createNativeButtonStateBorder", new Object[]{widget, imageInsets, borderInsets, withFocusRing});
    }

    protected void initDesignDefaults(UIDefaults table) {
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    protected boolean isJaguarTabbedPane() {
        String property;
        try {
            property = QuaquaManager.getProperty("Quaqua.tabLayoutPolicy");
            if (property == null) {
                property = QuaquaManager.getProperty("Quaqua.TabbedPane.design", "auto");
            }
        }
        catch (AccessControlException e) {
            property = "auto";
        }
        return property.equals("jaguar") || property.equals("wrap");
    }

    protected void installKeyboardFocusManager() {
        String javaVersion;
        if (QuaquaManager.getProperty("Quaqua.TextComponent.autoSelect", "true").equals("true") && (javaVersion = QuaquaManager.getProperty("java.version", "")).startsWith("1.5")) {
            try {
                KeyboardFocusManager.setCurrentKeyboardFocusManager(new QuaquaKeyboardFocusManager());
            }
            catch (SecurityException ex) {
                System.err.print("Warning: " + this + " couldn't install QuaquaKeyboardFocusManager.");
            }
        }
    }

    protected void installPopupFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installMouseGrabber() {
        if (this.isUIIncluded("PopupMenuUI")) {
            AppContext context = AppContext.getAppContext();
            StringBuilder stringBuilder = QuaquaPopupMenuUI.MOUSE_GRABBER_KEY;
            synchronized (stringBuilder) {
                Object mouseGrabber = context.get(QuaquaPopupMenuUI.MOUSE_GRABBER_KEY);
                if (mouseGrabber == null) {
                    mouseGrabber = new QuaquaPopupMenuUI.MouseGrabber();
                    context.put(QuaquaPopupMenuUI.MOUSE_GRABBER_KEY, mouseGrabber);
                }
            }
            stringBuilder = QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY;
            synchronized (stringBuilder) {
                Object helper = context.get(QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY);
                if (helper == null) {
                    helper = new QuaquaPopupMenuUI.MenuKeyboardHelper();
                    context.put(QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY, helper);
                    MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                    msm.addChangeListener((QuaquaPopupMenuUI.MenuKeyboardHelper)helper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallMouseGrabber() {
        AppContext context = AppContext.getAppContext();
        StringBuilder stringBuilder = QuaquaPopupMenuUI.MOUSE_GRABBER_KEY;
        synchronized (stringBuilder) {
            Object mouseGrabber = context.get(QuaquaPopupMenuUI.MOUSE_GRABBER_KEY);
            if (mouseGrabber instanceof QuaquaPopupMenuUI.MouseGrabber) {
                ((QuaquaPopupMenuUI.MouseGrabber)mouseGrabber).uninstall();
                context.put(QuaquaPopupMenuUI.MOUSE_GRABBER_KEY, null);
            }
        }
        stringBuilder = QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY;
        synchronized (stringBuilder) {
            Object helper = context.get(QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY);
            if (helper instanceof QuaquaPopupMenuUI.MenuKeyboardHelper) {
                context.put(QuaquaPopupMenuUI.MENU_KEYBOARD_HELPER_KEY, null);
                ((QuaquaPopupMenuUI.MenuKeyboardHelper)helper).uninstall();
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                msm.removeChangeListener((QuaquaPopupMenuUI.MenuKeyboardHelper)helper);
            }
        }
    }

    protected boolean isUIIncluded(String ui) {
        Set included = QuaquaManager.getIncludedUIs();
        Set excluded = QuaquaManager.getExcludedUIs();
        if (excluded == null) {
            return false;
        }
        if (included == null && excluded.isEmpty()) {
            return true;
        }
        if (included != null && excluded.isEmpty()) {
            return included.contains(ui);
        }
        if (included == null) {
            return !excluded.contains(ui);
        }
        return included.contains(ui) && !excluded.contains(ui);
    }

    protected void putDefaults(UIDefaults table, Object[] keyValueList) {
        Set included = QuaquaManager.getIncludedUIs();
        Set excluded = QuaquaManager.getExcludedUIs();
        if (excluded == null) {
            return;
        }
        if (included == null && excluded.isEmpty()) {
            table.putDefaults(keyValueList);
        } else if (included != null && excluded.isEmpty()) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && !name.equals("Component") && !included.contains(name)) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else if (included == null) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && excluded.contains(name)) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && (!name.equals("Component") && !included.contains(name) || excluded.contains(name))) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        }
    }

    @Override
    public void uninitialize() {
        this.uninstallPopupFactory();
        this.uninstallKeyboardFocusManager();
        this.uninstallMouseGrabber();
        super.uninitialize();
    }

    protected void uninstallPopupFactory() {
        try {
            if (PopupFactory.getSharedInstance() instanceof QuaquaPopupFactory) {
                PopupFactory.setSharedInstance(new PopupFactory());
            }
        }
        catch (SecurityException ex) {
            System.err.print("Warning: " + this + " couldn't uninstall QuaquaPopupFactory.");
        }
    }

    protected void uninstallKeyboardFocusManager() {
        try {
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager() instanceof QuaquaKeyboardFocusManager) {
                KeyboardFocusManager.setCurrentKeyboardFocusManager(new DefaultKeyboardFocusManager());
            }
        }
        catch (SecurityException ex) {
            System.err.print("Warning: " + this + " couldn't uninstall QuaquaKeyboardFocusManager.");
        }
    }
}

