/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.File;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class JDynFormFieldFile
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected File assignedValue = null;
    protected File currentValue = null;
    protected JTextComponent jtext = null;
    protected JButton jbutton = null;
    protected boolean readonly = false;

    public JDynFormFieldFile(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (File)value;
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        if (this.contents != null) {
            if (readonly) {
                this.jtext.setEditable(false);
                this.jbutton.setEnabled(false);
            } else {
                this.jtext.setEditable(true);
                this.jbutton.setEnabled(true);
            }
        }
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        JTextComponent text;
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        this.jtext = text = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
        this.fixPreferredWidth(text);
        text.addFocusListener(this);
        this.jtext.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldFile.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JDynFormFieldFile.this.fireFieldExitEvent();
            }
        });
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JDynFormFieldFile.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JDynFormFieldFile.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JDynFormFieldFile.this.fireFieldChangedEvent();
            }
        });
        this.jbutton = this.getComponentsFactory().getJButton(this.getDefinition(), null);
        if (this.jbutton == null) {
            this.jbutton = new JButton();
        }
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.jbutton, (String)this.getButtonTooltip(), (String)this.getButtonImageName(), e -> {
            this.fireFieldEnterEvent();
            this.onClickBrowse();
        }, (FocusListener)new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldFile.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JDynFormFieldFile.this.fireFieldExitEvent();
            }
        });
        this.contents.add((Component)this.jtext, "Center");
        this.contents.add((Component)this.jbutton, "After");
        this.contents.setVisible(true);
        if (this.readonly) {
            this.jtext.setEditable(false);
            this.jbutton.setEnabled(false);
        } else {
            this.jtext.setEditable(true);
            this.jbutton.setEnabled(true);
        }
        this.setValue(this.assignedValue);
    }

    public void onClickBrowse() {
        File[] x;
        this.fireFieldEnterEvent();
        File previous = this.currentValue;
        this.problemIndicator().restore();
        File initialPath = null;
        FileNameExtensionFilter filter = null;
        Tags tags = this.getDefinition().getTags();
        if (tags.has("path")) {
            initialPath = new File((String)tags.get("path"));
        }
        if (tags.has("filter")) {
            try {
                String extensions;
                String filterDescription = extensions = (String)tags.get("filter");
                if (tags.has("filterDescription")) {
                    filterDescription = (String)tags.get("filterDescription");
                }
                filter = new FileNameExtensionFilter(filterDescription, extensions.split("[|]"));
            }
            catch (Exception extensions) {
                // empty catch block
            }
        }
        if (this.currentValue != null) {
            initialPath = this.currentValue.getParentFile();
        }
        if ((x = this.showOpenFileDialog(this.getLabel(), initialPath, filter)) == null) {
            return;
        }
        this.currentValue = x[0];
        this.jtext.setText(x[0].getPath());
        this.fireFieldChangedEventIfChanged(previous);
    }

    private void fireFieldChangedEventIfChanged(File previous) {
        if (previous == null) {
            if (this.currentValue == null) {
                return;
            }
            this.fireFieldChangedEvent();
            return;
        }
        if (this.currentValue == null) {
            this.fireFieldChangedEvent();
            return;
        }
        if (previous.getPath().equals(this.currentValue.getPath())) {
            this.fireFieldChangedEvent();
        }
    }

    public void setValue(Object value) {
        File previous = this.currentValue;
        if (value == null) {
            this.jtext.setText("");
        } else {
            if (!(value instanceof File)) {
                LOGGER.info("setValue invoked with non File value (" + value.toString() + ").");
                return;
            }
            this.jtext.setText(((File)value).getPath());
            this.fixPreferredWidth(this.jtext);
        }
        this.currentValue = this.assignedValue = (File)value;
        this.fireFieldChangedEventIfChanged(previous);
    }

    public Object getValue() {
        File value = null;
        String s = "";
        s = this.jtext.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        value = new File(s);
        return value;
    }

    public boolean hasValidValue() {
        return true;
    }

    protected String getButtonTooltip() {
        return "_Select_file";
    }

    protected String getButtonImageName() {
        return "picker-file";
    }

    public File[] showOpenFileDialog(String title, File initialPath, FileFilter filter) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, filter, true);
    }

    public File[] showChooserDialog(String title, int type, int selectionMode, boolean multiselection, File initialPath, FileFilter filter, boolean fileHidingEnabled) {
        File[] returnValue = null;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setDialogType(type);
        fc.setFileSelectionMode(selectionMode);
        fc.setMultiSelectionEnabled(multiselection);
        fc.setCurrentDirectory(initialPath);
        fc.setFileFilter(filter);
        fc.setFileHidingEnabled(fileHidingEnabled);
        int r = 1;
        switch (type) {
            case 1: {
                r = fc.showSaveDialog(this.contents);
                break;
            }
            default: {
                r = fc.showOpenDialog(this.contents);
            }
        }
        returnValue = r != 0 ? null : (fc.isMultiSelectionEnabled() ? fc.getSelectedFiles() : new File[]{fc.getSelectedFile()});
        return returnValue;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void clear() {
        Object value = this.getDefinition().getDefaultValue();
        value = value != null ? value.toString() : "";
        this.jtext.setText((String)value);
    }

    protected Object getAbsoluteFile(Object value) {
        Tags tags;
        if (!(value instanceof File)) {
            return value;
        }
        File f = (File)value;
        if (!f.isAbsolute() && (tags = this.getDefinition().getTags()).has("path")) {
            File folder = tags.get("path") instanceof File ? (File)tags.get("path") : new File(Objects.toString(tags.get("path"), null));
            File f2 = new File(folder, f.getPath());
            if (f2.exists()) {
                f = f2;
            } else {
                folder = ToolsLocator.getFoldersManager().get("Project");
                if (folder != null) {
                    f = new File(folder, f.getPath());
                }
            }
        }
        return f;
    }

    public boolean isModified() {
        String s = this.jtext.getText();
        File assigned = (File)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)s)) {
            return assigned != null;
        }
        try {
            File value = new File(s);
            return !Objects.equals(value, assigned);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

