/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class TimeFunction
extends AbstractFunction {
    public TimeFunction() {
        super("Date", "TIME", Range.is((Comparable)Integer.valueOf(1)), "Returns a time from the arguments", "TIME({{time}})", new String[]{"time - a string with a time"}, "Time", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object date_obj = this.getObject(args, 0);
        if (date_obj instanceof Date) {
            Time x = new Time(((Date)date_obj).getTime());
            return x;
        }
        String date = this.getStr(args, 0);
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            Date x0 = df.parse(date);
            Time x = new Time(x0.getTime());
            return x;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't parse time value '" + date + "' expected format 'HH:mm:ss'.", ex);
        }
    }

    public String template() {
        Time now = new Time(System.currentTimeMillis());
        return "TIME '{{" + now.toString() + "}}'";
    }
}

