/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CosFunction
extends AbstractFunction {
    public CosFunction() {
        super("Numeric", "COS", Range.is((Comparable)Integer.valueOf(1)), "Returns the trigonometric cosine of an angle. Special cases:\n- If the argument is NaN or an infinity, then the result is NaN.\nThe computed result must be within 1 ulp of the exact result. Results must be semi-monotonic.", "COS({{a}})", new String[]{"a - an angle, in radians."}, "Double", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r = Math.cos(this.getDouble(args, 0));
        return r;
    }
}

