/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.controls.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.gvsig.gui.beans.controls.dnd.CellCoordinates;
import org.gvsig.gui.beans.controls.dnd.JDnDTableModel;

public class JDnDTable
extends JTable
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private static final long serialVersionUID = -5479369256188567414L;
    private CellCoordinates overCellCoordinates = null;
    private DragSource dragSource = new DragSource();
    private CellCoordinates[] selectedCells;
    private boolean dragging;
    private CellCoordinates currSelectedCell;
    static final short FREE_CELL_MOVING = -4;
    public static final short ONLY_ALLOW_MOVING_ROWS = -2;
    public static final short ONLY_ALLOW_MOVING_COLUMNS = -1;

    public JDnDTable() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    public JDnDTable(JDnDTableModel model) {
        super(model);
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        Point thisLocation = this.getLocationOnScreen();
        Point clickLocation = dsde.getLocation();
        Point2D.Double relativeLocation = new Point2D.Double(clickLocation.getX() - thisLocation.getX(), clickLocation.getY() - thisLocation.getY());
        this.overCellCoordinates = this.locationToCellCoord(relativeLocation);
    }

    public void setSelectionMode(short mode) {
        if (mode == -1) {
            this.setColumnSelectionAllowed(true);
            this.setRowSelectionAllowed(false);
        } else if (mode == -2) {
            this.setColumnSelectionAllowed(false);
            this.setRowSelectionAllowed(true);
        }
        ((JDnDTableModel)this.getModel()).setSelectionMode(mode);
    }

    private CellCoordinates locationToCellCoord(Point2D location) {
        int[] ij = new int[2];
        int width = (int)location.getX();
        int height = (int)location.getY();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int iColumnWidth = this.getColumnModel().getColumn(i).getWidth();
            if (width - iColumnWidth <= 0) {
                ij[1] = i;
                break;
            }
            width -= iColumnWidth;
        }
        int jRowHeight = this.getRowHeight();
        for (int j = 0; j < this.getRowCount(); ++j) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                TableCellRenderer renderer = this.getCellRenderer(j, c);
                Component comp = this.prepareRenderer(renderer, j, c);
                int h = comp.getPreferredSize().height - 2 * this.rowMargin;
                jRowHeight = Math.max(jRowHeight, h);
            }
            if (height - jRowHeight <= 0) {
                ij[0] = j;
                break;
            }
            height -= jRowHeight;
        }
        return new CellCoordinates(ij[0], ij[1]);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        System.out.println("dragDropEnd");
        this.dragging = false;
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.overCellCoordinates = null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.selectedCells = this.getSelectedCells();
        Object[] selectedObjects = this.getSelectedValues();
        if (selectedObjects.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < selectedObjects.length; ++i) {
                sb.append(selectedObjects[i].toString() + "\n");
            }
            StringSelection text = new StringSelection(sb.toString());
            this.dragging = true;
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, text, this);
            System.err.println("Selected objects\n" + sb.toString());
        }
    }

    private Object[] getSelectedValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.selectedCells.length);
        for (int i = 0; i < this.selectedCells.length; ++i) {
            values.add(this.getValueAt(this.selectedCells[i].i, this.selectedCells[i].j));
        }
        return values.toArray();
    }

    private CellCoordinates[] getSelectedCells() {
        ArrayList<CellCoordinates> cells = new ArrayList<CellCoordinates>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (!this.isCellSelected(i, j)) continue;
                cells.add(new CellCoordinates(i, j));
            }
        }
        return cells.toArray(new CellCoordinates[0]);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        System.out.println("dragEnter");
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        CellCoordinates overCellCoordinates = this.locationToCellCoord(dtde.getLocation());
        if (overCellCoordinates != null && !overCellCoordinates.equals(this.overCellCoordinates)) {
            this.currSelectedCell = this.overCellCoordinates = overCellCoordinates;
            System.out.println("Current cell  [" + this.currSelectedCell.i + "," + this.currSelectedCell.j + "]");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(2);
                CellCoordinates newCellCoord = this.locationToCellCoord(dtde.getLocation());
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st = new StringTokenizer(s);
                ArrayList<String> items = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    items.add(st.nextToken());
                }
                JDnDTableModel model = (JDnDTableModel)this.getModel();
                if (this.dragging) {
                    model.itemsMoved(newCellCoord, this.selectedCells);
                } else {
                    model.insertItems(newCellCoord, items);
                }
                this.overCellCoordinates = null;
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            System.err.println("Exception" + exception.getMessage());
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            ufException.printStackTrace();
            System.err.println("Exception" + ufException.getMessage());
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        System.out.println("dragExit");
    }
}

