/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.i18n;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.gvsig.i18n.MessagesClassLoader;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    private static Logger logger = LoggerFactory.getLogger((String)"Messages");
    private static String _CLASSNAME = "org.gvsig.i18n.Messages";
    private static Locale currentLocale;
    private static ArrayList localeResources;
    private static ArrayList preferredLocales;
    private static Set notTranslatedKeys;
    private static Set resourceFamilies;
    private static Set classLoaders;
    private static List<FamilyDescriptor> familyDescriptors;
    private static String baseLanguage;
    private static Locale baseLocale;

    public static String getText(String key, String callerName) {
        if (key == null) {
            return null;
        }
        for (int numLocale = 0; numLocale < localeResources.size(); ++numLocale) {
            String translation = ((Properties)localeResources.get(numLocale)).getProperty(key);
            if (translation == null || translation.equals("")) continue;
            return translation;
        }
        Messages.addNotTranslatedKey(key, callerName, true);
        return key;
    }

    public static String getText(String key, String[] arguments, String callerName) {
        String translation = Messages.getText(key, callerName);
        if (translation != null && arguments != null) {
            try {
                translation = MessageFormat.format(translation, arguments);
            }
            catch (IllegalFormatException ex) {
                logger.error(callerName + " -- Error formating key: " + key + " -- " + translation);
            }
        }
        return translation;
    }

    public static String translate(String message, String[] args) {
        String msg = message;
        if (msg == null) {
            return "";
        }
        if ((msg = Messages.getText(msg, args)) == null) {
            msg = "_" + message.replace("_", " ");
        }
        return msg;
    }

    public static String translate(String message) {
        String msg = message;
        if (msg == null) {
            return "";
        }
        if ((msg = Messages.getText(msg, (String[])null)) == null || msg.startsWith("_")) {
            msg = "_" + message.replace("_", " ");
        }
        return msg;
    }

    public static String getText(String key) {
        return Messages.getText(key, _CLASSNAME);
    }

    public static String getText(String key, String[] arguments) {
        return Messages.getText(key, arguments, _CLASSNAME);
    }

    public static String getText(String key, boolean log) {
        return Messages.getText(key, _CLASSNAME, log);
    }

    public static String getText(String key, String[] arguments, boolean log) {
        String translation;
        block3: {
            translation = Messages.getText(key, _CLASSNAME, log);
            if (translation != null && arguments != null) {
                try {
                    translation = MessageFormat.format(translation, arguments);
                }
                catch (IllegalFormatException ex) {
                    if (!log) break block3;
                    logger.error(_CLASSNAME + " -- Error formating key: " + key + " -- " + translation);
                }
            }
        }
        return translation;
    }

    public static String getText(String key, String callerName, boolean log) {
        if (key == null) {
            return null;
        }
        for (int numLocale = 0; numLocale < localeResources.size(); ++numLocale) {
            String translation = ((Properties)localeResources.get(numLocale)).getProperty(key);
            if (translation == null || translation.equals("")) continue;
            return translation;
        }
        Messages.addNotTranslatedKey(key, callerName, log);
        return null;
    }

    public static String getText(String key, String[] arguments, String callerName, boolean log) {
        String translation;
        block3: {
            translation = Messages.getText(key, callerName, log);
            if (translation != null) {
                try {
                    translation = MessageFormat.format(translation, arguments);
                }
                catch (IllegalFormatException ex) {
                    if (!log) break block3;
                    logger.error(callerName + " -- Error formating key: " + key + " -- " + translation);
                }
            }
        }
        return translation;
    }

    public static void addResourceFamily(String family, ClassLoader loader) {
        Messages.addResourceFamily(family, loader, "");
    }

    public static void addResourceFamily(String family, File[] dirList) throws MalformedURLException {
        URL[] urls = new URL[dirList.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = dirList[i].toURL();
        }
        MessagesClassLoader loader = new MessagesClassLoader(urls);
        Messages.addResourceFamily(family, loader, "");
    }

    public static void addResourceFamily(String family, File folder) throws MalformedURLException {
        URL[] urls = new URL[]{folder.toURI().toURL()};
        MessagesClassLoader loader = new MessagesClassLoader(urls);
        for (FamilyDescriptor familyDescriptor : familyDescriptors) {
            if (!familyDescriptor.callerName.equals(folder.getAbsolutePath()) || !familyDescriptor.family.equals(family)) continue;
            return;
        }
        Messages.addResourceFamily(family, loader, folder.getAbsolutePath());
    }

    public static void addResourceFamily(String family, ClassLoader loader, String callerName) {
        int totalLocales = preferredLocales.size();
        if (totalLocales == 0) {
            logger.warn("There is not preferred languages list. Maybe the Messages class was not initialized");
        }
        familyDescriptors.add(new FamilyDescriptor(family, loader, callerName));
        resourceFamilies.add(family);
        classLoaders.add(loader);
        for (int numLocale = 0; numLocale < totalLocales; ++numLocale) {
            Locale lang = (Locale)preferredLocales.get(numLocale);
            Properties translations = (Properties)localeResources.get(numLocale);
            Messages.addResourceFamily(lang, translations, family, loader, callerName);
        }
    }

    private static void addResourceFamily(Locale lang, Properties translations, String family, ClassLoader loader, String callerName) {
        logger.debug("addResourceFamily " + lang.toString() + ", " + family + ", " + loader.toString());
        Properties properties = new Properties();
        String langCode = lang.toString();
        String resource = family.replace('.', '/') + "_" + langCode + ".properties";
        URL resourceURL = loader.getResource(resource);
        InputStream is = URLUtils.openStream((URL)resourceURL);
        if (is == null && langCode.contains("_")) {
            try {
                langCode = langCode.split("_")[0];
                resource = family.replace('.', '/') + "_" + langCode + ".properties";
                resourceURL = loader.getResource(resource);
                is = URLUtils.openStream((URL)resourceURL);
                if (is == null) {
                    resource = family.replace('.', '/') + ".properties";
                    resourceURL = loader.getResource(resource);
                    is = URLUtils.openStream((URL)resourceURL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException iOException) {}
        } else if (lang.equals(baseLocale) && (is = URLUtils.openStream((URL)(resourceURL = loader.getResource(resource = family.replace('.', '/') + ".properties")))) != null) {
            try {
                properties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (resourceURL != null && logger.isDebugEnabled()) {
            logger.debug("Load resources from '" + resourceURL.toString() + "' with classloader {" + loader.toString() + "}.");
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String currentKey = (String)keys.nextElement();
            if (translations.containsKey(currentKey)) continue;
            translations.put(currentKey, properties.getProperty(currentKey));
        }
    }

    public static void addResourceFamily(String family, String callerName) {
        Messages.addResourceFamily(family, Messages.class.getClassLoader(), callerName);
    }

    public static ArrayList getPreferredLocales() {
        return preferredLocales;
    }

    public static void setPreferredLocales(ArrayList preferredLocalesList) {
        logger.info("setPreferredLocales " + preferredLocalesList.toString());
        Iterator oldLocales = preferredLocales.iterator();
        while (oldLocales.hasNext()) {
            Messages.removeLocale((Locale)oldLocales.next());
        }
        for (int numLocale = 0; numLocale < preferredLocalesList.size(); ++numLocale) {
            Messages.addLocale((Locale)preferredLocalesList.get(numLocale));
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static void setCurrentLocale(Locale locale) {
        Locale[] alternatives = null;
        String localeStr = locale.getLanguage();
        alternatives = localeStr.equals("es") || localeStr.equals("ca") || localeStr.equals("gl") || localeStr.equals("eu") || localeStr.equals("vl") ? new Locale[]{new Locale("es"), new Locale("en")} : new Locale[]{new Locale("en"), new Locale("es")};
        Messages.setCurrentLocale(locale, alternatives);
    }

    public static void setCurrentLocale(Locale locale, Locale[] alternatives) {
        logger.info("setCurrentLocale " + locale.toString());
        resourceFamilies = new HashSet();
        classLoaders = new HashSet();
        localeResources = new ArrayList();
        preferredLocales = new ArrayList();
        notTranslatedKeys = new HashSet();
        Messages.addLocale(locale);
        for (int i = 0; i < alternatives.length; ++i) {
            Messages.addLocale(alternatives[i]);
        }
        for (int curlocale = 0; curlocale < preferredLocales.size(); ++curlocale) {
            for (int curfamily = 0; curfamily < familyDescriptors.size(); ++curfamily) {
                FamilyDescriptor family = familyDescriptors.get(curfamily);
                Messages.addResourceFamily((Locale)preferredLocales.get(curlocale), (Properties)localeResources.get(curlocale), family.family, family.loader, family.callerName);
            }
        }
        currentLocale = locale;
        Locale.setDefault(locale);
    }

    public static void addLocale(Locale lang) {
        if (!preferredLocales.contains(lang)) {
            logger.info("addLocale " + lang.toString());
            preferredLocales.add(lang);
            Properties dict = new Properties();
            localeResources.add(dict);
        }
    }

    public static boolean removeLocale(Locale lang) {
        int numLocale = preferredLocales.indexOf(lang);
        if (numLocale != -1) {
            try {
                preferredLocales.remove(numLocale);
                localeResources.remove(numLocale);
            }
            catch (IndexOutOfBoundsException ex) {
                logger.warn(_CLASSNAME + "." + "removeLocale: " + ex.getLocalizedMessage(), (Throwable)ex);
            }
            return true;
        }
        return false;
    }

    public static void removeResources() {
        for (int numLocale = 0; numLocale < localeResources.size(); ++numLocale) {
            ((Properties)localeResources.get(numLocale)).clear();
        }
    }

    protected static int size(Locale lang) {
        int numLocale = preferredLocales.indexOf(lang);
        if (numLocale != -1) {
            return ((Properties)localeResources.get(numLocale)).size();
        }
        return 0;
    }

    protected static Set keySet(Locale lang) {
        int numLocale = preferredLocales.indexOf(lang);
        if (numLocale != -1) {
            return ((Properties)localeResources.get(numLocale)).keySet();
        }
        return null;
    }

    public static boolean hasLocales() {
        return preferredLocales.size() > 0;
    }

    public static String getBaseLanguage() {
        return baseLanguage;
    }

    public static void setBaseLanguage(String lang) {
        baseLanguage = lang;
        baseLocale = new Locale(baseLanguage);
    }

    public static Properties getAllTexts(Locale lang) {
        Properties texts = new Properties();
        Messages.getAllTexts(lang, null, texts);
        Iterator iterator = classLoaders.iterator();
        while (iterator.hasNext()) {
            Messages.getAllTexts(lang, (ClassLoader)iterator.next(), texts);
        }
        return texts;
    }

    private static void getAllTexts(Locale lang, ClassLoader classLoader, Properties texts) {
        ClassLoader loader = classLoader == null ? Messages.class.getClassLoader() : classLoader;
        for (String family : resourceFamilies) {
            Messages.addResourceFamily(lang, texts, family, loader, "Messages.getAllTexts");
        }
    }

    public static Properties getTranslations(Locale locale) {
        Properties translations = new Properties();
        for (int curfamily = 0; curfamily < familyDescriptors.size(); ++curfamily) {
            FamilyDescriptor family = familyDescriptors.get(curfamily);
            Messages.addResourceFamily(locale, translations, family.family, family.loader, family.callerName);
        }
        return translations;
    }

    private static void addNotTranslatedKey(String key, String callerName, boolean log) {
        if (!notTranslatedKeys.contains(key)) {
            if (log) {
                logger.trace("[" + callerName + "] Cannot find translation for key '" + key + "'.");
            }
            notTranslatedKeys.add(key);
        }
    }

    public static List getNotTranslatedKeys() {
        ArrayList l = new ArrayList(notTranslatedKeys);
        return l;
    }

    static {
        localeResources = new ArrayList();
        preferredLocales = new ArrayList();
        notTranslatedKeys = new HashSet();
        resourceFamilies = new HashSet();
        classLoaders = new HashSet();
        familyDescriptors = new ArrayList<FamilyDescriptor>();
        baseLanguage = "es";
        baseLocale = new Locale(baseLanguage);
    }

    private static class FamilyDescriptor {
        String family = null;
        ClassLoader loader = null;
        String callerName = null;

        public FamilyDescriptor(String family, ClassLoader loader, String callerName) {
            this.family = family;
            this.loader = loader;
            this.callerName = callerName;
        }
    }
}

